/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.task.BaseMapTask;
import net.techbrew.journeymap.task.ITaskManager;

public class MapPlayerTask
extends BaseMapTask {
    private static final Logger logger = JourneyMap.getLogger();
    private static ChunkMD.Set lastChunkStubs = new ChunkMD.Set(512);
    private static ChunkCoordinates lastPlayerPos;
    private static Boolean lastUnderground;
    static Integer chunkOffset;

    private MapPlayerTask(World world, int dimension, boolean underground, Integer chunkY, ChunkMD.Set chunkStubs) {
        super(world, dimension, underground, chunkY, chunkStubs, false);
    }

    public static BaseMapTask create(EntityPlayer player) {
        boolean skipUnchanged;
        int missing = 0;
        if (chunkOffset == null) {
            chunkOffset = PropertyManager.getInstance().getInteger(PropertyManager.Key.CHUNK_OFFSET);
        }
        int offset = chunkOffset;
        ChunkCoordinates playerPos = new ChunkCoordinates(player.field_70176_ah, player.field_70162_ai, player.field_70164_aj);
        Map playerData = DataCache.instance().get(PlayerData.class);
        boolean underground = (Boolean)playerData.get((Object)EntityKey.underground) != false && PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_CAVES) != false;
        int dimension = (Integer)playerData.get((Object)EntityKey.dimension);
        if (lastUnderground == null) {
            lastUnderground = underground;
        }
        if (lastPlayerPos == null) {
            lastPlayerPos = playerPos;
        }
        boolean bl = skipUnchanged = lastUnderground == underground;
        if (skipUnchanged && underground) {
            boolean bl2 = skipUnchanged = playerPos.field_71572_b == MapPlayerTask.lastPlayerPos.field_71572_b;
        }
        if (lastPlayerPos.equals((Object)playerPos) && offset >= 2) {
            offset /= 2;
        }
        lastPlayerPos = playerPos;
        lastUnderground = underground;
        int side = offset + offset + 1;
        int capacity = side * side + side * side / 4;
        ChunkMD.Set chunks = new ChunkMD.Set(capacity);
        World world = player.field_70170_p;
        Integer chunkY = underground ? Integer.valueOf(MapPlayerTask.lastPlayerPos.field_71572_b) : null;
        ChunkCoordIntPair min = new ChunkCoordIntPair(MapPlayerTask.lastPlayerPos.field_71574_a - offset, MapPlayerTask.lastPlayerPos.field_71573_c - offset);
        ChunkCoordIntPair max = new ChunkCoordIntPair(MapPlayerTask.lastPlayerPos.field_71574_a + offset, MapPlayerTask.lastPlayerPos.field_71573_c + offset);
        for (int x = min.field_77276_a; x <= max.field_77276_a; ++x) {
            for (int z = min.field_77275_b; z <= max.field_77275_b; ++z) {
                ChunkCoordIntPair coord = new ChunkCoordIntPair(x, z);
                ChunkMD chunkMd = (ChunkMD)lastChunkStubs.get(coord);
                chunkMd = chunkMd == null ? ChunkLoader.getChunkStubFromMemory(x, z, world) : ChunkLoader.refreshChunkStubFromMemory(chunkMd, world);
                if (chunkMd != null) {
                    chunkMd.render = true;
                    chunks.add(chunkMd);
                    continue;
                }
                ++missing;
            }
        }
        int initialSize = chunks.size();
        if (!lastChunkStubs.isEmpty()) {
            ChunkMD.Set removed = new ChunkMD.Set(64);
            for (ChunkMD oldChunk : lastChunkStubs) {
                if (!chunks.containsKey(oldChunk.coord)) {
                    if (oldChunk.discard(1) <= 4) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Discarding out-of-range chunk: " + oldChunk);
                    }
                    removed.add(oldChunk);
                    continue;
                }
                oldChunk.discard(-1);
                ChunkMD newChunk = (ChunkMD)chunks.get(oldChunk.coord);
                if (skipUnchanged && (newChunk.coord.field_77276_a != MapPlayerTask.lastPlayerPos.field_71574_a || newChunk.coord.field_77275_b != MapPlayerTask.lastPlayerPos.field_71573_c) && newChunk.stub.equalTo(oldChunk.stub)) {
                    newChunk.render = false;
                }
                if (!newChunk.render.booleanValue() || !logger.isLoggable(Level.FINE)) continue;
                logger.fine("Mapping chunk: " + newChunk);
            }
            lastChunkStubs.keySet().removeAll(removed.keySet());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Chunks in set: " + chunks.size() + ".  lastChunkStubs=" + lastChunkStubs.size());
        }
        return new MapPlayerTask(world, dimension, underground, chunkY, chunks);
    }

    public static void clearCache() {
        lastChunkStubs.clear();
        lastPlayerPos = null;
        lastUnderground = null;
        chunkOffset = null;
    }

    @Override
    public void taskComplete() {
        lastChunkStubs.putAll(this.chunkMdSet);
    }

    public static class Manager
    implements ITaskManager {
        boolean enabled;

        public Class<? extends BaseMapTask> getTaskClass() {
            return MapPlayerTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            this.enabled = true;
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            this.enabled = false;
        }

        @Override
        public BaseMapTask getTask(Minecraft minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (minecraft.field_71439_g.field_70175_ag) {
                BaseMapTask baseMapTask = MapPlayerTask.create((EntityPlayer)minecraft.field_71439_g);
                return baseMapTask;
            }
            return null;
        }

        @Override
        public void taskAccepted(boolean accepted) {
        }
    }
}

