/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.task.ITask;
import net.techbrew.journeymap.task.ITaskManager;
import net.techbrew.journeymap.task.LegacyMigrationTask;
import net.techbrew.journeymap.task.MapPlayerTask;
import net.techbrew.journeymap.task.MapRegionTask;
import net.techbrew.journeymap.task.SaveMapTask;
import net.techbrew.journeymap.thread.TaskThread;

public class TaskController {
    static final Logger logger = JourneyMap.getLogger();
    final int mapTaskDelay = PropertyManager.getInstance().getInteger(PropertyManager.Key.UPDATETIMER_CHUNKS);
    final List<ITaskManager> managers = new LinkedList<ITaskManager>();

    public TaskController() {
        this.managers.add(new LegacyMigrationTask.Manager());
        this.managers.add(new MapRegionTask.Manager());
        this.managers.add(new SaveMapTask.Manager());
        this.managers.add(new MapPlayerTask.Manager());
    }

    public void enableTasks(Minecraft minecraft) {
        TaskThread.reset();
        LinkedList<ITaskManager> list = new LinkedList<ITaskManager>(this.managers);
        for (ITaskManager manager : this.managers) {
            boolean enabled = manager.enableTask(minecraft, null);
            if (!enabled) {
                logger.fine("Task not initially enabled: " + manager.getTaskClass().getSimpleName());
                continue;
            }
            logger.fine("Task ready: " + manager.getTaskClass().getSimpleName());
        }
    }

    public void clear() {
        this.managers.clear();
    }

    private ITaskManager getManager(Class<? extends ITaskManager> managerClass) {
        ITaskManager taskManager = null;
        for (ITaskManager manager : this.managers) {
            if (manager.getClass() != managerClass) continue;
            taskManager = manager;
            break;
        }
        return taskManager;
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        ITaskManager taskManager = this.getManager(managerClass);
        if (taskManager != null) {
            return taskManager.isEnabled(Minecraft.func_71410_x());
        }
        logger.warning("Couldn't toggle task; manager not in controller: " + managerClass.getClass().getName());
        return false;
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        ITaskManager taskManager = null;
        for (ITaskManager manager : this.managers) {
            if (manager.getClass() != managerClass) continue;
            taskManager = manager;
            break;
        }
        if (taskManager != null) {
            this.toggleTask(taskManager, enable, params);
        } else {
            logger.warning("Couldn't toggle task; manager not in controller: " + managerClass.getClass().getName());
        }
    }

    private void toggleTask(ITaskManager manager, boolean enable, Object params) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (manager.isEnabled(minecraft)) {
            if (!enable) {
                logger.fine("Disabling task: " + manager.getTaskClass().getSimpleName());
                manager.disableTask(minecraft);
            } else {
                logger.fine("Task already enabled: " + manager.getTaskClass().getSimpleName());
            }
        } else if (enable) {
            logger.fine("Enabling task: " + manager.getTaskClass().getSimpleName());
            manager.enableTask(minecraft, params);
        } else {
            logger.fine("Task already disabled: " + manager.getTaskClass().getSimpleName());
        }
    }

    public void disableTasks(Minecraft minecraft) {
        for (ITaskManager manager : this.managers) {
            if (!manager.isEnabled(minecraft)) continue;
            manager.disableTask(minecraft);
            logger.fine("Task disabled: " + manager.getTaskClass().getSimpleName());
        }
    }

    public void performTasks(Minecraft minecraft, ScheduledExecutorService taskExecutor) {
        if (!TaskThread.hasQueue()) {
            ITask task = null;
            ITaskManager manager = this.getNextManager(minecraft);
            if (manager == null) {
                logger.warning("No task managers enabled!");
                return;
            }
            boolean accepted = false;
            StatTimer timer = StatTimer.get(manager.getTaskClass().getSimpleName() + ".Manager.getTask").start();
            task = manager.getTask(minecraft);
            if (task != null) {
                timer.stop();
                TaskThread thread = TaskThread.createAndQueue(task);
                if (thread != null) {
                    if (taskExecutor != null && !taskExecutor.isShutdown()) {
                        taskExecutor.schedule(thread, (long)this.mapTaskDelay, TimeUnit.MILLISECONDS);
                        accepted = true;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Scheduled " + manager.getTaskClass().getSimpleName());
                        }
                    } else {
                        logger.warning("TaskExecutor isn't running");
                    }
                } else {
                    logger.warning("Could not schedule " + manager.getTaskClass().getSimpleName());
                }
            } else {
                timer.cancel();
            }
            manager.taskAccepted(accepted);
        }
    }

    private ITaskManager getNextManager(Minecraft minecraft) {
        for (ITaskManager manager : this.managers) {
            if (!manager.isEnabled(minecraft)) continue;
            return manager;
        }
        return null;
    }
}

