/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.thread;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ChunkRenderController;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.ChunkImageCache;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.task.IGenericTask;
import net.techbrew.journeymap.task.IMapTask;
import net.techbrew.journeymap.task.ITask;

public class TaskThread
implements Runnable {
    private static volatile AtomicInteger queue = new AtomicInteger(0);
    private static ChunkRenderController renderController;
    private final ITask task;
    private final Logger logger = JourneyMap.getLogger();

    private TaskThread(ITask task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskThread createAndQueue(ITask task) {
        if (task == null) {
            return null;
        }
        AtomicInteger atomicInteger = queue;
        synchronized (atomicInteger) {
            int q = queue.get();
            if (q > 1) {
                return null;
            }
            queue.set(1);
            return new TaskThread(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        AtomicInteger atomicInteger = queue;
        synchronized (atomicInteger) {
            queue.set(0);
        }
        renderController = new ChunkRenderController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasQueue() {
        AtomicInteger atomicInteger = queue;
        synchronized (atomicInteger) {
            return queue.get() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        block21: {
            try {
                JourneyMap jm = JourneyMap.getInstance();
                Minecraft mc = Minecraft.func_71410_x();
                boolean threadLogging = jm.isThreadLogging();
                if (!jm.isMapping().booleanValue()) {
                    jm.getLogger().fine("JM not mapping, aborting");
                    return;
                }
                File jmWorldDir = FileHandler.getJMWorldDir(mc);
                if (jmWorldDir == null) {
                    jm.getLogger().fine("JM world dir not found, aborting");
                    return;
                }
                if (this.task instanceof IMapTask) {
                    this.runMapTask((IMapTask)this.task, mc, jm, jmWorldDir, threadLogging);
                    break block21;
                }
                if (this.task instanceof IGenericTask) {
                    this.runGenericTask((IGenericTask)this.task, mc, jm, jmWorldDir, threadLogging);
                    break block21;
                }
                throw new UnsupportedOperationException("ITask unknown: " + this.task.getClass());
            }
            finally {
                AtomicInteger atomicInteger = queue;
                synchronized (atomicInteger) {
                    queue.decrementAndGet();
                }
            }
        }
    }

    private final void runMapTask(IMapTask task, Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) {
        StatTimer timer = StatTimer.get(task.getClass().getSimpleName() + ".runMapTask").start();
        try {
            long start = System.nanoTime();
            boolean flushImagesToDisk = task.flushCacheWhenDone();
            Integer vSlice = task.getVSlice();
            boolean underground = task.isUnderground();
            int dimension = task.getDimension();
            ChunkMD.Set chunkSet = task.getChunkStubs();
            Iterator<ChunkMD> chunkIter = chunkSet.iterator();
            ChunkImageCache chunkImageCache = new ChunkImageCache();
            int currentDimension = mc.field_71441_e.field_73011_w.field_76574_g;
            if (currentDimension != dimension) {
                if (threadLogging) {
                    this.logger.fine("Dimension changed, map task obsolete.");
                }
                timer.cancel();
                return;
            }
            while (chunkIter.hasNext()) {
                if (!jm.isMapping().booleanValue()) {
                    if (threadLogging) {
                        this.logger.fine("JM isn't mapping, aborting");
                    }
                    timer.cancel();
                    return;
                }
                ChunkMD chunkMd = chunkIter.next();
                if (!chunkMd.render.booleanValue()) continue;
                BufferedImage chunkImage = renderController.getChunkImage(chunkMd, underground, vSlice, chunkSet);
                ChunkCoord cCoord = ChunkCoord.fromChunkMD(jmWorldDir, chunkMd, vSlice, dimension);
                if (underground) {
                    chunkImageCache.put(cCoord, Constants.MapType.underground, chunkImage);
                    continue;
                }
                chunkImageCache.put(cCoord, Constants.MapType.day, this.getSubimage(Constants.MapType.day, chunkImage));
                chunkImageCache.put(cCoord, Constants.MapType.night, this.getSubimage(Constants.MapType.night, chunkImage));
            }
            if (!jm.isMapping().booleanValue()) {
                if (threadLogging) {
                    this.logger.fine("JM isn't mapping, aborting.");
                }
                timer.cancel();
                return;
            }
            int chunks = chunkImageCache.size();
            RegionImageCache.getInstance().putAll(chunkImageCache.values(), flushImagesToDisk);
            if (threadLogging) {
                this.logger.fine(task.getClass().getSimpleName() + " mapped " + chunks + " chunks in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms with flush:" + flushImagesToDisk);
            }
            task.taskComplete();
            chunkSet.clear();
            chunkImageCache.clear();
            timer.stop();
        }
        catch (Throwable t) {
            String error = Constants.getMessageJMERR16(t.getMessage());
            JourneyMap.getLogger().log(Level.SEVERE, LogFormatter.toString(t));
            timer.cancel();
        }
    }

    private final void runGenericTask(IGenericTask task, Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) {
        StatTimer timer = StatTimer.get(task.getClass().getSimpleName() + ".performTask").start();
        try {
            task.performTask();
            timer.stop();
            if (threadLogging) {
                timer.report();
            }
        }
        catch (Throwable t) {
            String error = Constants.getMessageJMERR16(t.getMessage());
            JourneyMap.getLogger().log(Level.SEVERE, LogFormatter.toString(t));
            timer.cancel();
        }
    }

    private BufferedImage getSubimage(Constants.MapType mapType, BufferedImage image) {
        if (image == null) {
            return null;
        }
        switch (mapType) {
            case night: {
                return image.getSubimage(16, 0, 16, 16);
            }
        }
        return image.getSubimage(0, 0, 16, 16);
    }
}

