/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import java.util.logging.Logger;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.MapButton;
import org.lwjgl.opengl.GL11;

public abstract class JmUI
extends GuiScreen {
    TextureImpl logo = TextureCache.instance().getLogo();
    protected final String title;
    protected final Logger logger = JourneyMap.getLogger();

    public JmUI(String title) {
        this.title = title;
    }

    public boolean func_73868_f() {
        return true;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void sizeDisplay(boolean scaled) {
        int glwidth = scaled ? this.field_146294_l : this.field_146297_k.field_71443_c;
        int glheight = scaled ? this.field_146295_m : this.field_146297_k.field_71440_d;
        JmUI.sizeDisplay(glwidth, glheight);
    }

    protected boolean mouseOverButtons(int x, int y) {
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            if (!(guibutton instanceof MapButton) || !((MapButton)guibutton).mouseOver(x, y)) continue;
            return true;
        }
        return false;
    }

    protected void drawLogo() {
        JmUI.sizeDisplay(this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        DrawUtil.drawImage(this.logo, (this.field_146297_k.field_71443_c - this.logo.width) / 2, 20.0, false, 1.0f);
        JmUI.sizeDisplay(this.field_146294_l, this.field_146295_m);
    }

    protected void drawTitle() {
        DrawUtil.drawCenteredLabel(this.title, this.field_146294_l / 2, 40.0, Color.black, Color.CYAN, 128, 1.0);
    }

    public void func_146278_c(int layer) {
        super.func_146278_c(layer);
        this.drawLogo();
    }

    protected abstract void layoutButtons();

    public void func_73863_a(int x, int y, float par3) {
        this.func_146278_c(0);
        this.layoutButtons();
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            guibutton.func_146112_a(this.field_146297_k, x, y);
        }
        this.drawLogo();
        this.drawTitle();
    }

    public static void sizeDisplay(double width, double height) {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void close() {
    }
}

