/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.render.draw.DrawUtil;
import org.lwjgl.opengl.GL11;

public class MapButton
extends GuiButton {
    private Boolean toggled = true;
    String icon;
    DynamicTexture iconTexture;
    String labelOn;
    String labelOff;
    public boolean field_146124_l;
    public boolean drawButton;
    public boolean noDisableText;

    private void tempInit() {
        this.field_146124_l = true;
        this.drawButton = true;
    }

    public MapButton(int id, int x, int y, String label) {
        super(id, x, y, label);
        this.tempInit();
    }

    public MapButton(int id, int x, int y, int width, int height, String label) {
        super(id, x, y, width, height, label);
        this.tempInit();
    }

    public MapButton(int id, int x, int y, int width, int height, String labelOn, String labelOff, boolean toggled) {
        super(id, x, y, width, height, toggled ? labelOn : labelOff);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.tempInit();
    }

    public MapButton(int id, int x, int y, String labelOn, String labelOff, boolean toggled) {
        super(id, x, y, toggled ? labelOn : labelOff);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.tempInit();
    }

    private void updateLabel() {
        if (this.labelOn != null && this.labelOff != null) {
            this.field_146126_j = this.getToggled() != false ? this.labelOn : this.labelOff;
        }
    }

    public void toggle() {
        this.setToggled(this.getToggled() == false);
    }

    public void setToggled(Boolean toggled) {
        this.toggled = toggled;
        this.updateLabel();
    }

    public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.drawButton) {
            return;
        }
        super.func_146112_a(minecraft, mouseX, mouseY);
        if (!this.field_146124_l) {
            if (this.mouseOver(mouseX, mouseY)) {
                if (this.noDisableText) {
                    DrawUtil.drawRectangle(this.getX(), this.getY(), this.field_146120_f, this.field_146121_g, Color.darkGray, 185);
                } else {
                    DrawUtil.drawRectangle(this.getX() + 1, this.getY() + 1, this.field_146120_f - 2, this.field_146121_g - 2, Color.darkGray, 255);
                    this.func_73732_a(minecraft.field_71466_p, Constants.getString("MapOverlay.disabled_feature"), this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, -6250336);
                }
            } else {
                DrawUtil.drawRectangle(this.getX(), this.getY(), this.field_146120_f, this.field_146121_g, Color.darkGray, 185);
            }
        }
        if (this.icon != null) {
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.field_146124_l) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            GL11.glDisable((int)3008);
            GL11.glBindTexture((int)3553, (int)this.iconTexture.func_110552_b());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            int height = this.getHeight();
            int width = this.getWidth();
            int w = this.getToggled() != false ? width : (int)Math.ceil((double)width * 0.6);
            int h = this.getToggled() != false ? height : (int)Math.ceil((double)height * 0.6);
            int widthOffset = (width - w) / 2;
            int heightOffset = height - h;
            tessellator.func_78382_b();
            int xPosition = this.getX();
            int yPosition = this.getY();
            tessellator.func_78374_a((double)(xPosition + widthOffset), (double)(h + yPosition + heightOffset), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(xPosition + w + widthOffset), (double)(h + yPosition + heightOffset), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(xPosition + w + widthOffset), (double)(yPosition + heightOffset), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(xPosition + widthOffset), (double)(yPosition + heightOffset), 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int i, int j) {
        return this.field_146124_l && this.drawButton && i >= this.getX() && j >= this.getY() && i < this.getX() + this.getWidth() && j < this.getY() + this.getHeight();
    }

    public boolean mouseOver(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX <= this.field_146128_h + this.field_146120_f && mouseY <= this.field_146129_i + this.field_146121_g;
    }

    public Boolean getToggled() {
        return this.toggled;
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.field_146121_g;
    }

    public int getX() {
        return this.field_146128_h;
    }

    public int getY() {
        return this.field_146129_i;
    }

    public void setX(int x) {
        this.field_146128_h = x;
    }

    public void setY(int y) {
        this.field_146129_i = y;
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public MapButton leftOf(int x) {
        this.setX(x - this.getWidth());
        return this;
    }

    public MapButton rightOf(int x) {
        this.setX(x);
        return this;
    }

    public MapButton centerHorizontalOn(int x) {
        this.setX(x - this.getWidth() / 2);
        return this;
    }

    public MapButton leftOf(MapButton other, int margin) {
        this.setX(other.getX() - this.getWidth() - margin);
        return this;
    }

    public MapButton rightOf(MapButton other, int margin) {
        this.setX(other.getX() + other.getWidth() + margin);
        return this;
    }

    public MapButton below(MapButton other, int margin) {
        this.setY(other.getY() + this.getHeight() + margin);
        return this;
    }
}

