/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.map.MapOverlay;
import net.techbrew.journeymap.ui.map.MapOverlayActions;
import net.techbrew.journeymap.ui.map.MapOverlayHotkeysHelp;
import net.techbrew.journeymap.ui.map.MapOverlayOptions;
import net.techbrew.journeymap.ui.minimap.MiniMap;
import net.techbrew.journeymap.ui.minimap.MiniMapHotkeysHelp;
import net.techbrew.journeymap.ui.minimap.MiniMapOptions;

public class UIManager {
    private MiniMap miniMap;
    private final Logger logger = JourneyMap.getLogger();
    Minecraft minecraft = Minecraft.func_71410_x();

    public static UIManager getInstance() {
        return Holder.INSTANCE;
    }

    private UIManager() {
        this.miniMap = new MiniMap();
    }

    public void closeAll() {
        this.closeCurrent();
        this.minecraft.func_147108_a(null);
        this.minecraft.func_71381_h();
        this.miniMap.setVisible(true);
        TileCache.instance().cleanUp();
    }

    public void closeCurrent() {
        if (this.minecraft.field_71462_r != null && this.minecraft.field_71462_r instanceof JmUI) {
            this.logger.fine("Closing " + this.minecraft.field_71462_r.getClass());
            ((JmUI)this.minecraft.field_71462_r).close();
        }
    }

    public void openInventory() {
        this.logger.fine("Opening inventory");
        this.closeAll();
        this.minecraft.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.minecraft.field_71439_g));
    }

    public void open(Class<? extends JmUI> uiClass) {
        this.closeCurrent();
        try {
            this.logger.fine("Opening UI " + uiClass.getSimpleName());
            this.minecraft.func_147108_a((GuiScreen)uiClass.newInstance());
            this.miniMap.setVisible(false);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception opening UI: " + e);
            this.logger.severe(LogFormatter.toString(e));
            String string = Constants.getMessageJMERR23(e.getMessage());
        }
    }

    public void toggleMinimap() {
        boolean enabled = !this.isMiniMapEnabled();
        PropertyManager.set(PropertyManager.Key.PREF_SHOW_MINIMAP, enabled);
        this.setMiniMapEnabled(enabled);
    }

    public void setMiniMapEnabled(boolean enable) {
        this.miniMap.setEnabled(enable);
    }

    public boolean isMiniMapEnabled() {
        return this.miniMap.isEnabled();
    }

    public void drawMiniMap() {
        if (this.miniMap.isEnabled() && this.miniMap.isVisible()) {
            boolean doDraw;
            GuiScreen currentScreen = this.minecraft.field_71462_r;
            boolean bl = doDraw = currentScreen == null || currentScreen instanceof GuiChat || currentScreen instanceof MiniMapOptions;
            if (doDraw) {
                this.miniMap.drawMap();
            }
        }
    }

    public MiniMap getMiniMap() {
        return this.miniMap;
    }

    public void openMap() {
        KeyBinding.func_74506_a();
        this.open(MapOverlay.class);
    }

    public void openMapHotkeyHelp() {
        this.open(MapOverlayHotkeysHelp.class);
    }

    public void openMiniMapOptions() {
        this.open(MiniMapOptions.class);
    }

    public void openMiniMapHotkeyHelp() {
        this.open(MiniMapHotkeysHelp.class);
    }

    public void openMapOptions() {
        this.open(MapOverlayOptions.class);
    }

    public void openMapActions() {
        this.open(MapOverlayActions.class);
    }

    public void reset() {
        MapOverlay.reset();
        TileCache.instance().invalidateAll();
        TileCache.instance().cleanUp();
        if (this.miniMap != null) {
            this.miniMap.reset();
        }
        this.miniMap = new MiniMap();
    }

    private static class Holder {
        private static final UIManager INSTANCE = new UIManager();

        private Holder() {
        }
    }
}

