/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.MapOverlayState;
import net.techbrew.journeymap.render.draw.DrawEntityStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.overlay.GridRenderer;
import net.techbrew.journeymap.render.overlay.OverlayRadarRenderer;
import net.techbrew.journeymap.render.overlay.OverlayWaypointRenderer;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MapButton;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapChat;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class MapOverlay
extends JmUI {
    static final MapOverlayState state = new MapOverlayState();
    final OverlayWaypointRenderer waypointRenderer = new OverlayWaypointRenderer();
    final OverlayRadarRenderer radarRenderer = new OverlayRadarRenderer();
    static final GridRenderer gridRenderer = new GridRenderer(5);
    Boolean isScrolling = false;
    int msx;
    int msy;
    int mx;
    int my;
    Logger logger = JourneyMap.getLogger();
    MapChat chat;
    MapButton buttonDayNight;
    MapButton buttonFollow;
    MapButton buttonZoomIn;
    MapButton buttonZoomOut;
    MapButton buttonAlert;
    MapButton buttonOptions;
    MapButton buttonActions;
    MapButton buttonClose;
    MapButton buttonMiniMap;
    Color bgColor = new Color(34, 34, 34);
    Color playerInfoFgColor = new Color(0x8888FF);
    Color playerInfoBgColor = new Color(34, 34, 34);
    StatTimer drawScreenTimer = StatTimer.get("MapOverlay.drawScreen");
    StatTimer drawMapTimer = StatTimer.get("MapOverlay.drawScreen.drawMap");
    StatTimer drawMapTimerWithRefresh = StatTimer.get("MapOverlay.drawScreen.drawMap+refreshState");

    public MapOverlay() {
        super(null);
        this.field_146297_k = FMLClientHandler.instance().getClient();
        state.refresh(this.field_146297_k, this.field_146297_k.field_71439_g);
        gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        gridRenderer.setZoom(MapOverlay.state.currentZoom);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.initButtons();
        if (state.getDimension() != this.field_146297_k.field_71439_g.field_71093_bK) {
            gridRenderer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73863_a(int width, int height, float f) {
        try {
            this.drawScreenTimer.start();
            this.func_146278_c(0);
            this.drawMap();
            this.layoutButtons();
            for (int k = 0; k < this.field_146292_n.size(); ++k) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
                guibutton.func_146112_a(this.field_146297_k, width, height);
            }
            if (this.chat != null) {
                this.chat.func_73863_a(width, height, f);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Unexpected exception in MapOverlay.drawScreen(): " + e);
            this.logger.severe(LogFormatter.toString(e));
            this.close();
        }
        finally {
            this.drawScreenTimer.stop();
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_146127_k];
        switch (id) {
            case DayNight: {
                this.toggleDayNight();
                break;
            }
            case Follow: {
                this.toggleFollow();
                break;
            }
            case ZoomIn: {
                this.zoomIn();
                break;
            }
            case ZoomOut: {
                this.zoomOut();
                break;
            }
            case Close: {
                UIManager.getInstance().closeAll();
                break;
            }
            case Alert: {
                VersionCheck.launchWebsite();
                break;
            }
            case Options: {
                UIManager.getInstance().openMapOptions();
                break;
            }
            case Actions: {
                UIManager.getInstance().openMapActions();
            }
        }
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        state.requireRefresh();
        this.layoutButtons();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.func_146280_a(minecraft, width, height);
        }
        this.func_73866_w_();
        this.drawMap();
    }

    void initButtons() {
        if (this.field_146292_n.isEmpty()) {
            String on = Constants.getString("MapOverlay.on");
            String off = Constants.getString("MapOverlay.off");
            this.buttonAlert = new MapButton(ButtonEnum.Alert.ordinal(), 0, 0, Constants.getString("MapOverlay.update_available"));
            this.buttonAlert.drawButton = VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false;
            this.buttonDayNight = new MapButton(ButtonEnum.DayNight.ordinal(), 0, 0, 80, 20, Constants.getString("MapOverlay.day"), Constants.getString("MapOverlay.night"), state.getMapType() == Constants.MapType.day);
            this.buttonFollow = new MapButton(ButtonEnum.Follow.ordinal(), 0, 0, 80, 20, Constants.getString("MapOverlay.follow", on), Constants.getString("MapOverlay.follow", off), MapOverlay.state.follow);
            this.buttonZoomIn = new MapButton(ButtonEnum.ZoomIn.ordinal(), 0, 0, 20, 20, "+");
            this.buttonZoomIn.noDisableText = true;
            this.buttonZoomOut = new MapButton(ButtonEnum.ZoomOut.ordinal(), 0, 0, 20, 20, "-");
            this.buttonZoomOut.noDisableText = true;
            this.buttonZoomOut.field_146124_l = MapOverlay.state.currentZoom > MapOverlay.state.minZoom;
            this.buttonZoomIn.field_146124_l = MapOverlay.state.currentZoom < MapOverlay.state.maxZoom;
            this.buttonClose = new MapButton(ButtonEnum.Close.ordinal(), 0, 0, 60, 20, Constants.getString("MapOverlay.close"));
            this.buttonOptions = new MapButton(ButtonEnum.Options.ordinal(), 0, 0, 60, 20, Constants.getString("MapOverlay.options"));
            this.buttonActions = new MapButton(ButtonEnum.Actions.ordinal(), 0, 0, 60, 20, Constants.getString("MapOverlay.actions"));
            if (this.buttonAlert.drawButton) {
                this.field_146292_n.add(this.buttonAlert);
            }
            this.field_146292_n.add(this.buttonDayNight);
            this.field_146292_n.add(this.buttonFollow);
            this.field_146292_n.add(this.buttonZoomIn);
            this.field_146292_n.add(this.buttonZoomOut);
            this.field_146292_n.add(this.buttonClose);
            this.field_146292_n.add(this.buttonOptions);
            this.field_146292_n.add(this.buttonActions);
        }
    }

    @Override
    protected void layoutButtons() {
        boolean underground;
        if (this.field_146292_n.isEmpty()) {
            this.initButtons();
        }
        boolean smallScale = this.field_146297_k.field_71474_y.field_74335_Z == 1;
        int startX = smallScale ? 60 : 40;
        int endX = this.field_146294_l - 3;
        int startY = 3;
        int hgap = 3;
        int vgap = 3;
        this.buttonDayNight.setPosition(startX, 3);
        this.buttonZoomIn.setPosition(smallScale ? 20 : 8, smallScale ? 64 : 32);
        this.buttonZoomOut.below(this.buttonZoomIn, 8).setX(this.buttonZoomIn.getX());
        if (this.field_146294_l >= 420) {
            this.buttonFollow.rightOf(this.buttonDayNight, 3).setY(3);
            this.buttonClose.leftOf(endX).setY(3);
            this.buttonActions.leftOf(this.buttonClose, 3).setY(3);
            this.buttonOptions.leftOf(this.buttonActions, 3).setY(3);
            if (this.buttonAlert.drawButton) {
                this.buttonAlert.below(this.buttonClose, 3).leftOf(endX);
            }
        } else {
            this.buttonFollow.below(this.buttonDayNight, 3).setX(startX);
            if (this.buttonAlert.drawButton) {
                this.buttonAlert.leftOf(endX).setY(3);
                this.buttonClose.leftOf(endX).below(this.buttonAlert, 3);
            } else {
                this.buttonClose.leftOf(endX).setY(3);
            }
            this.buttonActions.below(this.buttonClose, 3).leftOf(endX);
            this.buttonOptions.below(this.buttonActions, 3).leftOf(endX);
        }
        this.buttonDayNight.field_146124_l = !(underground = ((Boolean)DataCache.instance().get(PlayerData.class).get((Object)EntityKey.underground)).booleanValue()) || PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_CAVES) == false;
    }

    public void func_146274_d() {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_146274_d();
        }
        this.mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (Mouse.getEventButtonState()) {
            this.func_73864_a(this.mx, this.my, Mouse.getEventButton());
        } else {
            int wheel = Mouse.getEventDWheel();
            if (wheel > 0) {
                this.zoomIn();
            } else if (wheel < 0) {
                this.zoomOut();
            } else {
                this.func_146286_b(this.mx, this.my, Mouse.getEventButton());
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73864_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        Boolean guiButtonUsed = false;
        if (mouseButton == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                guiButtonUsed = true;
                break;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int which) {
        super.func_146286_b(mouseX, mouseY, which);
        if (Mouse.isButtonDown((int)0) && this.mouseOverButtons(mouseX, mouseY)) {
            return;
        }
        if (Mouse.isButtonDown((int)0) && !this.isScrolling.booleanValue()) {
            this.isScrolling = true;
            this.msx = this.mx;
            this.msy = this.my;
        } else if (!Mouse.isButtonDown((int)0) && this.isScrolling.booleanValue()) {
            this.isScrolling = false;
            int blockSize = (int)Math.pow(2.0, MapOverlay.state.currentZoom);
            int mouseDragX = (this.mx - this.msx) * 2 / blockSize;
            int mouseDragY = (this.my - this.msy) * 2 / blockSize;
            this.msx = this.mx;
            this.msy = this.my;
            if (gridRenderer != null) {
                try {
                    gridRenderer.move(-mouseDragX, -mouseDragY);
                    gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, false, 0.0, 0.0);
                    gridRenderer.setZoom(MapOverlay.state.currentZoom);
                }
                catch (Exception e) {
                    this.logger.severe("Error moving grid: " + e);
                }
            }
            this.setFollow(false);
            this.refreshState();
        }
    }

    void zoomIn() {
        if (MapOverlay.state.currentZoom < MapOverlay.state.maxZoom) {
            this.setZoom(MapOverlay.state.currentZoom + 1);
        }
    }

    void zoomOut() {
        if (MapOverlay.state.currentZoom > MapOverlay.state.minZoom) {
            this.setZoom(MapOverlay.state.currentZoom - 1);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            this.buttonZoomOut.field_146124_l = MapOverlay.state.currentZoom > MapOverlay.state.minZoom;
            this.buttonZoomIn.field_146124_l = MapOverlay.state.currentZoom < MapOverlay.state.maxZoom;
            this.refreshState();
        }
    }

    void toggleDayNight() {
        this.buttonDayNight.toggle();
        if (this.buttonDayNight.getToggled().booleanValue()) {
            state.overrideMapType(Constants.MapType.day);
        } else {
            state.overrideMapType(Constants.MapType.night);
        }
        this.refreshState();
    }

    void toggleFollow() {
        this.setFollow(!MapOverlay.state.follow);
    }

    void setFollow(Boolean onPlayer) {
        if (MapOverlay.state.follow == onPlayer) {
            return;
        }
        this.buttonFollow.setToggled(onPlayer);
        MapOverlay.state.follow = onPlayer;
        if (MapOverlay.state.follow) {
            this.refreshState();
        }
    }

    public void func_73869_a(char c, int i) {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73869_a(c, i);
            return;
        }
        if (i == 1 || i == Constants.KB_MAP.func_151463_i()) {
            UIManager.getInstance().closeAll();
            return;
        }
        if (i == Constants.KB_MAP_ZOOMIN.func_151463_i()) {
            this.zoomIn();
            return;
        }
        if (i == Constants.KB_MAP_ZOOMOUT.func_151463_i()) {
            this.zoomOut();
            return;
        }
        if (i == Constants.KB_MAP_DAY.func_151463_i()) {
            state.overrideMapType(Constants.MapType.day);
            return;
        }
        if (i == Constants.KB_MAP_NIGHT.func_151463_i()) {
            state.overrideMapType(Constants.MapType.night);
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.moveCanvas(0, -16);
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.moveCanvas(-16, 0);
            return;
        }
        if (this.field_146297_k.field_71474_y.field_74368_y.func_151468_f()) {
            this.moveCanvas(0, 16);
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.moveCanvas(16, 0);
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.close();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g));
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.openChat("");
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_74323_J.func_151463_i()) {
            this.openChat("/");
            return;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.chat != null) {
            this.chat.func_73876_c();
        }
        this.layoutButtons();
    }

    @Override
    public void func_146278_c(int layer) {
        DrawUtil.drawRectangle(0.0, 0.0, this.field_146294_l, this.field_146295_m, this.bgColor, 255);
    }

    void drawMap() {
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        timer.start();
        this.sizeDisplay(false);
        int xOffset = 0;
        int yOffset = 0;
        if (this.isScrolling.booleanValue()) {
            int blockSize = (int)Math.pow(2.0, MapOverlay.state.currentZoom);
            int mouseDragX = (this.mx - this.msx) * 2 / blockSize;
            int mouseDragY = (this.my - this.msy) * 2 / blockSize;
            xOffset = mouseDragX * blockSize;
            yOffset = mouseDragY * blockSize;
        } else if (refreshReady) {
            this.refreshState();
        } else {
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        }
        if (MapOverlay.state.follow) {
            gridRenderer.center(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, false, 0.0, 0.0);
        gridRenderer.draw(1.0f, xOffset, yOffset);
        gridRenderer.draw(state.getDrawSteps(), xOffset, yOffset, 1.0f);
        Point2D.Double playerPixel = gridRenderer.getPixel(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v);
        if (playerPixel != null) {
            TextureImpl tex = MapOverlay.state.currentZoom == 0 ? TextureCache.instance().getPlayerLocatorSmall() : TextureCache.instance().getPlayerLocator();
            DrawEntityStep drawStep = new DrawEntityStep(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, EntityHelper.getHeading((Entity)this.field_146297_k.field_71439_g), false, tex, 8);
            gridRenderer.draw(xOffset, yOffset, 1.0f, drawStep);
        }
        DrawUtil.drawImage(TextureCache.instance().getLogo(), 16.0, 4.0, false, 1.0f);
        this.sizeDisplay(true);
        DrawUtil.drawCenteredLabel(MapOverlay.state.playerLastPos, this.field_146294_l / 2, this.field_146295_m - 11, this.playerInfoBgColor, this.playerInfoFgColor, 205, 1.0);
        timer.stop();
    }

    public static void drawMapBackground(JmUI ui) {
        ui.sizeDisplay(false);
        Minecraft mc = ui.field_146297_k;
        if (state.shouldRefresh(ui.field_146297_k)) {
            EntityClientPlayerMP player = ui.field_146297_k.field_71439_g;
            if (player == null) {
                return;
            }
            MapOverlayState state = MapOverlay.state();
            state.refresh(ui.field_146297_k, player);
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
            if (state.follow) {
                gridRenderer.center(ui.field_146297_k.field_71439_g.field_70165_t, ui.field_146297_k.field_71439_g.field_70161_v, state.currentZoom);
            } else {
                gridRenderer.setZoom(state.currentZoom);
            }
            gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), mc.field_71443_c, mc.field_71440_d, true, 0.0, 0.0);
        } else {
            gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        }
        if (MapOverlay.state.follow) {
            gridRenderer.center(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), mc.field_71443_c, mc.field_71440_d, false, 0.0, 0.0);
        gridRenderer.draw(1.0f, 0.0, 0.0);
        gridRenderer.draw(state.getDrawSteps(), 0, 0, 1.0f);
        Point2D.Double playerPixel = gridRenderer.getPixel(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v);
        if (playerPixel != null) {
            TextureImpl tex = MapOverlay.state.currentZoom == 0 ? TextureCache.instance().getPlayerLocatorSmall() : TextureCache.instance().getPlayerLocator();
            DrawEntityStep drawStep = new DrawEntityStep(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, EntityHelper.getHeading((Entity)mc.field_71439_g), false, tex, 8);
            gridRenderer.draw(0, 0, 1.0f, drawStep);
        }
        DrawUtil.drawImage(TextureCache.instance().getLogo(), 16.0, 4.0, false, 1.0f);
        ui.sizeDisplay(true);
    }

    void refreshState() {
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        if (player == null) {
            this.logger.warning("Could not get player");
            return;
        }
        state.refresh(this.field_146297_k, player);
        if (state.getDimension() != gridRenderer.getDimension()) {
            this.setFollow(true);
        }
        gridRenderer.setContext(state.getWorldDir(), state.getDimension());
        if (MapOverlay.state.follow) {
            gridRenderer.center(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, MapOverlay.state.currentZoom);
        } else {
            gridRenderer.setZoom(MapOverlay.state.currentZoom);
        }
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, true, 0.0, 0.0);
        state.generateDrawSteps(this.field_146297_k, gridRenderer, this.waypointRenderer, this.radarRenderer, 1.0f);
        MapOverlay.state.playerLastPos = Constants.getString("MapOverlay.player_location", Integer.toString((int)this.field_146297_k.field_71439_g.field_70165_t), Integer.toString((int)this.field_146297_k.field_71439_g.field_70161_v), Integer.toString((int)this.field_146297_k.field_71439_g.field_70163_u), this.field_146297_k.field_71439_g.field_70162_ai, state.getPlayerBiome());
        state.updateLastRefresh();
        TileCache.instance().cleanUp();
    }

    void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    @Override
    public void close() {
        if (this.chat != null) {
            this.chat.close();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    boolean isRefreshReady() {
        if (this.isScrolling.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(this.field_146297_k);
    }

    void moveCanvas(int deltaBlockX, int deltaBlockz) {
        this.refreshState();
        gridRenderer.move(deltaBlockX, deltaBlockz);
        gridRenderer.updateTextures(state.getMapType(), state.getVSlice(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, true, 0.0, 0.0);
        this.setFollow(false);
    }

    @Override
    public final boolean func_73868_f() {
        return false;
    }

    public static synchronized MapOverlayState state() {
        return state;
    }

    public static void reset() {
        state.requireRefresh();
        gridRenderer.clear();
        TileCache.instance().invalidateAll();
        TileCache.instance().cleanUp();
    }

    private static enum ButtonEnum {
        Alert,
        DayNight,
        Follow,
        ZoomIn,
        ZoomOut,
        Options,
        Actions,
        Close,
        MiniMap;

    }
}

