/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.map;

import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.PlayerData;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.model.WaypointHelper;
import net.techbrew.journeymap.ui.JmUI;
import net.techbrew.journeymap.ui.MapButton;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;

public class MapOverlayOptions
extends JmUI {
    int lastWidth = 0;
    int lastHeight = 0;
    MapButton buttonCaves;
    MapButton buttonMonsters;
    MapButton buttonAnimals;
    MapButton buttonVillagers;
    MapButton buttonPets;
    MapButton buttonPlayers;
    MapButton buttonWaypoints;
    MapButton buttonGrid;
    MapButton buttonWebserver;
    MapButton buttonMiniMap;
    MapButton buttonKeyboardHelp;
    MapButton buttonClose;

    public MapOverlayOptions() {
        super(Constants.getString("MapOverlay.options"));
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        String on = Constants.getString("MapOverlay.on");
        String off = Constants.getString("MapOverlay.off");
        this.buttonCaves = new MapButton(ButtonEnum.Caves.ordinal(), 0, 0, Constants.getString("MapOverlay.show_caves", on), Constants.getString("MapOverlay.show_caves", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_CAVES));
        this.buttonClose = new MapButton(ButtonEnum.Close.ordinal(), 0, 0, Constants.getString("MapOverlay.close"));
        this.buttonMonsters = new MapButton(ButtonEnum.Monsters.ordinal(), 0, 0, Constants.getString("MapOverlay.show_monsters", on), Constants.getString("MapOverlay.show_monsters", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_MOBS));
        this.buttonAnimals = new MapButton(ButtonEnum.Animals.ordinal(), 0, 0, Constants.getString("MapOverlay.show_animals", on), Constants.getString("MapOverlay.show_animals", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_ANIMALS));
        this.buttonVillagers = new MapButton(ButtonEnum.Villagers.ordinal(), 0, 0, Constants.getString("MapOverlay.show_villagers", on), Constants.getString("MapOverlay.show_villagers", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_VILLAGERS));
        this.buttonPets = new MapButton(ButtonEnum.Pets.ordinal(), 0, 0, Constants.getString("MapOverlay.show_pets", on), Constants.getString("MapOverlay.show_pets", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_PETS));
        this.buttonPlayers = new MapButton(ButtonEnum.Players.ordinal(), 0, 0, Constants.getString("MapOverlay.show_players", on), Constants.getString("MapOverlay.show_players", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_PLAYERS));
        this.buttonWaypoints = new MapButton(ButtonEnum.Waypoints.ordinal(), 0, 0, Constants.getString("MapOverlay.show_waypoints", on), Constants.getString("MapOverlay.show_waypoints", off), PropertyManager.getBooleanProp(PropertyManager.Key.PREF_SHOW_WAYPOINTS));
        this.buttonWaypoints.field_146124_l = WaypointHelper.waypointsEnabled();
        boolean webserverOn = PropertyManager.getInstance().getBoolean(PropertyManager.Key.WEBSERVER_ENABLED);
        this.buttonWebserver = new MapButton(ButtonEnum.Webserver.ordinal(), 0, 0, Constants.getString("MapOverlay.enable_webserver", on), Constants.getString("MapOverlay.enable_webserver", off), webserverOn);
        this.buttonWebserver.setToggled(webserverOn);
        this.buttonMiniMap = new MapButton(ButtonEnum.MiniMap.ordinal(), 0, 0, Constants.getString("MapOverlay.minimap"));
        this.buttonKeyboardHelp = new MapButton(ButtonEnum.KeyboardHelp.ordinal(), 0, 0, Constants.getString("MapOverlay.hotkeys_button"));
        boolean gridOn = PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_GRID);
        this.buttonGrid = new MapButton(ButtonEnum.Grid.ordinal(), 0, 0, Constants.getString("MapOverlay.show_grid", on), Constants.getString("MapOverlay.show_grid", off), gridOn);
        if (!FeatureManager.isAllowed(Feature.MapCaves)) {
            this.buttonCaves.setToggled(false);
            this.buttonCaves.field_146124_l = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarMobs)) {
            this.buttonMonsters.setToggled(false);
            this.buttonMonsters.field_146124_l = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarAnimals)) {
            this.buttonAnimals.setToggled(false);
            this.buttonAnimals.field_146124_l = false;
            this.buttonPets.setToggled(false);
            this.buttonPets.field_146124_l = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarVillagers)) {
            this.buttonVillagers.setToggled(false);
            this.buttonVillagers.field_146124_l = false;
        }
        if (!FeatureManager.isAllowed(Feature.RadarPlayers)) {
            this.buttonPlayers.setToggled(false);
            this.buttonPlayers.field_146124_l = false;
        }
        this.field_146292_n.add(this.buttonCaves);
        this.field_146292_n.add(this.buttonClose);
        this.field_146292_n.add(this.buttonMonsters);
        this.field_146292_n.add(this.buttonAnimals);
        this.field_146292_n.add(this.buttonVillagers);
        this.field_146292_n.add(this.buttonPets);
        this.field_146292_n.add(this.buttonPlayers);
        this.field_146292_n.add(this.buttonGrid);
        this.field_146292_n.add(this.buttonWaypoints);
        this.field_146292_n.add(this.buttonWebserver);
        this.field_146292_n.add(this.buttonKeyboardHelp);
        this.field_146292_n.add(this.buttonMiniMap);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        if (this.lastWidth != this.field_146294_l || this.lastHeight != this.field_146295_m) {
            this.lastWidth = this.field_146294_l;
            this.lastHeight = this.field_146295_m;
            int hgap = 4;
            int vgap = 3;
            int bx = (this.field_146294_l - 4) / 2;
            int by = this.field_146295_m / 4;
            this.buttonCaves.leftOf(bx).setY(by);
            this.buttonMonsters.rightOf(this.buttonCaves, 4).setY(by);
            this.buttonAnimals.below(this.buttonCaves, 3).leftOf(bx);
            this.buttonVillagers.rightOf(this.buttonAnimals, 4).below(this.buttonMonsters, 3);
            this.buttonPets.below(this.buttonAnimals, 3).leftOf(bx);
            this.buttonPlayers.rightOf(this.buttonPets, 4).below(this.buttonVillagers, 3);
            this.buttonGrid.below(this.buttonPets, 3).leftOf(bx);
            this.buttonWaypoints.rightOf(this.buttonGrid, 4).below(this.buttonPlayers, 3);
            this.buttonMiniMap.below(this.buttonGrid, 3).leftOf(bx);
            this.buttonWebserver.rightOf(this.buttonMiniMap, 3).below(this.buttonWaypoints, 3);
            this.buttonKeyboardHelp.below(this.buttonWebserver, 3).centerHorizontalOn(bx);
            this.buttonClose.below(this.buttonKeyboardHelp, 3).centerHorizontalOn(bx);
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        ButtonEnum id = ButtonEnum.values()[guibutton.field_146127_k];
        switch (id) {
            case Caves: {
                this.buttonCaves.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_CAVES));
                boolean underground = (Boolean)DataCache.instance().get(PlayerData.class).get((Object)EntityKey.underground);
                if (!underground) break;
                MapOverlay.state().requireRefresh();
                break;
            }
            case Close: {
                UIManager.getInstance().openMap();
                break;
            }
            case Monsters: {
                this.buttonMonsters.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_MOBS));
                break;
            }
            case Animals: {
                this.buttonAnimals.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_ANIMALS));
                break;
            }
            case Villagers: {
                this.buttonVillagers.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_VILLAGERS));
                break;
            }
            case Pets: {
                this.buttonPets.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_PETS));
                break;
            }
            case Players: {
                this.buttonPlayers.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_PLAYERS));
                break;
            }
            case Waypoints: {
                this.buttonWaypoints.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_WAYPOINTS));
                break;
            }
            case Grid: {
                this.buttonGrid.setToggled(PropertyManager.toggle(PropertyManager.Key.PREF_SHOW_GRID));
                MapOverlay.state().requireRefresh();
                break;
            }
            case Webserver: {
                this.buttonWebserver.setToggled(PropertyManager.toggle(PropertyManager.Key.WEBSERVER_ENABLED));
                JourneyMap.getInstance().toggleWebserver(this.buttonWebserver.getToggled(), true);
                break;
            }
            case MiniMap: {
                UIManager.getInstance().openMiniMapOptions();
                break;
            }
            case KeyboardHelp: {
                UIManager.getInstance().openMapHotkeyHelp();
            }
        }
    }

    protected void func_73869_a(char c, int i) {
        switch (i) {
            case 1: {
                UIManager.getInstance().openMap();
            }
        }
    }

    private static enum ButtonEnum {
        Caves,
        Monsters,
        Animals,
        Villagers,
        Pets,
        Players,
        Waypoints,
        Grid,
        Webserver,
        MiniMap,
        KeyboardHelp,
        Close;

    }
}

