/*
 * Decompiled with CFR 0.152.
 */
package com.ProfitOrange.moshiz.world.gen;

import com.ProfitOrange.moshiz.world.nether.WorldGenGreenShroom;
import com.ProfitOrange.moshiz.world.nether.WorldGenNetherReed;
import com.ProfitOrange.moshiz.world.nether.WorldGenPurpleShroom;
import com.ProfitOrange.moshiz.world.trees.WorldGenCherryBigTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenCherryTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenGlowTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenHellwoodTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenMapleTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenSilverbellTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenTigerwoodTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenWillowCanopyTree;
import com.ProfitOrange.moshiz.world.trees.WorldGenWillowTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MoShizTreeGen
implements IWorldGenerator {
    private final WorldGenAbstractTree CherryTree = new WorldGenCherryTree(true, false);
    private final WorldGenAbstractTree BigCherryTree_pink = new WorldGenCherryBigTree(true, true);
    private final WorldGenAbstractTree BigCherryTree_white = new WorldGenCherryBigTree(true, false);
    private final WorldGenAbstractTree GlowTree = new WorldGenGlowTree(true, false);
    private final WorldGenAbstractTree HellwoodTree = new WorldGenHellwoodTree(true, false);
    private final WorldGenAbstractTree MapleTree = new WorldGenMapleTree(true, false);
    private final WorldGenAbstractTree TigerwoodTree = new WorldGenTigerwoodTree(true, false);
    private final WorldGenAbstractTree WillowTree = new WorldGenWillowTree(true, false);
    private final WorldGenAbstractTree WillowTreeCanopy = new WorldGenWillowCanopyTree(true);
    private final WorldGenAbstractTree SilverbellTree = new WorldGenSilverbellTree(true, false);
    private final WorldGenerator GreenShroom = new WorldGenGreenShroom();
    private final WorldGenerator PurpleShroom = new WorldGenPurpleShroom();
    private final WorldGenerator NetherReed = new WorldGenNetherReed();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.runGenerator((WorldGenerator)this.CherryTree, world, random, chunkX, chunkZ, 1.0, -1, 0, BiomeForest.class);
                this.runGenerator((WorldGenerator)this.BigCherryTree_pink, world, random, chunkX, chunkZ, 0.2, -1, 0, BiomeForest.class);
                this.runGenerator((WorldGenerator)this.BigCherryTree_white, world, random, chunkX, chunkZ, 0.2, -1, 0, BiomeForest.class);
                this.runGenerator((WorldGenerator)this.MapleTree, world, random, chunkX, chunkZ, 1.7, -1, 0, BiomeForest.class);
                this.runGenerator((WorldGenerator)this.TigerwoodTree, world, random, chunkX, chunkZ, 1.2, -1, 0, BiomeForest.class);
                this.runGenerator((WorldGenerator)this.WillowTree, world, random, chunkX, chunkZ, 1.3, -1, 0, BiomeForest.class);
                this.runGenerator((WorldGenerator)this.SilverbellTree, world, random, chunkX, chunkZ, 0.5, -1, 0, BiomeForest.class, BiomePlains.class);
                this.runGenerator((WorldGenerator)this.WillowTreeCanopy, world, random, chunkX, chunkZ, 1.3, -1, 0, BiomeForest.class);
                break;
            }
            case -1: {
                this.runGenerator((WorldGenerator)this.GlowTree, world, random, chunkX, chunkZ, 5.0, 20, 100, BiomeHell.class);
                this.runGenerator((WorldGenerator)this.HellwoodTree, world, random, chunkX, chunkZ, 5.0, 20, 100, BiomeHell.class);
                this.runGenerator(this.GreenShroom, world, random, chunkX, chunkZ, 1.0, 20, 120, BiomeHell.class);
                this.runGenerator(this.PurpleShroom, world, random, chunkX, chunkZ, 1.0, 20, 120, BiomeHell.class);
                this.runGenerator(this.NetherReed, world, random, chunkX, chunkZ, 3.0, 8, 110, BiomeHell.class);
            }
        }
    }

    private void runGenerator(WorldGenerator gen, World world, Random random, int chunkX, int chunkZ, double spawnChance, int minHeight, int maxHeight, Class<?> ... biomeClasses) {
        if (spawnChance < 1.0) {
            spawnChance = random.nextDouble() < spawnChance ? 1.0 : 0.0;
        }
        ArrayList classList = new ArrayList(Arrays.asList(biomeClasses));
        int heightDiff = maxHeight - minHeight + 1;
        int i = 0;
        while ((double)i < spawnChance) {
            Class<?> biome;
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + random.nextInt(15), minHeight + random.nextInt(heightDiff), chunkZ * 16 + 10 + random.nextInt(15));
            if (minHeight < 0) {
                pos = world.func_175645_m(pos);
            }
            if (classList.contains(biome = world.field_73011_w.getBiomeForCoords(pos).getClass()) || biomeClasses.length == 0) {
                gen.func_180709_b(world, random, pos);
            }
            ++i;
        }
    }
}

