/*
 * Decompiled with CFR 0.152.
 */
package com.ProfitOrange.moshiz.world.trees;

import com.ProfitOrange.moshiz.init.MoShizBlocks;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenWillowCanopyTree
extends WorldGenAbstractTree {
    private static final IBlockState DARK_OAK_LOG = MoShizBlocks.willowLog.func_176223_P();
    private static final IBlockState DARK_OAK_LEAVES = MoShizBlocks.willowLeaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public WorldGenWillowCanopyTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + rand.nextInt(2) + 6;
        int j = position.func_177958_n();
        int k = position.func_177956_o();
        int l = position.func_177952_p();
        if (k >= 1 && k + i + 1 < 256) {
            BlockPos blockpos = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(blockpos);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, blockpos, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (!isSoil || position.func_177956_o() >= worldIn.func_72800_K() - i - 1) {
                return false;
            }
            if (!this.placeTreeOfHeight(worldIn, position, i)) {
                return false;
            }
            this.onPlantGrow(worldIn, blockpos, position);
            this.onPlantGrow(worldIn, blockpos.func_177974_f(), position);
            this.onPlantGrow(worldIn, blockpos.func_177968_d(), position);
            this.onPlantGrow(worldIn, blockpos.func_177968_d().func_177974_f(), position);
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            int i1 = i - rand.nextInt(4);
            int j1 = 2 - rand.nextInt(3);
            int k1 = j;
            int l1 = l;
            int i2 = k + i - 1;
            for (int j2 = 0; j2 < i; ++j2) {
                int k2;
                BlockPos blockpos1;
                if (j2 >= i1 && j1 > 0) {
                    k1 += enumfacing.func_82601_c();
                    l1 += enumfacing.func_82599_e();
                    --j1;
                }
                if (!(state = worldIn.func_180495_p(blockpos1 = new BlockPos(k1, k2 = k + j2, l1))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos1) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos1)) continue;
                this.placeLogAt(worldIn, blockpos1);
                this.placeLogAt(worldIn, blockpos1.func_177974_f());
                this.placeLogAt(worldIn, blockpos1.func_177968_d());
                this.placeLogAt(worldIn, blockpos1.func_177974_f().func_177968_d());
            }
            for (int i3 = -2; i3 <= 0; ++i3) {
                for (int l3 = -2; l3 <= 0; ++l3) {
                    int k4 = -1;
                    this.placeLeafAt(worldIn, k1 + i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(worldIn, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(worldIn, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.placeLeafAt(worldIn, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                    if (i3 <= -2 && l3 <= -1 || i3 == -1 && l3 == -2) continue;
                    k4 = 1;
                    this.placeLeafAt(worldIn, k1 + i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(worldIn, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(worldIn, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.placeLeafAt(worldIn, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                }
            }
            if (rand.nextBoolean()) {
                this.placeLeafAt(worldIn, k1, i2 + 2, l1);
                this.placeLeafAt(worldIn, k1 + 1, i2 + 2, l1);
                this.placeLeafAt(worldIn, k1 + 1, i2 + 2, l1 + 1);
                this.placeLeafAt(worldIn, k1, i2 + 2, l1 + 1);
            }
            for (int j3 = -3; j3 <= 4; ++j3) {
                for (int i4 = -3; i4 <= 4; ++i4) {
                    if (j3 == -3 && i4 == -3 || j3 == -3 && i4 == 4 || j3 == 4 && i4 == -3 || j3 == 4 && i4 == 4 || Math.abs(j3) >= 3 && Math.abs(i4) >= 3) continue;
                    this.placeLeafAt(worldIn, k1 + j3, i2, l1 + i4);
                }
            }
            for (int k3 = -1; k3 <= 2; ++k3) {
                for (int j4 = -1; j4 <= 2; ++j4) {
                    if (k3 >= 0 && k3 <= 1 && j4 >= 0 && j4 <= 1 || rand.nextInt(3) > 0) continue;
                    int l4 = rand.nextInt(3) + 2;
                    for (int i5 = 0; i5 < l4; ++i5) {
                        this.placeLogAt(worldIn, new BlockPos(j + k3, i2 - i5 - 1, l + j4));
                    }
                    for (int j5 = -1; j5 <= 1; ++j5) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            this.placeLeafAt(worldIn, k1 + k3 + j5, i2, l1 + j4 + l2);
                        }
                    }
                    for (int k5 = -2; k5 <= 2; ++k5) {
                        for (int l5 = -2; l5 <= 2; ++l5) {
                            if (Math.abs(k5) == 2 && Math.abs(l5) == 2) continue;
                            this.placeLeafAt(worldIn, k1 + k3 + k5, i2 - 1, l1 + j4 + l5);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean placeTreeOfHeight(World worldIn, BlockPos pos, int height) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= height + 1; ++l) {
            int i1 = 1;
            if (l == 0) {
                i1 = 0;
            }
            if (l >= height - 1) {
                i1 = 2;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeLogAt(World worldIn, BlockPos pos) {
        if (this.func_150523_a(worldIn.func_180495_p(pos).func_177230_c())) {
            this.func_175903_a(worldIn, pos, DARK_OAK_LOG);
        }
    }

    private void placeLeafAt(World worldIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos)) {
            this.func_175903_a(worldIn, blockpos, DARK_OAK_LEAVES);
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }
}

