/*
 * Decompiled with CFR 0.152.
 */
package com.ProfitOrange.MoShiz.world.nature.trees;

import com.ProfitOrange.MoShiz.init.MoShizBlocks;
import com.ProfitOrange.MoShiz.world.nature.trees.BasicTree;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class GlowTreeFeature
extends BasicTree {
    private static final BlockState DEFAULT_TRUNK = MoShizBlocks.glowood_log.func_176223_P();
    private static final BlockState DEFAULT_LEAF = MoShizBlocks.glowood_leaf.func_176223_P();
    protected final int minTreeHeight;
    private final boolean vinesGrow;
    private final BlockState trunk;
    private final BlockState leaf;

    public GlowTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace) {
        this(configFactoryIn, doBlockNotifyOnPlace, 4, DEFAULT_TRUNK, DEFAULT_LEAF, false);
    }

    public GlowTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, int minTreeHeightIn, BlockState trunkState, BlockState leafState, boolean vinesGrowIn) {
        super(configFactoryIn, doBlockNotifyOnPlace);
        this.minTreeHeight = minTreeHeightIn;
        this.trunk = trunkState;
        this.leaf = leafState;
        this.vinesGrow = vinesGrowIn;
    }

    @Override
    public boolean place(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = this.getHeight(rand);
        BlockPos down = position.func_177977_b();
        BlockState state = worldIn.func_180495_p(down);
        boolean isSoil = state.func_177230_c() == Blocks.field_150424_aL;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (GlowTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (isSoil && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt((IWorldGenerationReader)worldIn, position.func_177977_b(), position);
                for (int l2 = position.func_177956_o() - 3 + i; l2 <= position.func_177956_o() + i; ++l2) {
                    int l3 = l2 - (position.func_177956_o() + i);
                    int j4 = 1 - l3 / 2;
                    for (int j1 = position.func_177958_n() - j4; j1 <= position.func_177958_n() + j4; ++j1) {
                        int k1 = j1 - position.func_177958_n();
                        for (int l1 = position.func_177952_p() - j4; l1 <= position.func_177952_p() + j4; ++l1) {
                            BlockPos blockpos;
                            int i2 = l1 - position.func_177952_p();
                            if (Math.abs(k1) == j4 && Math.abs(i2) == j4 && (rand.nextInt(2) == 0 || l3 == 0) || !GlowTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(j1, l2, l1))) && !GlowTreeFeature.func_214576_j((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, this.leaf, p_208519_5_);
                        }
                    }
                }
                for (int i3 = 0; i3 < i; ++i3) {
                    if (!GlowTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i3)) && !GlowTreeFeature.func_214576_j((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i3))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(i3), this.trunk, p_208519_5_);
                    if (!this.vinesGrow || i3 <= 0) continue;
                    if (rand.nextInt(3) > 0 && GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(-1, i3, 0))) {
                        this.addVine((IWorldWriter)worldIn, position.func_177982_a(-1, i3, 0), VineBlock.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, i3, 0))) {
                        this.addVine((IWorldWriter)worldIn, position.func_177982_a(1, i3, 0), VineBlock.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(0, i3, -1))) {
                        this.addVine((IWorldWriter)worldIn, position.func_177982_a(0, i3, -1), VineBlock.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(0, i3, 1))) continue;
                    this.addVine((IWorldWriter)worldIn, position.func_177982_a(0, i3, 1), VineBlock.field_176273_b);
                }
                if (this.vinesGrow) {
                    for (int j3 = position.func_177956_o() - 3 + i; j3 <= position.func_177956_o() + i; ++j3) {
                        int i4 = j3 - (position.func_177956_o() + i);
                        int k4 = 2 - i4 / 2;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                        for (int l4 = position.func_177958_n() - k4; l4 <= position.func_177958_n() + k4; ++l4) {
                            for (int i5 = position.func_177952_p() - k4; i5 <= position.func_177952_p() + k4; ++i5) {
                                blockpos$mutableblockpos1.func_181079_c(l4, j3, i5);
                                if (!GlowTreeFeature.func_214570_f((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos1)) continue;
                                BlockPos blockpos3 = blockpos$mutableblockpos1.func_177976_e();
                                BlockPos blockpos4 = blockpos$mutableblockpos1.func_177974_f();
                                BlockPos blockpos1 = blockpos$mutableblockpos1.func_177978_c();
                                BlockPos blockpos2 = blockpos$mutableblockpos1.func_177968_d();
                                if (rand.nextInt(4) == 0 && GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos3)) {
                                    this.addHangingVine((IWorldGenerationReader)worldIn, blockpos3, VineBlock.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos4)) {
                                    this.addHangingVine((IWorldGenerationReader)worldIn, blockpos4, VineBlock.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) {
                                    this.addHangingVine((IWorldGenerationReader)worldIn, blockpos1, VineBlock.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos2)) continue;
                                this.addHangingVine((IWorldGenerationReader)worldIn, blockpos2, VineBlock.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && i > 5) {
                        for (int k3 = 0; k3 < 2; ++k3) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - k3) != 0) continue;
                                Direction direction1 = direction.func_176734_d();
                                this.placeCocoa((IWorldWriter)worldIn, rand.nextInt(3), position.func_177982_a(direction1.func_82601_c(), i - 5 + k3, direction1.func_82599_e()), direction);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected int getHeight(Random random) {
        return this.minTreeHeight + random.nextInt(3);
    }

    private void placeCocoa(IWorldWriter worldIn, int age, BlockPos pos, Direction side) {
        this.func_202278_a(worldIn, pos, (BlockState)((BlockState)Blocks.field_150375_by.func_176223_P().func_206870_a((IProperty)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age))).func_206870_a((IProperty)CocoaBlock.field_185512_D, (Comparable)side));
    }

    private void addVine(IWorldWriter worldIn, BlockPos pos, BooleanProperty prop) {
        this.func_202278_a(worldIn, pos, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
    }

    private void addHangingVine(IWorldGenerationReader worldIn, BlockPos pos, BooleanProperty prop) {
        this.addVine((IWorldWriter)worldIn, pos, prop);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; GlowTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) && i > 0; --i) {
            this.addVine((IWorldWriter)worldIn, blockpos, prop);
            blockpos = blockpos.func_177977_b();
        }
    }
}

