/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.EntityDart;
import com.bobmowzie.mowziesmobs.server.entity.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntityEggInfo;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaya;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityBabyFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public enum EntityHandler {
    INSTANCE;

    public static final String BARAKOAYA_ID = "TribesmanVillager";
    private final Map<String, MowzieEntityEggInfo> entityEggs = new LinkedHashMap<String, MowzieEntityEggInfo>();
    private int nextEntityId;

    public void onInit() {
        this.registerEntity(EntityFoliaath.class, "Foliaath", true, 4705339, 12598220, false, 20, 3, 1, EnumCreatureType.MONSTER, Biomes.field_76792_x, Biomes.field_76782_w, Biomes.field_150574_L);
        this.registerEntity(EntityBabyFoliaath.class, "BabyFoliaath", false, 4705339, 12598220, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityWroughtnaut.class, "FerrousWroughtnaut", true, 0x8C8C8C, 0xFFFFFF, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityBarakoanToBarakoana.class, "TribesmanHunter", false, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityBarakoana.class, "TribesmanElite", true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityBarakoaya.class, BARAKOAYA_ID, true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.CREATURE, new Biome[0]);
        this.registerEntity(EntityBarakoanToPlayer.class, "TribesmanPlayer", false, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.CREATURE, new Biome[0]);
        this.registerEntity(EntityBarako.class, "TribeLeader", true, 12215894, 0xFFFF4D, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        EntityRegistry.registerModEntity(EntitySunstrike.class, (String)"Sunstrike", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntitySolarBeam.class, (String)"SolarBeam", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityDart.class, (String)"Dart", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
    }

    public void registerEntity(Class<? extends EntityLiving> entityClass, String name, boolean addEgg, int mainColor, int subColor, boolean addSpawn, int spawnFrequency, int minGroup, int maxGroup, EnumCreatureType typeOfCreature, Biome ... biomes) {
        int entityId = this.nextEntityId();
        EntityRegistry.registerModEntity(entityClass, (String)name, (int)entityId, (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        if (addEgg) {
            String id = "mowziesmobs." + name;
            this.entityEggs.put(id, new MowzieEntityEggInfo(id, entityClass, mainColor, subColor));
        }
        if (addSpawn) {
            EntityRegistry.addSpawn(entityClass, (int)spawnFrequency, (int)minGroup, (int)maxGroup, (EnumCreatureType)typeOfCreature, (Biome[])biomes);
        }
    }

    private int nextEntityId() {
        return this.nextEntityId++;
    }

    public MowzieEntityEggInfo getEntityEggInfo(String id) {
        return this.entityEggs.get(id);
    }

    public boolean hasEntityEggInfo(String name) {
        return this.entityEggs.containsKey(name);
    }

    public EntityLiving createEntity(String name, World world) {
        EntityLiving entity = null;
        try {
            Class<? extends EntityLiving> clazz = this.entityEggs.get((Object)name).clazz;
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public Iterator<MowzieEntityEggInfo> getEntityEggInfoIterator() {
        return this.entityEggs.values().iterator();
    }
}

