/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.creativetab.CreativeTabHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoMask;
import com.bobmowzie.mowziesmobs.server.property.MowziePlayerProperties;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemBarakoaMask
extends ItemArmor
implements BarakoaMask {
    private final MaskType type;

    public ItemBarakoaMask(MaskType type) {
        super(ItemArmor.ArmorMaterial.LEATHER, 2, EntityEquipmentSlot.HEAD);
        this.type = type;
        this.func_77655_b("barakoaMask." + type.name);
        this.func_77637_a(CreativeTabHandler.INSTANCE.creativeTab);
        this.setRegistryName("barakoa_mask_" + type.name);
    }

    public Potion getPotion() {
        return this.type.potion;
    }

    public EntityEquipmentSlot func_185083_B_() {
        return null;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack materialItemStack) {
        return false;
    }

    public int func_82814_b(ItemStack itemStack) {
        return -1;
    }

    public ItemArmor.ArmorMaterial func_82812_d() {
        return ItemArmor.ArmorMaterial.CHAIN;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack headStack = player.field_71071_by.field_70460_b[3];
        if (headStack != null && headStack.func_77973_b() instanceof ItemBarakoMask) {
            if (!player.field_70170_p.field_72995_K) {
                this.spawnBarakoa(this.type, player);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    private void spawnBarakoa(MaskType mask, EntityPlayer player) {
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property.getPackSize() < 10) {
            player.func_184185_a(MMSounds.ENTITY_BARAKO_BELLY, 1.5f, 1.0f);
            player.func_184185_a(MMSounds.ENTITY_BARAKOA_BLOWDART, 1.5f, 0.5f);
            double angle = player.func_70079_am();
            if (angle < 0.0) {
                angle += 360.0;
            }
            EntityBarakoanToPlayer barakoa = new EntityBarakoanToPlayer(player.field_70170_p);
            barakoa.setMask(mask);
            int weapon = mask != MaskType.FURY ? barakoa.randomizeWeapon() : 0;
            barakoa.setWeapon(weapon);
            barakoa.func_70080_a(player.field_70165_t + 1.0 * Math.sin(-angle * (Math.PI / 180)), player.field_70163_u + 1.5, player.field_70161_v + 1.0 * Math.cos(-angle * (Math.PI / 180)), (float)angle, 0.0f);
            barakoa.setActive(false);
            barakoa.active = false;
            property.addPackMember(barakoa);
            player.field_70170_p.func_72838_d((Entity)barakoa);
            barakoa.field_70159_w = 0.5 * Math.sin(-angle * Math.PI / 180.0);
            barakoa.field_70181_x = 0.5;
            barakoa.field_70179_y = 0.5 * Math.cos(-angle * Math.PI / 180.0);
        }
    }
}

