/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.world.structure.StructureBarakoaVillage;
import com.bobmowzie.mowziesmobs.server.world.structure.StructureWroughtnautRoom;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MowzieWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public static void generatePrePopulate(World world, Random random, int chunkX, int chunkZ) {
        if (MowzieWorldGenerator.canSpawnVillageAtCoords(chunkX, chunkZ, world)) {
            StructureBarakoaVillage.generateVillage(world, random, chunkX * 16 + 8, chunkZ * 16 + 8, 1);
        }
    }

    private static boolean canSpawnVillageAtCoords(int chunkX, int chunkZ, World world) {
        if (MowziesMobs.CONFIG.spawnrateBarako <= 0) {
            return false;
        }
        int maxDistanceBetweenVillages = MowziesMobs.CONFIG.spawnrateBarako + 8;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= maxDistanceBetweenVillages - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= maxDistanceBetweenVillages - 1;
        }
        int k = chunkX / maxDistanceBetweenVillages;
        int l = chunkZ / maxDistanceBetweenVillages;
        Random random = world.func_72843_D(k, l, 14357617);
        k *= maxDistanceBetweenVillages;
        l *= maxDistanceBetweenVillages;
        return i == (k += random.nextInt(maxDistanceBetweenVillages - 8)) && j == (l += random.nextInt(maxDistanceBetweenVillages - 8));
    }

    private void generateSurface(World world, Random random, int x, int z) {
        if (world.func_72912_H().func_76089_r()) {
            StructureWroughtnautRoom.tryWroughtChamber(world, random, x, z, MowziesMobs.CONFIG.spawnrateWroughtnaut);
        }
    }

    private void generateEnd(World world, Random random, int i, int i1) {
    }

    private void generateNether(World world, Random random, int i, int i1) {
    }
}

