/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSunstrike
extends Render<EntitySunstrike> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/sunstrike.png");
    private static final Random RANDOMIZER = new Random(0L);
    private static final double TEXTURE_WIDTH = 256.0;
    private static final double TEXTURE_HEIGHT = 32.0;
    private static final double BEAM_MIN_U = 0.875;
    private static final double BEAM_MAX_U = 1.0;
    private static final double PIXEL_SCALE = 0.0625;
    private static final int MAX_HEIGHT = 256;
    private static final float DRAW_FADE_IN_RATE = 2.0f;
    private static final float DRAW_FADE_IN_POINT = 0.5f;
    private static final float DRAW_OPACITY_MULTIPLER = 0.7f;
    private static final double RING_RADIUS = 1.6;
    private static final int RING_FRAME_SIZE = 16;
    private static final int RING_FRAME_COUNT = 10;
    private static final int BREAM_FRAME_COUNT = 31;
    private static final double BEAM_DRAW_START_RADIUS = 2.0;
    private static final double BEAM_DRAW_END_RADIUS = 0.25;
    private static final double BEAM_STRIKE_RADIUS = 1.0;
    private static final double LINGER_RADIUS = 1.2;
    private static final double SCORCH_MIN_U = 0.75;
    private static final double SCORCH_MAX_U = 0.8125;
    private static final double SCORCH_MIN_V = 0.5;
    private static final double SCORCH_MAX_V = 1.0;

    public RenderSunstrike(RenderManager mgr) {
        super(mgr);
    }

    public ResourceLocation getEntityTexture(EntitySunstrike entity) {
        return TEXTURE;
    }

    public void doRender(EntitySunstrike sunstrike, double x, double y, double z, float yaw, float delta) {
        double maxY = 256.0 - sunstrike.field_70163_u;
        if (maxY < 0.0) {
            return;
        }
        RANDOMIZER.setSeed(sunstrike.getVariant());
        boolean isLingering = sunstrike.isLingering(delta);
        boolean isStriking = sunstrike.isStriking(delta);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.setupGL();
        this.func_180548_c(sunstrike);
        if (isLingering) {
            this.drawScorch(sunstrike, delta);
        } else if (isStriking) {
            this.drawStrike(sunstrike, maxY, delta);
        }
        this.revertGL();
        GlStateManager.func_179121_F();
    }

    private void drawScorch(EntitySunstrike sunstrike, float delta) {
        World world = this.field_76990_c.field_78722_g;
        double ex = sunstrike.field_70142_S + (sunstrike.field_70165_t - sunstrike.field_70142_S) * (double)delta;
        double ey = sunstrike.field_70137_T + (sunstrike.field_70163_u - sunstrike.field_70137_T) * (double)delta;
        double ez = sunstrike.field_70136_U + (sunstrike.field_70161_v - sunstrike.field_70136_U) * (double)delta;
        int minX = MathHelper.func_76128_c((double)(ex - 1.2));
        int maxX = MathHelper.func_76128_c((double)(ex + 1.2));
        int minY = MathHelper.func_76128_c((double)(ey - 1.2));
        int maxY = MathHelper.func_76128_c((double)ey);
        int minZ = MathHelper.func_76128_c((double)(ez - 1.2));
        int maxZ = MathHelper.func_76128_c((double)(ez + 1.2));
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        float opacityMultiplier = (0.6f + RANDOMIZER.nextFloat() * 0.2f) * this.field_76990_c.field_78722_g.func_175724_o(new BlockPos(ex, ey, ez));
        byte mirrorX = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        byte mirrorZ = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)new BlockPos(minX, minY, minZ), (BlockPos)new BlockPos(maxX, maxY, maxZ))) {
            IBlockState block = world.func_180495_p(pos.func_177977_b());
            if (block.func_185904_a() == Material.field_151579_a || world.func_175699_k(pos) <= 3) continue;
            this.drawScorchBlock(world, block, pos, ex, ey, ez, opacityMultiplier, mirrorX, mirrorZ);
        }
        GlStateManager.func_179132_a((boolean)false);
        t.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void drawScorchBlock(World world, IBlockState block, BlockPos pos, double ex, double ey, double ez, float opacityMultiplier, byte mirrorX, byte mirrorZ) {
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        if (block.func_185898_k()) {
            int bx = pos.func_177958_n();
            int by = pos.func_177956_o();
            int bz = pos.func_177952_p();
            float opacity = (float)((1.0 - (ey - (double)by) / 2.0) * (double)opacityMultiplier);
            if (opacity >= 0.0f) {
                if (opacity > 1.0f) {
                    opacity = 1.0f;
                }
                AxisAlignedBB aabb = block.func_185900_c((IBlockAccess)world, pos);
                double minX = (double)bx + aabb.field_72340_a - ex;
                double maxX = (double)bx + aabb.field_72336_d - ex;
                double y = (double)by + aabb.field_72338_b - ey + 0.015625;
                double minZ = (double)bz + aabb.field_72339_c - ez;
                double maxZ = (double)bz + aabb.field_72334_f - ez;
                double minU = ((double)mirrorX * minX / 2.0 / 1.2 + 0.5) * 0.0625 + 0.75;
                double maxU = ((double)mirrorX * maxX / 2.0 / 1.2 + 0.5) * 0.0625 + 0.75;
                double minV = ((double)mirrorZ * minZ / 2.0 / 1.2 + 0.5) * 0.5 + 0.5;
                double maxV = ((double)mirrorZ * maxZ / 2.0 / 1.2 + 0.5) * 0.5 + 0.5;
                buf.func_181662_b(minX, y, minZ).func_187315_a(minU, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
                buf.func_181662_b(minX, y, maxZ).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
                buf.func_181662_b(maxX, y, maxZ).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
                buf.func_181662_b(maxX, y, minZ).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
            }
        }
    }

    private void drawStrike(EntitySunstrike sunstrike, double maxY, float delta) {
        float opacity;
        float drawTime = sunstrike.getStrikeDrawTime(delta);
        float strikeTime = sunstrike.getStrikeDamageTime(delta);
        boolean drawing = sunstrike.isStrikeDrawing(delta);
        float f = opacity = drawing && drawTime < 0.5f ? drawTime * 2.0f : 1.0f;
        if (drawing) {
            opacity *= 0.7f;
        }
        this.drawRing(drawing, drawTime, strikeTime, opacity);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        this.drawBeam(drawing, drawTime, strikeTime, opacity, maxY);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity) {
        int frame = (int)((drawing ? drawTime : strikeTime) * 11.0f);
        if (frame > 10) {
            frame = 10;
        }
        double minU = (double)(frame * 16) / 256.0;
        double maxU = minU + 0.0625;
        double minV = drawing ? 0.0 : 0.5;
        double maxV = minV + 0.5;
        double offset = 0.1 * (double)(frame % 2);
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        buf.func_181662_b(-1.6 + offset, 0.0, -1.6 + offset).func_187315_a(minU, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(-1.6 + offset, 0.0, 1.6 + offset).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(1.6 + offset, 0.0, 1.6 + offset).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(1.6 + offset, 0.0, -1.6 + offset).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        GlStateManager.func_179132_a((boolean)false);
        t.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void drawBeam(boolean drawing, float drawTime, float strikeTime, float opacity, double maxY) {
        int frame;
        int n = frame = drawing ? 0 : (int)(strikeTime * 32.0f);
        if (frame > 31) {
            frame = 31;
        }
        double radius = 1.0;
        if (drawing) {
            radius = -1.75 * (double)drawTime + 2.0;
        }
        double minV = (double)frame / 32.0;
        double maxV = (double)(frame + 1) / 32.0;
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        buf.func_181662_b(-radius, 0.0, 0.0).func_187315_a(0.875, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(-radius, maxY, 0.0).func_187315_a(0.875, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(radius, maxY, 0.0).func_187315_a(1.0, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(radius, 0.0, 0.0).func_187315_a(1.0, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        t.func_78381_a();
    }

    private void setupGL() {
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    private void revertGL() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }
}

