/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.EntityDart;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntityEggInfo;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaya;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityAxeAttack;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBreath;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityBabyFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public enum EntityHandler {
    INSTANCE;

    public static final String BARAKOAYA_ID = "barakoaya";
    private final Map<ResourceLocation, MowzieEntityEggInfo> entityEggs = new LinkedHashMap<ResourceLocation, MowzieEntityEggInfo>();
    private int nextEntityId;

    public void onInit() {
        this.registerEntity(EntityFoliaath.class, "foliaath", true, 4705339, 12598220, false, 20, 3, 1, EnumCreatureType.MONSTER, Biomes.field_76792_x, Biomes.field_76782_w, Biomes.field_150574_L);
        this.registerEntity(EntityBabyFoliaath.class, "baby_foliaath", false, 4705339, 12598220, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityWroughtnaut.class, "ferrous_wroughtnaut", true, 0x8C8C8C, 0xFFFFFF, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityBarakoanToBarakoana.class, "barakoan_barakoana", false, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityBarakoana.class, "barakoana", true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityBarakoaya.class, BARAKOAYA_ID, true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.CREATURE, new Biome[0]);
        this.registerEntity(EntityBarakoanToPlayer.class, "barakoan_player", false, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.CREATURE, new Biome[0]);
        this.registerEntity(EntityBarako.class, "barako", true, 12215894, 0xFFFF4D, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        this.registerEntity(EntityFrostmaw.class, "frostmaw", true, 0xF7FAFF, 11521535, false, 1, 1, 1, EnumCreatureType.MONSTER, new Biome[0]);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "sunstrike"), EntitySunstrike.class, (String)"sunstrike", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "solar_beam"), EntitySolarBeam.class, (String)"solar_beam", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "boulder"), EntityBoulder.class, (String)"boulder", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "axe_attack"), EntityAxeAttack.class, (String)"axe_attack", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "icebreath"), EntityIceBreath.class, (String)"icebreath", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "frozen_controller"), EntityFrozenController.class, (String)"frozen_controller", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "ring"), EntityRing.class, (String)"ring", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mowziesmobs", "dart"), EntityDart.class, (String)"dart", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
    }

    public void registerEntity(Class<? extends EntityLiving> entityClass, String name, boolean addEgg, int mainColor, int subColor, boolean addSpawn, int spawnFrequency, int minGroup, int maxGroup, EnumCreatureType typeOfCreature, Biome ... biomes) {
        int entityId = this.nextEntityId();
        ResourceLocation res = new ResourceLocation("mowziesmobs", name);
        EntityRegistry.registerModEntity((ResourceLocation)res, entityClass, (String)name, (int)entityId, (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        if (addEgg) {
            this.entityEggs.put(res, new MowzieEntityEggInfo(res, entityClass, mainColor, subColor));
        }
        if (addSpawn) {
            EntityRegistry.addSpawn(entityClass, (int)spawnFrequency, (int)minGroup, (int)maxGroup, (EnumCreatureType)typeOfCreature, (Biome[])biomes);
        }
    }

    private int nextEntityId() {
        return this.nextEntityId++;
    }

    public MowzieEntityEggInfo getEntityEggInfo(ResourceLocation id) {
        return this.entityEggs.get(id);
    }

    public boolean hasEntityEggInfo(ResourceLocation name) {
        return this.entityEggs.containsKey(name);
    }

    public EntityLiving createEntity(ResourceLocation id, World world) {
        EntityLiving entity = null;
        try {
            Class<? extends EntityLiving> clazz = this.entityEggs.get((Object)id).clazz;
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public Iterator<MowzieEntityEggInfo> getEntityEggInfoIterator() {
        return this.entityEggs.values().iterator();
    }
}

