/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.gui.GuiBarakoTrade;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaAttackTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationRadiusAttack;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSolarBeam;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSpawnBarakoa;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSunStrike;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import com.bobmowzie.mowziesmobs.server.gui.GuiHandler;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoTrade;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBarako
extends MowzieEntity
implements LeaderSunstrikeImmune,
GuiHandler.ContainerHolder {
    public static final Animation DIE_ANIMATION = Animation.create((int)130);
    public static final Animation HURT_ANIMATION = Animation.create((int)13);
    public static final Animation BELLY_ANIMATION = Animation.create((int)40);
    public static final Animation TALK_ANIMATION = Animation.create((int)80);
    public static final Animation SUNSTRIKE_ANIMATION = Animation.create((int)15);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)30);
    public static final Animation SPAWN_ANIMATION = Animation.create((int)20);
    public static final Animation SOLAR_BEAM_ANIMATION = Animation.create((int)100);
    public static final Animation BLESS_ANIMATION = Animation.create((int)60);
    private static final int MAX_HEALTH = 80;
    private static final int SUNSTRIKE_PAUSE_MAX = 40;
    private static final int SUNSTRIKE_PAUSE_MIN = 15;
    private static final int LASER_PAUSE = 230;
    private static final int BARAKOA_PAUSE = 150;
    private static final DataParameter<Integer> DIRECTION = EntityDataManager.func_187226_a(EntityBarako.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DIALOGUE = EntityDataManager.func_187226_a(EntityBarako.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityBarako.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> DESIRES = EntityDataManager.func_187226_a(EntityBarako.class, (DataSerializer)DataSerializers.field_187196_f);
    private final Set<UUID> tradedPlayers = new HashSet<UUID>();
    public ControlledAnimation legsUp = new ControlledAnimation(15);
    public ControlledAnimation angryEyebrow = new ControlledAnimation(5);
    private EntityPlayer customer;
    public int whichDialogue = 0;
    public int barakoaSpawnCount = 0;
    private int direction = 0;
    private boolean blocksByFeet = true;
    private int timeUntilSunstrike = 0;
    private int timeUntilLaser = 0;
    private int timeUntilBarakoa = 0;
    private EntityPlayer blessingPlayer;

    public EntityBarako(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BarakoaAttackTargetAI(this, EntityPlayer.class, 0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, false, false, null));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, 0, false, false, null));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityBarako>(this, BELLY_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityBarako>(this, TALK_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityBarako>(this, BLESS_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationSunStrike<EntityBarako>(this, SUNSTRIKE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationRadiusAttack<EntityBarako>(this, ATTACK_ANIMATION, 4.5f, 5, 3.0f, 12, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AnimationSpawnBarakoa(this, SPAWN_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationSolarBeam<EntityBarako>(this, SOLAR_BEAM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityBarako>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityBarako>(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityBarakoa.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(1.5f, 2.4f);
        if (this.getDirection() == 0) {
            this.setDirection(this.field_70146_Z.nextInt(4) + 1);
        }
        this.field_70728_aV = 45;
    }

    public EntityBarako(World world, int direction) {
        this(world);
        this.setDirection(direction);
    }

    public float func_70047_e() {
        return 1.4f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(80 * MowziesMobs.CONFIG.difficultyScaleBarako));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        if (this.getAnimation() == NO_ANIMATION) {
            if (this.func_70638_az() == null && !this.func_175446_cd()) {
                int soundType = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)9);
                if (soundType < MMSounds.ENTITY_BARAKO_TALK.length) {
                    this.func_184185_a(MMSounds.ENTITY_BARAKO_TALK[soundType], 2.0f, 1.0f);
                    this.setWhichDialogue(soundType + 1);
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, TALK_ANIMATION);
                }
            } else {
                int soundType = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)10);
                if (soundType < 7) {
                    this.func_184185_a(MMSounds.ENTITY_BARAKO_ANGRY[soundType - 1], 2.0f, 1.0f);
                }
            }
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return MMSounds.ENTITY_BARAKO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(MMSounds.ENTITY_BARAKO_DIE, 2.0f, 1.0f);
        return null;
    }

    @Override
    public void func_70071_h_() {
        double oz;
        double oy;
        double ox;
        double pitch;
        super.func_70071_h_();
        if (this.field_70173_aa == 1) {
            this.direction = this.getDirection();
        }
        if (this.getAnimation() != ATTACK_ANIMATION || this.getAnimationTick() < 12 || this.getAnimationTick() > 14) {
            this.repelEntities(2.2f, 2.5f, 2.2f, 2.2f);
        }
        this.field_70761_aq = this.field_70177_z = (float)((this.direction - 1) * 90);
        this.field_70165_t = this.field_70169_q;
        this.field_70161_v = this.field_70166_s;
        if (this.func_70638_az() != null) {
            EntityLivingBase target = this.func_70638_az();
            this.setAngry(true);
            float entityHitAngle = (float)((Math.atan2(target.field_70161_v - this.field_70161_v, target.field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70177_z % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = Math.abs(entityHitAngle - entityAttackingAngle);
            if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.func_110143_aJ() <= 60.0f && this.timeUntilLaser <= 0 && (entityRelativeAngle < 60.0f || entityRelativeAngle > 300.0f)) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SOLAR_BEAM_ANIMATION);
                this.timeUntilLaser = 230;
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.targetDistance <= 5.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ATTACK_ANIMATION);
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.field_70146_Z.nextInt(80) == 0 && this.getEntitiesNearby(EntityBarakoa.class, 16.0).size() < 5 && this.targetDistance > 5.0f && this.timeUntilBarakoa <= 0) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SPAWN_ANIMATION);
                this.timeUntilBarakoa = 150;
            } else if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.timeUntilSunstrike <= 0 && this.targetDistance > 5.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SUNSTRIKE_ANIMATION);
                this.timeUntilSunstrike = this.getTimeUntilSunstrike();
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.setAngry(false);
        }
        if (this.field_70173_aa % 20 == 0) {
            this.blocksByFeet = this.checkBlocksByFeet();
        }
        if (this.blocksByFeet) {
            this.legsUp.increaseTimer();
        } else {
            this.legsUp.decreaseTimer();
        }
        if (this.getAngry()) {
            this.angryEyebrow.increaseTimer();
        } else {
            this.angryEyebrow.decreaseTimer();
        }
        if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd() && this.func_70638_az() == null && this.field_70146_Z.nextInt(200) == 0) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BELLY_ANIMATION);
        }
        if (this.getAnimation() == BELLY_ANIMATION && (this.getAnimationTick() == 9 || this.getAnimationTick() == 29)) {
            this.func_184185_a(MMSounds.ENTITY_BARAKO_BELLY, 3.0f, 1.0f);
        }
        if (this.getAnimation() == TALK_ANIMATION && this.getAnimationTick() == 1) {
            this.whichDialogue = this.getWhichDialogue();
        }
        if (this.getAnimation() == ATTACK_ANIMATION) {
            this.field_70759_as = this.field_70177_z;
            if (this.getAnimationTick() == 1) {
                this.func_184185_a(MMSounds.ENTITY_BARAKO_BURST, 1.7f, 1.5f);
            }
            if (this.getAnimationTick() == 10) {
                if (this.field_70170_p.field_72995_K) {
                    this.spawnExplosionParticles(30);
                }
                this.func_184185_a(MMSounds.ENTITY_BARAKO_ATTACK, 1.7f, 0.9f);
            }
            if (this.getAnimationTick() <= 6 && this.field_70170_p.field_72995_K) {
                int particleCount = 8;
                while (--particleCount != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    double offsetX = -0.3 * Math.sin((double)this.field_70177_z * Math.PI / 180.0);
                    double offsetZ = -0.3 * Math.cos((double)this.field_70177_z * Math.PI / 180.0);
                    double offsetY = 1.0;
                    MMParticle.ORB.spawn(this.field_70170_p, this.field_70165_t + ox + offsetX, this.field_70163_u + offsetY + oy, this.field_70161_v + oz + offsetZ, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 6));
                }
            }
        }
        if (this.getAnimation() == BLESS_ANIMATION) {
            this.field_70759_as = this.field_70177_z;
            if (this.getAnimationTick() == 1) {
                this.blessingPlayer = this.getCustomer();
            }
            if (this.getAnimationTick() > 5 && this.getAnimationTick() < 40 && this.field_70170_p.field_72995_K && this.blessingPlayer != null) {
                int particleCount = 2;
                while (--particleCount != 0) {
                    double radius = 0.7f;
                    double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    MMParticle.ORB.spawn(this.field_70170_p, this.field_70165_t + ox, this.field_70163_u + (double)0.8f + oy, this.field_70161_v + oz, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.blessingPlayer.field_70165_t, this.blessingPlayer.field_70163_u + (double)(this.blessingPlayer.field_70131_O / 2.0f), this.blessingPlayer.field_70161_v, 20));
                }
            }
            if (this.getAnimationTick() % 15 == 0) {
                EntityRing ring = new EntityRing(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u + 0.8f, (float)this.field_70161_v, new Vec3d(0.0, 0.0, 0.0), 15, 1.0f, 0.8745098f, 0.25882354f, 1.0f, 3.5f, true);
                this.field_70170_p.func_72838_d((Entity)ring);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.getAnimation() != SOLAR_BEAM_ANIMATION) {
            this.func_70691_i(0.1f);
        }
        if (this.timeUntilSunstrike > 0) {
            --this.timeUntilSunstrike;
        }
        if (this.timeUntilLaser > 0) {
            --this.timeUntilLaser;
        }
        if (this.timeUntilBarakoa > 0) {
            --this.timeUntilBarakoa;
        }
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    private boolean checkBlocksByFeet() {
        IBlockState blockRight;
        IBlockState blockLeft;
        if (this.direction == 1) {
            blockLeft = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1));
            blockRight = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1));
        } else if (this.direction == 2) {
            blockLeft = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1));
            blockRight = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1));
        } else if (this.direction == 3) {
            blockLeft = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1));
            blockRight = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1));
        } else if (this.direction == 4) {
            blockLeft = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1));
            blockRight = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1));
        } else {
            return false;
        }
        return !(blockLeft.func_177230_c() instanceof BlockAir) || !(blockRight.func_177230_c() instanceof BlockAir);
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.field_70146_Z.nextFloat() * 0.1f - 0.05f;
            float vx = 0.25f * MathHelper.func_76134_b((float)yaw);
            float vz = 0.25f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (double)vx, (double)vy, (double)vz, new int[0]);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DIRECTION, (Object)0);
        this.func_184212_Q().func_187214_a(DIALOGUE, (Object)0);
        this.func_184212_Q().func_187214_a(ANGRY, (Object)false);
        this.func_184212_Q().func_187214_a(DESIRES, (Object)new ItemStack(Item.func_150898_a((Block)Blocks.field_150340_R), 10));
    }

    public int getDirection() {
        return (Integer)this.func_184212_Q().func_187225_a(DIRECTION);
    }

    public void setDirection(int direction) {
        this.func_184212_Q().func_187227_b(DIRECTION, (Object)direction);
    }

    public int getWhichDialogue() {
        return (Integer)this.func_184212_Q().func_187225_a(DIALOGUE);
    }

    public void setWhichDialogue(int dialogue) {
        this.func_184212_Q().func_187227_b(DIALOGUE, (Object)dialogue);
    }

    public boolean getAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.func_184212_Q().func_187227_b(ANGRY, (Object)angry);
    }

    public void setDesires(ItemStack stack) {
        this.func_184212_Q().func_187227_b(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DESIRES);
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntityBarako.canPayFor(stack, this.getDesires());
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntityBarako.canPayFor(input.func_75211_c(), desires)) {
            input.func_75209_a(desires.func_190916_E());
            return true;
        }
        return false;
    }

    public boolean hasTradedWith(EntityPlayer player) {
        return this.tradedPlayers.contains(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public void rememberTrade(EntityPlayer player) {
        this.tradedPlayers.add(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("direction", this.getDirection());
        NBTTagList players = new NBTTagList();
        for (UUID uuid : this.tradedPlayers) {
            players.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid));
        }
        compound.func_74782_a("players", (NBTBase)players);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDirection(compound.func_74762_e("direction"));
        this.tradedPlayers.clear();
        NBTTagList players = compound.func_150295_c("players", 10);
        for (int i = 0; i < players.func_74745_c(); ++i) {
            this.tradedPlayers.add(NBTUtil.func_186860_b((NBTTagCompound)players.func_150305_b(i)));
        }
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    private int getTimeUntilSunstrike() {
        int damageTaken = (int)(80.0f - this.func_110143_aJ());
        if (damageTaken > 60) {
            damageTaken = 60;
        }
        return (int)(40.0f - (float)damageTaken / 60.0f * 25.0f);
    }

    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, BELLY_ANIMATION, TALK_ANIMATION, SUNSTRIKE_ANIMATION, ATTACK_ANIMATION, SPAWN_ANIMATION, SOLAR_BEAM_ANIMATION, BLESS_ANIMATION};
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        List<EntityBarakoa> barakoa = this.getEntitiesNearby(EntityBarakoa.class, 20.0, 10.0, 20.0, 20.0);
        for (EntityBarakoa entityBarakoa : barakoa) {
            if (!entityBarakoa.isBarakoDevoted()) continue;
            entityBarakoa.timeUntilDeath = this.field_70146_Z.nextInt(20);
        }
        super.func_70645_a(cause);
    }

    @Override
    protected void dropLoot() {
        super.dropLoot();
        this.func_145779_a((Item)ItemHandler.INSTANCE.barakoMask, 1);
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    public EntityPlayer getCustomer() {
        return this.customer;
    }

    public void setCustomer(EntityPlayer customer) {
        this.customer = customer;
    }

    @Override
    public Container createContainer(World world, EntityPlayer player, int x, int y, int z) {
        return new ContainerBarakoTrade(this, player.field_71071_by, world);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(World world, EntityPlayer player, int x, int y, int z) {
        return new GuiBarakoTrade(this, player.field_71071_by, world, y != 0);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.canTradeWith(player)) {
            this.setCustomer(player);
            if (!this.field_70170_p.field_72995_K) {
                GuiHandler.open(GuiHandler.BARAKO_TRADE, player, this, this.hasTradedWith(player) ? 1 : 0);
            }
            return true;
        }
        return false;
    }

    public boolean canTradeWith(EntityPlayer player) {
        if (this.isTrading()) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return headStack.func_77973_b() instanceof BarakoaMask;
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.func_77973_b() == worth.func_77973_b() && stack.func_190916_E() >= worth.func_190916_E();
    }
}

