/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class EntityBarakoan<L extends EntityLivingBase>
extends EntityBarakoa {
    protected static final Optional<UUID> ABSENT_LEADER = Optional.absent();
    private static final DataParameter<Optional<UUID>> LEADER = EntityDataManager.func_187226_a(EntityBarakoan.class, (DataSerializer)DataSerializers.field_187203_m);
    private final Class<L> leaderClass;
    public int index;
    protected L leader;

    public EntityBarakoan(World world, Class<L> leaderClass) {
        this(world, leaderClass, null);
    }

    public EntityBarakoan(World world, Class<L> leaderClass, L leader) {
        super(world);
        this.leaderClass = leaderClass;
        this.leader = leader;
        if (leader != null) {
            this.setLeaderUUID(leader.func_110124_au());
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEADER, ABSENT_LEADER);
    }

    public Optional<UUID> getLeaderUUID() {
        return (Optional)this.func_184212_Q().func_187225_a(LEADER);
    }

    public void setLeaderUUID(UUID uuid) {
        this.setLeaderUUID((Optional<UUID>)Optional.of((Object)uuid));
    }

    public void setLeaderUUID(Optional<UUID> uuid) {
        this.func_184212_Q().func_187227_b(LEADER, uuid);
    }

    @Override
    protected String getPickedEntityId() {
        return "mowziesmobs.barakoaya";
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.leader == null && this.getLeaderUUID().isPresent()) {
            this.leader = this.getLeader();
            if (this.leader != null) {
                this.addAsPackMember();
            }
        }
    }

    @Override
    protected void updateCircling() {
        if (this.leader != null) {
            if (!this.attacking && this.targetDistance < 5.0f) {
                this.circleEntity((Entity)this.func_70638_az(), 7.0f, 0.3f, true, this.getTribeCircleTick(), (float)((double)(this.index + 1) * (Math.PI * 2) / (double)(this.getPackSize() + 1)), 1.75f);
            } else {
                this.circleEntity((Entity)this.func_70638_az(), 7.0f, 0.3f, true, this.getTribeCircleTick(), (float)((double)(this.index + 1) * (Math.PI * 2) / (double)(this.getPackSize() + 1)), 1.0f);
            }
        } else {
            super.updateCircling();
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (this.leader != null) {
            this.removeAsPackMember();
        }
    }

    public L getLeader() {
        Optional<UUID> uuid = this.getLeaderUUID();
        if (uuid.isPresent()) {
            List potentialLeaders = this.field_70170_p.func_72872_a(this.leaderClass, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
            for (EntityLivingBase entity : potentialLeaders) {
                if (!((UUID)uuid.get()).equals(entity.func_110124_au())) continue;
                return (L)entity;
            }
        }
        return null;
    }

    protected boolean func_70692_ba() {
        return this.leader == null;
    }

    protected abstract int getTribeCircleTick();

    protected abstract int getPackSize();

    protected abstract void addAsPackMember();

    protected abstract void removeAsPackMember();

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        Optional<UUID> leader = this.getLeaderUUID();
        if (leader.isPresent()) {
            compound.func_74778_a("leaderUUID", ((UUID)leader.get()).toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        String uuid = compound.func_74779_i("leaderUUID");
        if (uuid.isEmpty()) {
            this.setLeaderUUID(ABSENT_LEADER);
        } else {
            this.setLeaderUUID(UUID.fromString(uuid));
        }
    }
}

