/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.wroughtnaut;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNStompAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNVerticalAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.SmartBodyHelper;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Optional;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityWroughtnaut
extends MowzieEntity {
    public static final Animation DIE_ANIMATION = Animation.create((int)130);
    public static final Animation HURT_ANIMATION = Animation.create((int)15);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)50);
    public static final Animation VERTICAL_ATTACK_ANIMATION = Animation.create((int)105);
    public static final Animation STOMP_ATTACK_ANIMATION = Animation.create((int)40);
    public static final Animation ACTIVATE_ANIMATION = Animation.create((int)45);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create((int)15);
    public static final Animation DAB_ANIMATION = Animation.create((int)18);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION, VERTICAL_ATTACK_ANIMATION, STOMP_ATTACK_ANIMATION, DAB_ANIMATION, ACTIVATE_ANIMATION, DEACTIVATE_ANIMATION};
    private static final float[][] VERTICAL_ATTACK_BLOCK_OFFSETS = new float[][]{{-0.1f, -0.1f}, {-0.1f, 0.1f}, {0.1f, 0.1f}, {0.1f, -0.1f}};
    private static final DataParameter<Optional<BlockPos>> REST_POSITION = EntityDataManager.func_187226_a(EntityWroughtnaut.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityWroughtnaut.class, (DataSerializer)DataSerializers.field_187198_h);
    public ControlledAnimation walkAnim = new ControlledAnimation(10);
    public boolean swingDirection;
    public boolean vulnerable;
    private int attacksWithoutVertical;
    private int ticksSinceLastStomp;
    private CeilingDisturbance disturbance;

    public EntityWroughtnaut(World world) {
        super(world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationFWNAttackAI(this, ATTACK_ANIMATION, MMSounds.ENTITY_WROUGHT_WHOOSH, 4.0f, 5.5f, 100.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationFWNVerticalAttackAI(this, VERTICAL_ATTACK_ANIMATION, MMSounds.ENTITY_WROUGHT_WHOOSH, 1.0f, 5.5f, 40.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationFWNStompAttackAI(this, STOMP_ATTACK_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityWroughtnaut>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityWroughtnaut>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationActivateAI<EntityWroughtnaut>(this, ACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationDeactivateAI<EntityWroughtnaut>(this, DEACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationAI<EntityWroughtnaut>(this, DAB_ANIMATION){
            {
                this.func_75248_a(8);
            }

            public void func_75246_d() {
                ((EntityWroughtnaut)this.animatingEntity).field_70159_w = 0.0;
                ((EntityWroughtnaut)this.animatingEntity).field_70179_y = 0.0;
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70728_aV = 30;
        this.func_70105_a(2.5f, 3.7f);
        this.active = false;
        this.field_70138_W = 1.0f;
    }

    protected SmartBodyHelper createBodyHelper() {
        return new SmartBodyHelper((EntityLiving)this);
    }

    @Override
    public int getAttack() {
        return 30;
    }

    public SoundEvent func_184601_bQ() {
        return MMSounds.ENTITY_WROUGHT_HURT_1;
    }

    public SoundEvent func_184615_bR() {
        return MMSounds.ENTITY_WROUGHT_SCREAM;
    }

    protected SoundEvent func_184639_G() {
        return this.getAnimation() == NO_ANIMATION && this.isActive() ? MMSounds.ENTITY_WROUGHT_AMBIENT : null;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null) {
            if (this.vulnerable) {
                float entityRelativeAngle;
                int arc = 220;
                Entity entitySource = source.func_76346_g();
                float entityHitAngle = (float)((Math.atan2(entitySource.field_70161_v - this.field_70161_v, entitySource.field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.field_70761_aq % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                if ((entityRelativeAngle = entityHitAngle - entityAttackingAngle) <= (float)(arc / 2) && entityRelativeAngle >= (float)(-arc / 2) || entityRelativeAngle >= (float)(360 - arc / 2) || entityRelativeAngle <= (float)(-arc + 45)) {
                    this.func_184185_a(SoundEvents.field_187689_f, 0.4f, 2.0f);
                    return false;
                }
                if (this.currentAnim != null) {
                    this.currentAnim.func_75251_c();
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, NO_ANIMATION);
                }
                return super.func_70097_a(source, amount);
            }
            this.func_184185_a(SoundEvents.field_187689_f, 0.4f, 2.0f);
        }
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimation() == NO_ANIMATION && !this.func_175446_cd()) {
                if (this.isActive()) {
                    if (this.func_70638_az() == null && this.field_70701_bs == 0.0f && this.isAtRestPos()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, DEACTIVATE_ANIMATION);
                        this.setActive(false);
                    }
                } else if (this.func_70638_az() != null && this.targetDistance <= 5.0f) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_ANIMATION);
                    this.setActive(true);
                }
            }
            ++this.ticksSinceLastStomp;
        }
        if (!this.isActive()) {
            this.field_70165_t = this.field_70169_q;
            this.field_70161_v = this.field_70166_s;
            this.field_70177_z = this.field_70126_B;
        }
        this.field_70761_aq = this.field_70177_z;
        if (this.func_70638_az() != null && this.isActive()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.2);
            } else {
                this.func_70661_as().func_75499_g();
            }
            if (this.func_70638_az().field_70163_u - this.field_70163_u >= -1.0 && this.func_70638_az().field_70163_u - this.field_70163_u <= 3.0 && this.getAnimation() == NO_ANIMATION && !this.func_175446_cd()) {
                boolean couldStomp;
                boolean bl = couldStomp = this.targetDistance < 6.0f && this.ticksSinceLastStomp > 600;
                if ((double)this.targetDistance < 3.5 && Math.abs(MathHelper.func_76138_g((double)(this.getAngleBetweenEntities((Entity)this.func_70638_az(), (Entity)this) - (double)this.field_70177_z))) < 35.0 && (!couldStomp || this.field_70146_Z.nextInt(3) > 0)) {
                    if (this.attacksWithoutVertical >= 4 || this.field_70146_Z.nextInt(4) == 0) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, VERTICAL_ATTACK_ANIMATION);
                        this.attacksWithoutVertical = 0;
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ATTACK_ANIMATION);
                        ++this.attacksWithoutVertical;
                    }
                } else if (couldStomp) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, STOMP_ATTACK_ANIMATION);
                    this.ticksSinceLastStomp = 0;
                    ++this.attacksWithoutVertical;
                }
            }
        } else {
            this.updateRestPos();
        }
        if (this.getAnimation() == ATTACK_ANIMATION && this.getAnimationTick() == 1) {
            this.swingDirection = this.field_70146_Z.nextBoolean();
        } else if (this.getAnimation() == ACTIVATE_ANIMATION) {
            int tick = this.getAnimationTick();
            if (tick == 1) {
                this.func_184185_a(MMSounds.ENTITY_WROUGHT_GRUNT_2, 1.0f, 1.0f);
            } else if (tick == 27 || tick == 44) {
                this.func_184185_a(SoundEvents.field_187928_hb, 0.5f, 0.5f);
            }
        } else if (this.getAnimation() == VERTICAL_ATTACK_ANIMATION && this.getAnimationTick() == 29) {
            this.doVerticalAttackHitFX();
        }
        float moveX = (float)(this.field_70165_t - this.field_70169_q);
        float moveZ = (float)(this.field_70161_v - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if ((double)speed > 0.01) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.walkAnim.increaseTimer();
            }
        } else {
            this.walkAnim.decreaseTimer();
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.walkAnim.decreaseTimer(2);
        }
        if (this.frame % 20 == 5 && (double)speed > 0.03 && this.getAnimation() == NO_ANIMATION && this.active) {
            this.func_184185_a(SoundEvents.field_187928_hb, 0.5f, 0.5f);
        }
        this.repelEntities(2.2f, 4.0f, 2.2f, 2.2f);
        if (!this.active && this.func_70638_az() == null) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, 1, true, true));
        }
        if (this.disturbance != null && this.disturbance.update()) {
            this.disturbance = null;
        }
    }

    private boolean isAtRestPos() {
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            return ((BlockPos)restPos.get()).func_177951_i((Vec3i)this.func_180425_c()) < 36.0;
        }
        return false;
    }

    private void updateRestPos() {
        boolean reassign = true;
        if (this.getRestPos().isPresent()) {
            BlockPos pos = (BlockPos)this.getRestPos().get();
            if (this.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.2)) {
                reassign = false;
            }
        }
        if (reassign) {
            this.setRestPos(this.func_180425_c());
        }
    }

    private void doVerticalAttackHitFX() {
        double theta = (double)(this.field_70761_aq - 4.0f) * (Math.PI / 180);
        double perpX = Math.cos(theta);
        double perpZ = Math.sin(theta);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double x = this.field_70165_t + 4.2 * vecX;
        double y = this.func_174813_aQ().field_72338_b + 0.1;
        double z = this.field_70161_v + 4.2 * vecZ;
        int hitY = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2));
        for (int t = 0; t < VERTICAL_ATTACK_BLOCK_OFFSETS.length; ++t) {
            int hitZ;
            float ox = VERTICAL_ATTACK_BLOCK_OFFSETS[t][0];
            float oy = VERTICAL_ATTACK_BLOCK_OFFSETS[t][1];
            int hitX = MathHelper.func_76128_c((double)(x + (double)ox));
            BlockPos hit = new BlockPos(hitX, hitY, hitZ = MathHelper.func_76128_c((double)(z + (double)oy)));
            IBlockState block = this.field_70170_p.func_180495_p(hit);
            if (block.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
            int stateId = Block.func_176210_f((IBlockState)block);
            for (int n = 0; n < 6; ++n) {
                double pa = this.field_70146_Z.nextDouble() * 2.0 * Math.PI;
                double pd = this.field_70146_Z.nextDouble() * 0.6 + 0.1;
                double px = x + Math.cos(pa) * pd;
                double pz = z + Math.sin(pa) * pd;
                double magnitude = this.field_70146_Z.nextDouble() * 4.0 + 5.0;
                double velX = perpX * magnitude;
                double velY = this.field_70146_Z.nextDouble() * 3.0 + 6.0;
                double velZ = perpZ * magnitude;
                if (vecX * (pz - this.field_70161_v) - vecZ * (px - this.field_70165_t) > 0.0) {
                    velX = -velX;
                    velZ = -velZ;
                }
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, px, y, pz, velX, velY, velZ, new int[]{stateId});
            }
        }
        int hitX = MathHelper.func_76128_c((double)x);
        int ceilY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72337_e);
        int hitZ = MathHelper.func_76128_c((double)z);
        int maxHeight = 5;
        int height = 5;
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        while (height-- > 0) {
            pos.func_181079_c(hitX, ceilY, hitZ);
            if (this.field_70170_p.func_180495_p((BlockPos)pos).func_185904_a().func_76230_c()) break;
            ++ceilY;
        }
        pos.func_185344_t();
        float strength = (float)height / 5.0f;
        if (strength >= 0.0f) {
            int radius = MathHelper.func_76123_f((float)(MathHelper.func_76129_c((float)(1.0f - strength * strength)) * 5.0f));
            this.disturbance = new CeilingDisturbance(hitX, ceilY, hitZ, radius, this.field_70146_Z.nextInt(5) + 3, this.field_70146_Z.nextInt(60) + 20);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setRestPos(this.func_180425_c());
        return super.func_180482_a(difficulty, data);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(REST_POSITION, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)false);
    }

    public Optional<BlockPos> getRestPos() {
        return (Optional)this.func_184212_Q().func_187225_a(REST_POSITION);
    }

    public void setRestPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(REST_POSITION, (Object)Optional.of((Object)pos));
    }

    public boolean isActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)isActive);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            compound.func_74782_a("restPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)((BlockPos)this.getRestPos().get())));
        }
        compound.func_74757_a("active", this.isActive());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("restPos", 10)) {
            this.setRestPos(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("restPos")));
        }
        this.setActive(compound.func_74767_n("active"));
    }

    @Override
    protected void dropLoot() {
        super.dropLoot();
        this.func_145779_a(ItemHandler.INSTANCE.wroughtAxe, 1);
        this.func_145779_a(ItemHandler.INSTANCE.wroughtHelmet, 1);
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    private class CeilingDisturbance {
        private final int ceilX;
        private final int ceilY;
        private final int ceilZ;
        private final int radius;
        private int delay;
        private int remainingTicks;
        private int duration;

        public CeilingDisturbance(int x, int y, int z, int radius, int delay, int remainingTicks) {
            this.ceilX = x;
            this.ceilY = y;
            this.ceilZ = z;
            this.radius = radius;
            this.delay = delay;
            this.remainingTicks = remainingTicks;
            this.duration = remainingTicks;
        }

        public boolean update() {
            if (--this.delay > 0) {
                return false;
            }
            float t = (float)this.remainingTicks / (float)this.duration;
            int amount = MathHelper.func_76123_f((float)((1.0f - MathHelper.func_76129_c((float)(1.0f - t * t))) * (float)this.radius * (float)this.radius * 0.15f));
            boolean playSound = true;
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
            while (amount-- > 0) {
                double theta = EntityWroughtnaut.this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                double dist = EntityWroughtnaut.this.field_70146_Z.nextDouble() * (double)this.radius;
                double x = (double)this.ceilX + Math.cos(theta) * dist;
                double y = (double)this.ceilY - 0.1 - EntityWroughtnaut.this.field_70146_Z.nextDouble() * 0.3;
                double z = (double)this.ceilZ + Math.sin(theta) * dist;
                int blockX = MathHelper.func_76128_c((double)x);
                int blockZ = MathHelper.func_76128_c((double)z);
                pos.func_181079_c(blockX, this.ceilY, blockZ);
                IBlockState block = EntityWroughtnaut.this.field_70170_p.func_180495_p((BlockPos)pos);
                if (block.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
                int stateId = Block.func_176210_f((IBlockState)block);
                EntityWroughtnaut.this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, x, y, z, 0.0, 0.0, 0.0, new int[]{stateId});
                if (!playSound || !(EntityWroughtnaut.this.field_70146_Z.nextFloat() < 0.075f)) continue;
                SoundType sound = block.func_177230_c().func_185467_w();
                EntityWroughtnaut.this.field_70170_p.func_184134_a(EntityWroughtnaut.this.field_70165_t, EntityWroughtnaut.this.field_70163_u, EntityWroughtnaut.this.field_70161_v, sound.func_185845_c(), SoundCategory.BLOCKS, sound.func_185843_a() * 2.0f, sound.func_185847_b() * 0.6f, false);
                playSound = false;
            }
            pos.func_185344_t();
            return --this.remainingTicks <= 0;
        }
    }
}

