/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.gui;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaya;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public final class GuiHandler
implements IGuiHandler {
    private static final RegistryNamespaced<ResourceLocation, GuiType> GUIS = new RegistryNamespaced();
    public static final GuiTypeEntity<EntityBarakoaya> BARAKOA_TRADE = new GuiTypeEntity<EntityBarakoaya>(EntityBarakoaya.class);
    public static final GuiTypeEntity<EntityBarako> BARAKO_TRADE = new GuiTypeEntity<EntityBarako>(EntityBarako.class);

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        GuiType type = (GuiType)GUIS.func_148754_a(id);
        if (type != null) {
            return type.createContainer(world, player, x, y, z);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        GuiType type = (GuiType)GUIS.func_148754_a(id);
        if (type != null) {
            return type.createGui(world, player, x, y, z);
        }
        return null;
    }

    public static <T extends Entity> void open(GuiTypeEntity<T> type, EntityPlayer player, T entity) {
        GuiHandler.open(type, player, entity.func_145782_y(), 0, 0);
    }

    public static <T extends Entity> void open(GuiTypeEntity<T> type, EntityPlayer player, T entity, int y) {
        GuiHandler.open(type, player, entity.func_145782_y(), y, 0);
    }

    public static <T extends Entity> void open(GuiTypeEntity<T> type, EntityPlayer player, T entity, int y, int z) {
        GuiHandler.open(type, player, entity.func_145782_y(), y, z);
    }

    public static <T extends TileEntity> void open(GuiTypeBlock<T> type, EntityPlayer player, T blockEntity) {
        BlockPos pos = blockEntity.func_174877_v();
        GuiHandler.open(type, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void open(GuiType type, EntityPlayer player, int x, int y, int z) {
        player.openGui((Object)MowziesMobs.INSTANCE, GUIS.func_148757_b((Object)type), player.field_70170_p, x, y, z);
    }

    static {
        GUIS.func_177775_a(0, (Object)new ResourceLocation("mowziesmobs", "barakoa"), BARAKOA_TRADE);
        GUIS.func_177775_a(1, (Object)new ResourceLocation("mowziesmobs", "barako"), BARAKO_TRADE);
    }

    public static class GuiTypeEntity<T extends Entity>
    extends GuiType<T> {
        public GuiTypeEntity(Class<T> entityClass) {
            super(entityClass);
        }

        protected Entity get(World world, EntityPlayer player, int x, int y, int z) {
            return world.func_73045_a(x);
        }
    }

    public static class GuiTypeBlock<T extends TileEntity>
    extends GuiType<T> {
        public GuiTypeBlock(Class<T> blockEntityClass) {
            super(blockEntityClass);
        }

        protected TileEntity get(World world, EntityPlayer player, int x, int y, int z) {
            return world.func_175625_s(new BlockPos(x, y, z));
        }
    }

    public static abstract class GuiType<T extends ContainerHolder> {
        private final Class<T> clazz;

        protected GuiType(Class<T> clazz) {
            this.clazz = clazz;
        }

        public final Container createContainer(World world, EntityPlayer player, int x, int y, int z) {
            T obj = this.getAsType(world, player, x, y, z);
            if (obj != null) {
                return obj.createContainer(world, player, x, y, z);
            }
            return null;
        }

        public final GuiContainer createGui(World world, EntityPlayer player, int x, int y, int z) {
            T obj = this.getAsType(world, player, x, y, z);
            if (obj != null) {
                return obj.createGui(world, player, x, y, z);
            }
            return null;
        }

        private T getAsType(World world, EntityPlayer player, int x, int y, int z) {
            Object obj = this.get(world, player, x, y, z);
            if (obj != null && this.clazz.isAssignableFrom(obj.getClass())) {
                return (T)((ContainerHolder)obj);
            }
            return null;
        }

        protected abstract Object get(World var1, EntityPlayer var2, int var3, int var4, int var5);
    }

    public static interface ContainerHolder {
        public Container createContainer(World var1, EntityPlayer var2, int var3, int var4, int var5);

        public GuiContainer createGui(World var1, EntityPlayer var2, int var3, int var4, int var5);
    }
}

