/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.EntitySolarBeam;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SolarBeamRenderer
extends Render {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/textureSolarBeam.png");
    private static final double TEXTURE_WIDTH = 256.0;
    private static final double TEXTURE_HEIGHT = 32.0;
    private static final double START_RADIUS = 1.3;
    private static final double BEAM_RADIUS = 1.0;
    private boolean clearerView = false;

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float delta) {
        EntitySolarBeam solarBeam = (EntitySolarBeam)entity;
        this.clearerView = solarBeam.caster instanceof EntityPlayer && Minecraft.func_71410_x().field_71439_g == solarBeam.caster && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        double length = Math.sqrt(Math.pow(solarBeam.collidePosX - solarBeam.field_70165_t, 2.0) + Math.pow(solarBeam.collidePosY - solarBeam.field_70163_u, 2.0) + Math.pow(solarBeam.collidePosZ - solarBeam.field_70161_v, 2.0));
        int frame = MathHelper.func_76128_c((double)(((float)(solarBeam.appear.getTimer() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.setupGL();
        this.func_110777_b(solarBeam);
        GL11.glDepthMask((boolean)false);
        this.renderStart(frame);
        this.renderBeam(length, 57.29577951308232 * solarBeam.getYaw(), 57.29577951308232 * solarBeam.getPitch(), frame);
        GL11.glTranslated((double)(solarBeam.collidePosX - solarBeam.field_70165_t), (double)(solarBeam.collidePosY - solarBeam.field_70163_u), (double)(solarBeam.collidePosZ - solarBeam.field_70161_v));
        this.renderEnd(frame, solarBeam.blockSide);
        GL11.glDepthMask((boolean)true);
        GL11.glTranslated((double)(solarBeam.field_70165_t - solarBeam.collidePosX), (double)(solarBeam.field_70163_u - solarBeam.collidePosY), (double)(solarBeam.field_70161_v - solarBeam.collidePosZ));
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            this.renderStart(frame);
        }
        this.renderBeam(length, 57.29577951308232 * solarBeam.getYaw(), 57.29577951308232 * solarBeam.getPitch(), frame);
        GL11.glTranslated((double)(solarBeam.collidePosX - solarBeam.field_70165_t), (double)(solarBeam.collidePosY - solarBeam.field_70163_u), (double)(solarBeam.collidePosZ - solarBeam.field_70161_v));
        this.renderEnd(frame, -1);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.revertGL();
        GL11.glPopMatrix();
    }

    private void renderStart(int frame) {
        if (this.clearerView) {
            return;
        }
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        double minU = 0.0 + 0.0625 * (double)frame;
        double minV = 0.0;
        double maxU = minU + 0.0625;
        double maxV = minV + 0.5;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        t.func_78374_a(-1.3, -1.3, 0.0, minU, minV);
        t.func_78374_a(-1.3, 1.3, 0.0, minU, maxV);
        t.func_78374_a(1.3, 1.3, 0.0, maxU, maxV);
        t.func_78374_a(1.3, -1.3, 0.0, maxU, minV);
        t.func_78381_a();
        GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)-1.0f, (float)0.0f);
    }

    private void renderEnd(int frame, int side) {
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        double minU = 0.0 + 0.0625 * (double)frame;
        double minV = 0.0;
        double maxU = minU + 0.0625;
        double maxV = minV + 0.5;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        t.func_78374_a(-1.3, -1.3, 0.0, minU, minV);
        t.func_78374_a(-1.3, 1.3, 0.0, minU, maxV);
        t.func_78374_a(1.3, 1.3, 0.0, maxU, maxV);
        t.func_78374_a(1.3, -1.3, 0.0, maxU, minV);
        t.func_78381_a();
        GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)-1.0f, (float)0.0f);
        if (side == -1) {
            return;
        }
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        t.func_78374_a(-1.3, -1.3, 0.0, minU, minV);
        t.func_78374_a(-1.3, 1.3, 0.0, minU, maxV);
        t.func_78374_a(1.3, 1.3, 0.0, maxU, maxV);
        t.func_78374_a(1.3, -1.3, 0.0, maxU, minV);
        if (side == 5) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            t.func_78381_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glRotatef((float)-270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (side == 4) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            t.func_78381_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (side == 3) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            t.func_78381_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (side == 2) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            t.func_78381_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
        } else if (side == 0) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            t.func_78381_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (side == 1) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            t.func_78381_a();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void renderBeam(double length, double yaw, double pitch, int frame) {
        double minU = 0.0;
        double minV = 0.5 + 0.03125 * (double)frame;
        double maxU = minU + 0.078125;
        double maxV = minV + 0.03125;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        t.func_78374_a(-1.0, 0.0, 0.0, minU, minV);
        t.func_78374_a(-1.0, length, 0.0, minU, maxV);
        t.func_78374_a(1.0, length, 0.0, maxU, maxV);
        t.func_78374_a(1.0, 0.0, 0.0, maxU, minV);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)yaw), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.clearerView) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        t.func_78381_a();
        if (this.clearerView) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!this.clearerView) {
            t.func_78382_b();
            t.func_78380_c(240);
            t.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
            t.func_78374_a(-1.0, 0.0, 0.0, minU, minV);
            t.func_78374_a(-1.0, length, 0.0, minU, maxV);
            t.func_78374_a(1.0, length, 0.0, maxU, maxV);
            t.func_78374_a(1.0, 0.0, 0.0, maxU, minV);
            GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            t.func_78381_a();
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)((float)(-pitch)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)(-yaw)), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void setupGL() {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    private void revertGL() {
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }
}

