/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.EntityDart;
import com.bobmowzie.mowziesmobs.server.entity.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntityEggInfo;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityBabyFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeElite;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeHunter;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeLeader;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeVillager;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public enum EntityHandler {
    INSTANCE;

    private final Map<Integer, MowzieEntityEggInfo> ENTITY_EGGS = new LinkedHashMap<Integer, MowzieEntityEggInfo>();
    private int nextEntityId;

    public void onInit() {
        this.registerEntity(EntityFoliaath.class, "Foliaath", true, 4705339, 12598220, false, 20, 3, 1, EnumCreatureType.monster, BiomeGenBase.field_76792_x, BiomeGenBase.field_76782_w, BiomeGenBase.field_150574_L);
        this.registerEntity(EntityBabyFoliaath.class, "BabyFoliaath", false, 4705339, 12598220, false, 1, 1, 1, EnumCreatureType.monster, new BiomeGenBase[0]);
        this.registerEntity(EntityWroughtnaut.class, "FerrousWroughtnaut", true, 0x8C8C8C, 0xFFFFFF, false, 1, 1, 1, EnumCreatureType.monster, new BiomeGenBase[0]);
        this.registerEntity(EntityTribeHunter.class, "TribesmanHunter", false, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.monster, new BiomeGenBase[0]);
        this.registerEntity(EntityTribeElite.class, "TribesmanElite", true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.monster, new BiomeGenBase[0]);
        this.registerEntity(EntityTribeVillager.class, "TribesmanVillager", true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.creature, new BiomeGenBase[0]);
        this.registerEntity(EntityTribeLeader.class, "TribeLeader", true, 12215894, 16448120, false, 1, 1, 1, EnumCreatureType.monster, new BiomeGenBase[0]);
        EntityRegistry.registerModEntity(EntitySunstrike.class, (String)"Sunstrike", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntitySolarBeam.class, (String)"SolarBeam", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityDart.class, (String)"dart", (int)this.nextEntityId(), (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
    }

    public void registerEntity(Class<? extends EntityLiving> entityClass, String name, boolean addEgg, int mainColor, int subColor, boolean addSpawn, int spawnFrequency, int minGroup, int maxGroup, EnumCreatureType typeOfCreature, BiomeGenBase ... biomes) {
        int entityId = this.nextEntityId();
        EntityRegistry.registerModEntity(entityClass, (String)name, (int)entityId, (Object)MowziesMobs.INSTANCE, (int)64, (int)1, (boolean)true);
        if (addEgg) {
            this.ENTITY_EGGS.put(entityId, new MowzieEntityEggInfo(entityId, mainColor, subColor));
        }
        if (addSpawn) {
            EntityRegistry.addSpawn(entityClass, (int)spawnFrequency, (int)minGroup, (int)maxGroup, (EnumCreatureType)typeOfCreature, (BiomeGenBase[])biomes);
        }
    }

    private int nextEntityId() {
        return this.nextEntityId++;
    }

    public MowzieEntityEggInfo getEntityEggInfo(int id) {
        return this.ENTITY_EGGS.get(id);
    }

    public boolean hasEntityEggInfo(int id) {
        return this.ENTITY_EGGS.containsKey(id);
    }

    public Iterator<MowzieEntityEggInfo> getEntityEggInfoIterator() {
        return this.ENTITY_EGGS.values().iterator();
    }

    public Entity createEntityById(int id, World world) {
        Entity entity = null;
        try {
            EntityRegistry.EntityRegistration reg = EntityRegistry.instance().lookupModSpawn(MowziesMobs.getModContainer(), id);
            Class clazz = reg.getEntityClass();
            if (clazz != null) {
                entity = (Entity)clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public String getEntityNameById(int id) {
        String name = "missingno";
        try {
            name = EntityRegistry.instance().lookupModSpawn(MowziesMobs.getModContainer(), id).getEntityName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }
}

