/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.tribe;

import com.bobmowzie.mowziesmobs.server.ai.BarakoaAttackTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationBlockAI;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeHunter;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribesman;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.ArrayUtils;

public class EntityTribeElite
extends EntityTribesman {
    public static final Animation BLOCK_ANIMATION = Animation.create((int)10);
    private List<EntityTribeHunter> pack = new ArrayList<EntityTribeHunter>();
    private int packRadius = 3;

    public EntityTribeElite(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCow.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySheep.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new BarakoaAttackTargetAI(this, EntityPlayer.class, 0, true));
        this.field_70714_bg.func_75776_a(2, new AnimationBlockAI<EntityTribeElite>(this, BLOCK_ANIMATION));
        this.setMask(1);
        this.func_70105_a(0.7f, 2.0f);
        this.field_70728_aV = 12;
    }

    @Override
    public int getAttack() {
        return 6;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.pack.size(); ++i) {
            this.pack.get((int)i).index = i;
        }
        if (!this.field_70170_p.field_72995_K && this.pack != null) {
            float theta = (float)Math.PI * 2 / (float)this.pack.size();
            for (int i = 0; i < this.pack.size(); ++i) {
                EntityTribeHunter hunter = this.pack.get(i);
                if (hunter.func_70638_az() != null) continue;
                hunter.func_70661_as().func_75492_a(this.field_70165_t + (double)((float)this.packRadius * MathHelper.func_76134_b((float)(theta * (float)i))), this.field_70163_u, this.field_70161_v + (double)((float)this.packRadius * MathHelper.func_76126_a((float)(theta * (float)i))), 0.45);
                if (!(this.func_70032_d((Entity)hunter) > 20.0f)) continue;
                hunter.func_70107_b(this.field_70165_t + (double)((float)this.packRadius * MathHelper.func_76134_b((float)(theta * (float)i))), this.field_70163_u, this.field_70161_v + (double)((float)this.packRadius * MathHelper.func_76126_a((float)(theta * (float)i))));
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76346_g();
        if (!(entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d)) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        if (entity != null && entity instanceof EntityLivingBase && (this.getAnimation() == IAnimatedEntity.NO_ANIMATION || this.getAnimation() == HURT_ANIMATION || this.getAnimation() == BLOCK_ANIMATION)) {
            this.blockingEntity = (EntityLivingBase)entity;
            this.func_85030_a("mob.zombie.wood", 0.3f, 1.5f);
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_ANIMATION);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void removePackMember(EntityTribeHunter tribeHunter) {
        this.pack.remove(tribeHunter);
        this.sortPackMembers();
    }

    public void addPackMember(EntityTribeHunter tribeHunter) {
        this.pack.add(tribeHunter);
        this.sortPackMembers();
    }

    private void sortPackMembers() {
        double theta = Math.PI * 2 / (double)this.pack.size();
        for (int i = 0; i < this.pack.size(); ++i) {
            int nearestIndex = -1;
            double smallestDiffSq = Double.MAX_VALUE;
            double targetTheta = theta * (double)i;
            double x = this.field_70165_t + (double)this.packRadius * Math.cos(targetTheta);
            double z = this.field_70161_v + (double)this.packRadius * Math.sin(targetTheta);
            for (int n = 0; n < this.pack.size(); ++n) {
                EntityTribeHunter tribeHunter = this.pack.get(n);
                double diffSq = (x - tribeHunter.field_70165_t) * (x - tribeHunter.field_70165_t) + (z - tribeHunter.field_70161_v) * (z - tribeHunter.field_70161_v);
                if (!(diffSq < smallestDiffSq)) continue;
                smallestDiffSq = diffSq;
                nearestIndex = n;
            }
            if (nearestIndex == -1) {
                throw new ArithmeticException("All pack members have NaN x and z?");
            }
            this.pack.add(i, this.pack.remove(nearestIndex));
        }
    }

    public int getPackSize() {
        return this.pack.size();
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        int size = this.field_70146_Z.nextInt(2) + 3;
        for (int i = 0; i <= size; ++i) {
            EntityTribeHunter tribeHunter = new EntityTribeHunter(this.field_70170_p, this);
            this.pack.add(tribeHunter);
            tribeHunter.setLeaderUUID(this.func_110124_au().toString());
            tribeHunter.func_70107_b(this.field_70165_t + 0.1 * (double)i, this.field_70163_u, this.field_70161_v);
            int weapon = 0;
            if (this.field_70146_Z.nextInt(3) == 0) {
                weapon = 1;
            }
            tribeHunter.setWeapon(weapon);
            this.field_70170_p.func_72838_d((Entity)tribeHunter);
        }
        return super.func_110161_a(data);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.pack.forEach(EntityTribeHunter::removeLeader);
    }

    public boolean func_70601_bi() {
        List<EntityLivingBase> nearby = this.getEntityLivingBaseNearby(10.0, 4.0, 10.0, 10.0);
        for (EntityLivingBase nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityTribeElite)) continue;
            return false;
        }
        if (this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            if (y < 63) {
                return false;
            }
            Block block = this.field_70170_p.func_147439_a(x, y - 1, z);
            if (block == Blocks.field_150349_c) {
                return true;
            }
        }
        return false;
    }

    protected void func_70623_bb() {
        Event.Result result;
        if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.pack.forEach(Entity::func_70106_y);
                this.func_70106_y();
            }
        } else {
            EntityPlayer closestPlayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (closestPlayer != null) {
                double distX = closestPlayer.field_70165_t - this.field_70165_t;
                double distY = closestPlayer.field_70163_u - this.field_70163_u;
                double distZ = closestPlayer.field_70161_v - this.field_70161_v;
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (this.func_70692_ba() && distance > 16384.0) {
                    this.pack.forEach(Entity::func_70106_y);
                    this.func_70106_y();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && distance > 1024.0 && this.func_70692_ba()) {
                    this.pack.forEach(Entity::func_70106_y);
                    this.func_70106_y();
                } else if (distance < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Override
    public Animation[] getAnimations() {
        return (Animation[])ArrayUtils.add((Object[])super.getAnimations(), (Object)BLOCK_ANIMATION);
    }
}

