/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.tribe;

import com.bobmowzie.mowziesmobs.server.ai.BarakoaAttackTargetAI;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeElite;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribesman;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityTribeHunter
extends EntityTribesman {
    private static final String ABSENT_LEADER = "";
    private static final int LEADER_UUID_ID = 31;
    public int index;
    private EntityTribeElite leader;

    public EntityTribeHunter(World world) {
        super(world);
        this.leader = null;
    }

    public EntityTribeHunter(World world, EntityTribeElite leader) {
        super(world);
        this.leader = leader;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(31, (Object)ABSENT_LEADER);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.leader == null && !Objects.equals(this.getLeaderUUID(), ABSENT_LEADER)) {
            this.leader = this.getLeader();
            if (this.leader != null) {
                this.leader.addPackMember(this);
            }
        }
        if (this.leader != null) {
            this.func_70624_b(this.leader.func_70638_az());
        }
    }

    @Override
    protected void updateCircling() {
        if (this.leader != null) {
            if (!this.attacking && this.targetDistance < 5.0f) {
                this.circleEntity((Entity)this.func_70638_az(), 7.0f, 0.3f, true, this.leader.circleTick, (float)((double)(this.index + 1) * (Math.PI * 2) / (double)(this.leader.getPackSize() + 1)), 1.75f);
            } else {
                this.circleEntity((Entity)this.func_70638_az(), 7.0f, 0.3f, true, this.leader.circleTick, (float)((double)(this.index + 1) * (Math.PI * 2) / (double)(this.leader.getPackSize() + 1)), 1.0f);
            }
        } else {
            super.updateCircling();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76346_g();
        if (!(entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d)) {
            if (this.leader != null) {
                this.leader.func_70624_b((EntityLivingBase)entity);
            } else {
                this.func_70624_b((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, damage);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (this.leader != null) {
            this.leader.removePackMember(this);
        }
    }

    public String getLeaderUUID() {
        return this.field_70180_af.func_75681_e(31);
    }

    public void setLeaderUUID(String uuid) {
        this.field_70180_af.func_75692_b(31, (Object)uuid);
    }

    public EntityTribeElite getLeader() {
        try {
            UUID uuid = UUID.fromString(this.getLeaderUUID());
            List potentialLeaders = this.field_70170_p.func_72872_a(EntityTribeElite.class, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
            for (EntityTribeElite elite : potentialLeaders) {
                if (!uuid.equals(elite.func_110124_au())) continue;
                return elite;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void removeLeader() {
        this.setLeaderUUID(ABSENT_LEADER);
        this.leader = null;
        this.func_70624_b(null);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new BarakoaAttackTargetAI(this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCow.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySheep.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, true));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("mask", this.getMask());
        compound.func_74778_a("leaderUUID", this.getLeaderUUID());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMask(compound.func_74762_e("mask"));
        this.setLeaderUUID(compound.func_74779_i("leaderUUID"));
    }

    protected boolean func_70692_ba() {
        return this.leader == null;
    }
}

