/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.world.MowzieStructureGenerator;
import com.bobmowzie.mowziesmobs.server.world.structure.barakoa.StructureBarakoThrone;
import com.bobmowzie.mowziesmobs.server.world.structure.barakoa.StructureBarakoaHouse;
import coolalias.structuregenapi.util.Structure;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MowzieWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int x, int z) {
        if (world.func_72912_H().func_76089_r()) {
            this.tryWroughtChamber(world, random, x, z, MowziesMobs.CONFIG.spawnrateWroughtnaut);
        }
    }

    private void tryWroughtChamber(World world, Random random, int x, int z, int chance) {
        if (chance <= 0) {
            return;
        }
        int xzCheckDistance = 10;
        if (random.nextInt(chance) == 0) {
            block0: for (int y = 50; y >= 30; --y) {
                if (!world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z)) continue;
                for (int y2 = 1; y2 <= 30; ++y2) {
                    int y3;
                    Boolean wall;
                    if (!world.func_147439_a(x, y - y2, z).func_149662_c()) continue;
                    int y4 = 0;
                    int y5 = 0;
                    for (int x2 = 0; x2 <= xzCheckDistance; ++x2) {
                        if (world.func_147439_a(x - x2, y - y2 + y4 + 1, z).func_149662_c()) {
                            wall = true;
                            for (y3 = 1; y3 <= 4; ++y3) {
                                if (world.func_147439_a(x - x2, y - y2 + y4 + 1 + y3, z).func_149662_c()) continue;
                                wall = false;
                                y4 += y3;
                                break;
                            }
                            if (wall.booleanValue()) {
                                if (world.func_147439_a(x - x2 - 9, y - y2 + y4, z - 9) instanceof BlockStone) {
                                    this.generateWroughtChamber(world, random, x - x2 - 9, y - y2 + y4, z - 9, 0);
                                }
                                return;
                            }
                        }
                        if (!world.func_147439_a(x + x2, y - y2 + y5 + 1, z).func_149662_c()) continue;
                        wall = true;
                        for (y3 = 1; y3 <= 4; ++y3) {
                            if (world.func_147439_a(x + x2, y - y2 + y5 + 1 + y3, z).func_149662_c()) continue;
                            wall = false;
                            y5 += y3;
                            break;
                        }
                        if (!wall.booleanValue()) continue;
                        if (world.func_147439_a(x + x2 + 9, y - y2 + y5, z - 9) instanceof BlockStone) {
                            this.generateWroughtChamber(world, random, x + x2 + 9, y - y2 + y5, z - 9, 2);
                        }
                        return;
                    }
                    y4 = 0;
                    y5 = 0;
                    for (int z2 = 0; z2 <= xzCheckDistance; ++z2) {
                        if (world.func_147439_a(x - 1, y - y2 + y4 + 1, z - z2).func_149662_c()) {
                            wall = true;
                            for (y3 = 1; y3 <= 4; ++y3) {
                                if (world.func_147439_a(x - 1, y - y2 + y4 + 1 + y3, z - z2).func_149662_c()) continue;
                                wall = false;
                                y4 += y3;
                                break;
                            }
                            if (wall.booleanValue()) {
                                if (world.func_147439_a(x - 1, y - y2 + y4, z - z2 - 18) instanceof BlockStone) {
                                    this.generateWroughtChamber(world, random, x - 1, y - y2 + y4, z - z2 - 18, 1);
                                }
                                return;
                            }
                        }
                        if (!world.func_147439_a(x - 1, y - y2 + y5 + 1, z + z2).func_149662_c()) continue;
                        wall = true;
                        for (y3 = 1; y3 <= 4; ++y3) {
                            if (world.func_147439_a(x - 1, y - y2 + y5 + 1 + y3, z + z2).func_149662_c()) continue;
                            wall = false;
                            y5 += y3;
                            break;
                        }
                        if (!wall.booleanValue()) continue;
                        if (world.func_147439_a(x - 1, y - y2 + y5, z + z2) instanceof BlockStone) {
                            this.generateWroughtChamber(world, random, x - 1, y - y2 + y5, z + z2, 3);
                        }
                        return;
                    }
                    continue block0;
                }
            }
        }
    }

    private void generateWroughtChamber(World world, Random random, int x, int y, int z, int direction) {
        Structure structure = MowzieStructureGenerator.structures.get(0);
        EntityWroughtnaut wroughtnaut = new EntityWroughtnaut(world);
        wroughtnaut.func_70080_a((double)x + 0.5, y + 1, (double)z + 9.5, 0.0f, 0.0f);
        MowziesMobs.GENERATOR.setStructure(structure);
        MowziesMobs.GENERATOR.setStructureFacing(direction);
        MowziesMobs.GENERATOR.setDefaultOffset(structure.getOffsetX(), structure.getOffsetY(), structure.getOffsetZ());
        MowziesMobs.GENERATOR.func_76484_a(world, random, x, y - 1, z);
        world.func_72838_d((Entity)wroughtnaut);
    }

    private void generateBarakoaVillage(World world, Random random, int x, int y, int z) {
        StructureBarakoaHouse.generateFirepit(world, x, y, z);
        int currentX = x;
        int currentZ = z;
        int throneDirection = random.nextInt(3);
        if (throneDirection == 0) {
            currentX += 10;
        } else if (throneDirection == 1) {
            currentZ += 10;
        } else if (throneDirection == 2) {
            currentX -= 10;
        } else if (throneDirection == 3) {
            currentZ -= 10;
        }
        StructureBarakoThrone.generate(world, currentX, y, currentZ, throneDirection);
    }

    private void generateEnd(World world, Random random, int i, int i1) {
    }

    private void generateNether(World world, Random random, int i, int i1) {
    }
}

