/*
 * Decompiled with CFR 0.152.
 */
package coolalias.structuregenapi.util;

import coolalias.structuregenapi.util.BlockRotationData;
import coolalias.structuregenapi.util.LogHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class GenHelper {
    public static final boolean addItemToTileInventory(World world, ItemStack itemstack, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof IInventory)) {
            LogHelper.warning("Tile Entity at " + x + "/" + y + "/" + z + " is " + (tile != null ? "not an IInventory" : "null"));
            return false;
        }
        if (itemstack.field_77994_a < 1) {
            LogHelper.warning("Trying to add ItemStack of size 0 to Tile Inventory");
            return false;
        }
        IInventory inventory = (IInventory)tile;
        int remaining = itemstack.field_77994_a;
        for (int i = 0; i < inventory.func_70302_i_() && remaining > 0; ++i) {
            ItemStack slotstack = inventory.func_70301_a(i);
            if (slotstack == null && inventory.func_94041_b(i, itemstack)) {
                itemstack.field_77994_a = (remaining -= inventory.func_70297_j_()) > 0 ? inventory.func_70297_j_() : itemstack.field_77994_a;
                inventory.func_70299_a(i, itemstack);
                inventory.func_70296_d();
                continue;
            }
            if (slotstack == null || !itemstack.func_77985_e() || !inventory.func_94041_b(i, itemstack) || slotstack.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77981_g() && itemstack.func_77960_j() != slotstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)slotstack)) continue;
            int l = slotstack.field_77994_a + remaining;
            if (l <= itemstack.func_77976_d() && l <= inventory.func_70297_j_()) {
                remaining = 0;
                slotstack.field_77994_a = l;
                inventory.func_70296_d();
                continue;
            }
            if (slotstack.field_77994_a >= itemstack.func_77976_d() || itemstack.func_77976_d() > inventory.func_70297_j_()) continue;
            remaining -= itemstack.func_77976_d() - slotstack.field_77994_a;
            slotstack.field_77994_a = itemstack.func_77976_d();
            inventory.func_70296_d();
        }
        return remaining < 1;
    }

    public static final boolean setEntityInStructure(World world, Entity entity, int x, int y, int z) {
        if (entity == null) {
            return false;
        }
        int iMax = entity.field_70130_N > 1.0f ? 16 : 4;
        boolean factor = true;
        world.func_147468_f(x, y, z);
        entity.func_70012_b((double)x, (double)y, (double)z, 0.0f, 0.0f);
        block6: for (int i = 0; entity.func_70094_T() && i < iMax; ++i) {
            if (i == 4 && entity.func_70094_T() && entity.field_70130_N > 1.0f) {
                entity.func_70012_b((double)x, (double)y, (double)z, 90.0f, 0.0f);
                LogHelper.finest("Large entity; rotating 90 degrees");
            } else if (i == 8 && entity.func_70094_T() && entity.field_70130_N > 1.0f) {
                entity.func_70012_b((double)x, (double)y, (double)z, 180.0f, 0.0f);
                LogHelper.finest("Large entity; rotating 180 degrees");
            } else if (i == 12 && entity.func_70094_T() && entity.field_70130_N > 1.0f) {
                entity.func_70012_b((double)x, (double)y, (double)z, 270.0f, 0.0f);
                LogHelper.finest("Large entity; rotating 270 degrees");
            }
            LogHelper.finer("Entity inside opaque block at " + entity.field_70165_t + "/" + entity.field_70163_u + "/" + entity.field_70161_v);
            switch (i % 4) {
                case 0: {
                    entity.func_70107_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5);
                    continue block6;
                }
                case 1: {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v - 1.0);
                    continue block6;
                }
                case 2: {
                    entity.func_70107_b(entity.field_70165_t - 1.0, entity.field_70163_u, entity.field_70161_v);
                    continue block6;
                }
                case 3: {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v + 1.0);
                }
            }
        }
        if (entity.func_70094_T()) {
            LogHelper.warning("Failed to set entity in open space. Returning to default position.");
            entity.func_70107_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5);
            return false;
        }
        return true;
    }

    public static final boolean spawnEntityInStructure(World world, Entity entity, int x, int y, int z) {
        if (world.field_72995_K || entity == null) {
            return false;
        }
        boolean collided = GenHelper.setEntityInStructure(world, entity, x, y, z);
        world.func_72838_d(entity);
        LogHelper.finest("Spawned entity at " + entity.field_70165_t + "/" + entity.field_70163_u + "/" + entity.field_70161_v);
        return collided;
    }

    public static final AxisAlignedBB getHangingEntityAxisAligned(int x, int y, int z, int direction) {
        double minX = x;
        double minZ = z;
        double maxX = minX;
        double maxZ = minZ;
        switch (direction) {
            case 2: {
                minX += 0.25;
                maxX += 0.75;
                minZ += 0.5;
                maxZ += 1.5;
                break;
            }
            case 3: {
                minX += 0.25;
                maxX += 0.75;
                minZ -= 0.5;
                maxZ += 0.5;
                break;
            }
            case 4: {
                minX += 0.5;
                maxX += 1.5;
                minZ += 0.25;
                maxZ += 0.75;
                break;
            }
            case 5: {
                minX -= 0.5;
                maxX += 0.5;
                minZ += 0.25;
                maxZ += 0.75;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)y, (double)minZ, (double)maxX, (double)((double)y + 1.0), (double)maxZ);
    }

    public static final int setHangingEntity(World world, ItemStack hanging, int x, int y, int z) {
        if (hanging.func_77973_b() == null || !(hanging.func_77973_b() instanceof ItemHangingEntity)) {
            return -1;
        }
        if (world.func_72805_g(x, y, z) < 1 || world.func_72805_g(x, y, z) > 5) {
            LogHelper.warning("Hanging entity has invalid metadata of " + world.func_72805_g(x, y, z) + ". Valid values are 1,2,3,4");
            return -1;
        }
        int[] metaToFacing = new int[]{5, 4, 3, 2};
        int direction = metaToFacing[world.func_72805_g(x, y, z) - 1];
        world.func_147468_f(x, y, z);
        switch (direction) {
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        return direction;
    }

    public static final void setItemFrameStack(World world, ItemStack itemstack, int x, int y, int z, int direction) {
        GenHelper.setItemFrameStack(world, itemstack, x, y, z, direction, 0);
    }

    public static final void setItemFrameStack(World world, ItemStack itemstack, int x, int y, int z, int direction, int itemRotation) {
        List frames = world.func_72872_a(EntityItemFrame.class, GenHelper.getHangingEntityAxisAligned(x, y, z, direction));
        if (frames != null && !frames.isEmpty()) {
            for (EntityItemFrame frame : frames) {
                frame.func_82334_a(itemstack);
                frame.func_82336_g(itemRotation);
            }
        }
    }

    public static final boolean setPaintingArt(World world, String name, int x, int y, int z, int direction) {
        List paintings = world.func_72872_a(EntityPainting.class, GenHelper.getHangingEntityAxisAligned(x, y, z, direction));
        if (paintings != null && !paintings.isEmpty() && name.length() > 0) {
            for (EntityPainting toEdit : paintings) {
                EntityPainting.EnumArt[] aenumart = EntityPainting.EnumArt.values();
                int i1 = aenumart.length;
                for (EntityPainting.EnumArt enumart : aenumart) {
                    if (!enumart.field_75702_A.equals(name)) continue;
                    toEdit.field_70522_e = enumart;
                    return true;
                }
                LogHelper.warning(name + " does not match any values in EnumArt; unable to set painting art.");
            }
        }
        LogHelper.warning("No EntityPainting was found at " + x + "/" + y + "/" + z);
        return false;
    }

    public static final boolean setSignText(World world, String[] text, int x, int y, int z) {
        TileEntitySign sign;
        TileEntitySign tileEntitySign = sign = world.func_147438_o(x, y, z) instanceof TileEntitySign ? (TileEntitySign)world.func_147438_o(x, y, z) : null;
        if (sign != null) {
            for (int i = 0; i < sign.field_145915_a.length && i < text.length; ++i) {
                if (text[i] == null) {
                    LogHelper.warning("Uninitialized String element while setting sign text at index " + i);
                    continue;
                }
                if (text[i].length() > 15) {
                    LogHelper.warning(text[i] + " is too long to fit on a sign; maximum length is 15 characters.");
                    sign.field_145915_a[i] = text[i].substring(0, 15);
                    continue;
                }
                sign.field_145915_a[i] = text[i];
            }
            return true;
        }
        LogHelper.warning("No TileEntitySign was found at " + x + "/" + y + "/" + z);
        return false;
    }

    public static final boolean setSkullData(World world, String name, int type, int x, int y, int z) {
        return GenHelper.setSkullData(world, name, type, -1, x, y, z);
    }

    public static final boolean setSkullData(World world, String name, int type, int rot, int x, int y, int z) {
        TileEntitySkull skull;
        TileEntitySkull tileEntitySkull = skull = world.func_147438_o(x, y, z) instanceof TileEntitySkull ? (TileEntitySkull)world.func_147438_o(x, y, z) : null;
        if (skull != null) {
            if (type > 4 || type < 0) {
                LogHelper.warning("Custom data value " + type + " not valid for skulls. Valid values are 0 to 4.");
                type = 0;
            }
            skull.func_152107_a(type);
            if (rot > -1) {
                skull.func_145903_a(rot % 16);
            }
            return true;
        }
        LogHelper.warning("No TileEntitySkull found at " + x + "/" + y + "/" + z);
        return false;
    }

    public static final int getMetadata(int rotations, Block block, int origMeta) {
        if (BlockRotationData.getBlockRotationType(block) == null) {
            return origMeta;
        }
        int meta = origMeta;
        int tickDelay = meta >> 2;
        int bit4 = meta & 4;
        int bit8 = meta & 8;
        int bit9 = meta >> 3;
        int extra = meta & 0xFFFFFFFC;
        block17: for (int i = 0; i < rotations; ++i) {
            int bitface = meta % 4;
            switch (BlockRotationData.getBlockRotationType(block)) {
                case ANVIL: {
                    meta ^= 1;
                    continue block17;
                }
                case DOOR: {
                    if (bit8 != 0) {
                        return meta;
                    }
                    meta = bitface == 3 ? 0 : bitface + 1;
                    meta |= extra;
                    continue block17;
                }
                case GENERIC: {
                    meta = (bitface == 3 ? 0 : bitface + 1) | bit4 | bit8;
                    continue block17;
                }
                case PISTON_CONTAINER: {
                    if ((meta -= meta > 7 ? 8 : 0) > 1) {
                        meta = meta == 2 ? 5 : (meta == 5 ? 3 : (meta == 3 ? 4 : 2));
                    }
                    meta |= bit8 | bit9 << 3;
                    continue block17;
                }
                case QUARTZ: {
                    meta = meta == 3 ? 4 : (meta == 4 ? 3 : meta);
                    continue block17;
                }
                case RAIL: {
                    if (meta < 2) {
                        meta ^= 1;
                        continue block17;
                    }
                    if (meta < 6) {
                        meta = meta == 2 ? 5 : (meta == 5 ? 3 : (meta == 3 ? 4 : 2));
                        continue block17;
                    }
                    meta = meta == 9 ? 6 : meta + 1;
                    continue block17;
                }
                case REPEATER: {
                    meta = (bitface == 3 ? 0 : bitface + 1) | tickDelay << 2;
                    continue block17;
                }
                case SIGNPOST: {
                    meta = meta < 12 ? meta + 4 : meta - 12;
                    continue block17;
                }
                case SKULL: {
                    meta = meta == 1 ? 1 : (meta == 4 ? 2 : (meta == 2 ? 5 : (meta == 5 ? 3 : 4)));
                    continue block17;
                }
                case STAIRS: {
                    meta = (bitface == 0 ? 2 : (bitface == 2 ? 1 : (bitface == 1 ? 3 : 0))) | bit4;
                    continue block17;
                }
                case TRAPDOOR: {
                    meta = (bitface == 0 ? 3 : (bitface == 3 ? 1 : (bitface == 1 ? 2 : 0))) | bit4 | bit8;
                    continue block17;
                }
                case VINE: {
                    meta = meta == 1 ? 2 : (meta == 2 ? 4 : (meta == 4 ? 8 : 1));
                    continue block17;
                }
                case WALL_MOUNTED: {
                    if (meta <= 0 || meta >= 5) continue block17;
                    meta = meta == 4 ? 1 : (meta == 1 ? 3 : (meta == 3 ? 2 : 4));
                    continue block17;
                }
                case LEVER: {
                    meta = (meta -= meta > 7 ? 8 : 0) > 0 && meta < 5 ? (meta == 4 ? 1 : (meta == 1 ? 3 : (meta == 3 ? 2 : 4))) : (meta == 5 || meta == 6 ? (meta == 5 ? 6 : 5) : (meta == 7 ? 0 : 7));
                    meta |= bit8;
                    continue block17;
                }
                case WOOD: {
                    if (meta <= 4 || meta >= 12) continue block17;
                    meta = meta < 8 ? meta + 4 : meta - 4;
                    continue block17;
                }
            }
        }
        return meta;
    }

    public static final void setMetadata(World world, int x, int y, int z, int origMeta) {
        Block block = world.func_147439_a(x, y, z);
        if (BlockRotationData.getBlockRotationType(block) == null) {
            return;
        }
        switch (BlockRotationData.getBlockRotationType(block)) {
            case PISTON_CONTAINER: {
                world.func_72921_c(x, y, z, origMeta, 2);
                break;
            }
            case RAIL: {
                world.func_72921_c(x, y, z, origMeta, 2);
                break;
            }
        }
    }

    public static final boolean materialsMatch(Block block1, Block block2) {
        return block1.func_149688_o() == Material.field_151577_b && block2.func_149688_o() == Material.field_151578_c || block1.func_149688_o().func_76224_d() && block2.func_149688_o() == block1.func_149688_o() || block1.func_149688_o() == Material.field_151588_w && block2.func_149688_o() == Material.field_151586_h || block1.func_149688_o() == Material.field_76233_E && block2.func_149688_o() == Material.field_76233_E || block1 instanceof BlockRedstoneTorch && block2 instanceof BlockRedstoneTorch || block1 instanceof BlockRedstoneRepeater && block2 instanceof BlockRedstoneRepeater;
    }
}

