/*
 * Decompiled with CFR 0.152.
 */
package coolalias.structuregenapi.util;

import coolalias.structuregenapi.util.BlockData;
import coolalias.structuregenapi.util.BlockRotationData;
import coolalias.structuregenapi.util.GenHelper;
import coolalias.structuregenapi.util.LogHelper;
import coolalias.structuregenapi.util.Structure;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class StructureGeneratorBase
extends WorldGenerator {
    public static final int SET_NO_BLOCK = Integer.MAX_VALUE;
    public static final int SOUTH = 0;
    public static final int WEST = 1;
    public static final int NORTH = 2;
    public static final int EAST = 3;
    private int structureFacing = 3;
    private int manualRotations = 0;
    private int facing;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private boolean removeStructure = false;
    private int[][][][] blockArray;
    private final List<int[][][][]> blockArrayList = new LinkedList<int[][][][]>();
    private final List<BlockData> postGenBlocks = new LinkedList<BlockData>();

    public StructureGeneratorBase() {
        super(true);
    }

    public StructureGeneratorBase(Entity entity, int[][][][] blocks) {
        this(entity, blocks, 3, 0, 0, 0);
    }

    public StructureGeneratorBase(Entity entity, int[][][][] blocks, int structureFacing) {
        this(entity, blocks, structureFacing, 0, 0, 0);
    }

    public StructureGeneratorBase(Entity entity, int[][][][] blocks, int structureFacing, int offX, int offY, int offZ) {
        super(true);
        this.setPlayerFacing(entity);
        this.setBlockArray(blocks);
        this.setStructureFacing(structureFacing);
        this.setOffset(offX, offY, offZ);
    }

    public abstract int getRealBlockID(int var1, int var2);

    public abstract void onCustomBlockAdded(World var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public final int getPlayerFacing() {
        return this.facing;
    }

    public final void setPlayerFacing(Entity entity) {
        if (entity == null) {
            LogHelper.warning("Null Pointer Exception! Cannot set facing from a null entity.");
        } else {
            this.facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        }
    }

    public final void setStructureFacing(int facing) {
        this.structureFacing = facing % 4;
    }

    public final void rotateStructureFacing() {
        ++this.structureFacing;
        this.structureFacing %= 4;
        ++this.manualRotations;
        this.manualRotations %= 4;
    }

    public final void rotateStructureFacing(int rotations) {
        this.structureFacing = (this.structureFacing + rotations) % 4;
        this.manualRotations = (this.manualRotations + rotations) % 4;
    }

    public final String currentStructureFacing() {
        return this.structureFacing == 3 ? "East" : (this.structureFacing == 1 ? "West" : (this.structureFacing == 2 ? "North" : "South"));
    }

    public final void addBlockArray(int[][][][] blocks) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.blockArrayList.add(blocks);
            if (this.blockArray == null) {
                this.blockArray = blocks;
            }
        }
    }

    public final void setBlockArray(int[][][][] blocks) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.blockArrayList.clear();
            this.blockArrayList.add(blocks);
            this.blockArray = blocks;
        }
    }

    public final void addBlockArrayList(List<int[][][][]> list) {
        this.blockArrayList.addAll(list);
        if (this.blockArray == null && list.size() > 0) {
            this.blockArray = list.get(0);
        }
    }

    public final void setBlockArrayList(List<int[][][][]> list) {
        this.blockArrayList.clear();
        this.blockArrayList.addAll(list);
        this.blockArray = list.size() > 0 ? list.get(0) : (int[][][][])null;
    }

    public final void setStructure(Structure structure) {
        if (structure != null) {
            this.reset();
            this.setBlockArrayList(structure.blockArrayList());
            this.setStructureFacing(structure.getFacing());
        } else {
            LogHelper.severe("NULL Structure cannot be set!");
        }
    }

    public final void setStructureWithRotation(Structure structure, int rotations) {
        this.setStructure(structure);
        this.manualRotations = 0;
        for (int i = 0; i < rotations % 4; ++i) {
            this.rotateStructureFacing();
        }
    }

    public final int getWidthX() {
        return this.blockArray != null ? this.blockArray[0].length : 0;
    }

    public final int getWidthZ() {
        return this.blockArray != null ? this.blockArray[0][0].length : 0;
    }

    public final int getHeight() {
        return this.blockArray != null ? this.blockArray.length : 0;
    }

    public final int getOriginalFacing() {
        return (this.structureFacing + (4 - this.manualRotations)) % 4;
    }

    public final boolean isOppositeAxis() {
        return this.getOriginalFacing() % 2 != this.structureFacing % 2;
    }

    public final void setOffset(int offX, int offY, int offZ) {
        this.offsetX = offX;
        this.offsetY = offY;
        this.offsetZ = offZ;
    }

    public final void setDefaultOffset() {
        this.setDefaultOffset(0, 0, 0);
    }

    public final void setDefaultOffset(int x, int y, int z) {
        boolean flag1;
        boolean flagNS = this.getOriginalFacing() % 2 == 0;
        int length = flagNS ? this.getWidthX() : this.getWidthZ();
        int adj1 = length - (flagNS ? this.getWidthZ() : this.getWidthX());
        boolean bl = flagNS ? this.getWidthX() % 2 == 0 && adj1 % 2 == 1 || this.getWidthX() % 2 == 1 && adj1 % 2 == -1 : (flag1 = this.getWidthX() % 2 == 0 && adj1 % 2 == -1 || this.getWidthX() % 2 == 1 && adj1 % 2 == 1);
        if (flag1 && !flagNS) {
            adj1 = -adj1;
        }
        int adj2 = (length + 1) % 2;
        int adj3 = adj1 % 2;
        int adj4 = adj1 / 2 + adj3;
        switch (this.getOriginalFacing()) {
            case 0: {
                this.offsetZ = x + length / 2 - (this.manualRotations == 0 ? adj1 / 2 + (adj3 == 0 ? 0 : (adj1 < 0 && flag1 ? adj3 : adj2)) : (this.manualRotations == 1 ? (adj3 == 0 ? adj2 : (adj1 > 0 && flag1 ? adj3 : 0)) : (this.manualRotations == 2 ? adj1 / 2 + (adj3 == 0 || flag1 ? adj2 : adj3) : 0)));
                this.offsetX = -z + (this.manualRotations == 0 ? adj2 + (adj3 > 0 && !flag1 ? adj4 : 0) : (this.manualRotations == 1 ? (adj3 == 0 ? adj2 : (flag1 ? (adj3 < 0 ? -adj3 : 0) : adj3)) : (this.manualRotations == 2 ? (adj3 > 0 && !flag1 ? adj4 : 0) : 0)));
                break;
            }
            case 1: {
                this.offsetX = x + length / 2 - (this.manualRotations == 0 ? (flag1 ? -adj4 : adj1 / 2) : (this.manualRotations == 2 ? (flag1 ? (adj1 > 0 ? -adj1 / 2 : -adj4) : adj1 / 2 + (adj3 == 0 ? adj2 : 0)) : (this.manualRotations == 3 ? (adj3 == 0 || flag1 ? adj2 : -adj3) : 0)));
                this.offsetZ = z + (this.manualRotations == 1 ? (adj3 < 0 && !flag1 ? adj4 : (adj3 > 0 && flag1 ? (adj1 > 1 ? -adj1 / 2 : -adj4) : 0)) + (adj3 == 0 ? -adj2 : 0) : (this.manualRotations == 2 ? (adj3 == 0 || flag1 ? -adj2 : adj3) : (this.manualRotations == 3 ? (adj3 < 0 && !flag1 ? adj4 : 0) : 0)));
                break;
            }
            case 2: {
                this.offsetZ = -x - length / 2 + (this.manualRotations == 0 ? adj1 / 2 + (adj3 == 0 || flag1 ? adj2 : adj3) : (this.manualRotations == 2 ? (flag1 ? adj4 : adj1 / 2) : (this.manualRotations == 3 ? (adj3 == 0 || flag1 ? adj2 : 0) : 0)));
                this.offsetX = z - (this.manualRotations == 0 ? (adj3 > 0 ? adj3 - adj2 : 0) : (this.manualRotations == 2 ? (adj3 > 0 ? adj3 : adj2) : (this.manualRotations == 3 ? (adj3 > 0 ? adj3 - adj2 : (adj3 < 0 ? -adj3 : adj2)) : 0)));
                break;
            }
            case 3: {
                this.offsetX = -x - length / 2 + (this.manualRotations == 0 ? adj1 / 2 + (adj3 == 0 ? adj2 : (flag1 ? -adj1 + (adj1 > 0 ? adj3 : 0) : 0)) : (this.manualRotations == 1 ? (adj3 == 0 || flag1 ? adj2 : -adj3) : (this.manualRotations == 2 ? (flag1 ? -adj4 : adj1 / 2) : 0)));
                this.offsetZ = -z - (this.manualRotations == 0 ? (adj3 == 0 || flag1 ? -adj2 : adj3) : (this.manualRotations == 1 ? (adj3 != 0 && !flag1 ? adj4 : 0) : (this.manualRotations == 3 ? (adj3 < 0 && !flag1 ? adj4 : (adj3 > 0 && flag1 ? -adj4 : 0)) + (adj3 == 0 ? -adj2 : (flag1 && adj1 > 1 ? adj3 : 0)) : 0)));
            }
        }
        this.offsetY = 1 + y;
    }

    public final boolean toggleRemoveStructure() {
        this.removeStructure = !this.removeStructure;
        return this.removeStructure;
    }

    public final void setRemoveStructure(boolean value) {
        this.removeStructure = value;
    }

    public final boolean canGenerate() {
        return this.blockArrayList.size() > 0 || this.blockArray != null;
    }

    public final boolean func_76484_a(World world, Random random, int posX, int posY, int posZ) {
        if (world.field_72995_K || !this.canGenerate()) {
            return false;
        }
        boolean generated = true;
        int rotations = ((this.isOppositeAxis() ? this.structureFacing + 2 : this.structureFacing) + this.facing) % 4;
        this.setOffsetFromRotation();
        for (int[][][][] blocks : this.blockArrayList) {
            if (!generated) break;
            this.blockArray = blocks;
            generated = this.generateLayer(world, random, posX, posY, posZ, rotations);
            this.offsetY += blocks.length;
        }
        if (generated) {
            this.doPostGenProcessing(world);
        }
        this.reset();
        return generated;
    }

    private final boolean generateLayer(World world, Random random, int posX, int posY, int posZ, int rotations) {
        int y;
        int centerX = this.blockArray[0].length / 2;
        int centerZ = this.blockArray[0][0].length / 2;
        int n = y = this.removeStructure ? this.blockArray.length - 1 : 0;
        while (this.removeStructure ? y >= 0 : y < this.blockArray.length) {
            for (int x = 0; x < this.blockArray[y].length; ++x) {
                for (int z = 0; z < this.blockArray[y][x].length; ++z) {
                    int realID;
                    if (this.blockArray[y][x][z].length == 0 || this.blockArray[y][x][z][0] == Integer.MAX_VALUE) continue;
                    int rotX = posX;
                    int rotZ = posZ;
                    int rotY = posY + y + this.offsetY;
                    switch (rotations) {
                        case 0: {
                            rotX += x - centerX + this.offsetX;
                            rotZ += z - centerZ + this.offsetZ;
                            break;
                        }
                        case 1: {
                            rotX += -(z - centerZ + this.offsetZ);
                            rotZ += x - centerX + this.offsetX;
                            break;
                        }
                        case 2: {
                            rotX += -(x - centerX + this.offsetX);
                            rotZ += -(z - centerZ + this.offsetZ);
                            break;
                        }
                        case 3: {
                            rotX += z - centerZ + this.offsetZ;
                            rotZ += -(x - centerX + this.offsetX);
                            break;
                        }
                        default: {
                            LogHelper.warning("Error computing number of rotations.");
                        }
                    }
                    int customData1 = this.blockArray[y][x][z].length > 2 ? this.blockArray[y][x][z][2] : 0;
                    int fakeID = this.blockArray[y][x][z][0];
                    int n2 = realID = Math.abs(fakeID) > 4095 ? this.getRealBlockID(fakeID, customData1) : fakeID;
                    if (this.removeStructure) {
                        if (this.removeBlockAt(world, fakeID, realID, rotX, rotY, rotZ, rotations)) continue;
                        return false;
                    }
                    if (Math.abs(realID) > 4095) {
                        LogHelper.warning("Invalid block ID. Initial ID: " + fakeID + ", returned id from getRealID: " + realID);
                        continue;
                    }
                    int customData2 = this.blockArray[y][x][z].length > 3 ? this.blockArray[y][x][z][3] : 0;
                    int meta = this.blockArray[y][x][z].length > 1 ? this.blockArray[y][x][z][1] : 0;
                    this.setBlockAt(world, fakeID, realID, meta, customData1, customData2, rotX, rotY, rotZ);
                }
            }
            y = this.removeStructure ? --y : ++y;
        }
        return true;
    }

    private final void setBlockAt(World world, int fakeID, int realID, int meta, int customData1, int customData2, int x, int y, int z) {
        Block block = Block.func_149729_e((int)realID);
        if (realID >= 0 || world.func_147437_c(x, y, z) || !world.func_147439_a(x, y, z).func_149688_o().func_76230_c()) {
            if (BlockRotationData.getBlockRotationType(block) != null) {
                int rotations = ((this.isOppositeAxis() ? this.structureFacing + 2 : this.structureFacing) + this.facing) % 4;
                meta = GenHelper.getMetadata(rotations, block, meta);
            }
            if (BlockRotationData.getBlockRotationType(block) != null && (BlockRotationData.getBlockRotationType(block) == BlockRotationData.Rotation.WALL_MOUNTED || BlockRotationData.getBlockRotationType(block) == BlockRotationData.Rotation.LEVER)) {
                LogHelper.fine("Block " + block + " requires post-processing. Adding to list. Meta = " + meta);
                this.postGenBlocks.add(new BlockData(x, y, z, fakeID, meta, customData1, customData2));
            } else {
                world.func_147465_d(x, y, z, block, meta, 2);
                if (BlockRotationData.getBlockRotationType(block) != null) {
                    GenHelper.setMetadata(world, x, y, z, meta);
                }
                if (Math.abs(fakeID) > 4095) {
                    this.onCustomBlockAdded(world, x, y, z, fakeID, customData1, customData2);
                }
            }
        }
    }

    private final boolean removeBlockAt(World world, int fakeID, int realID, int x, int y, int z, int rotations) {
        Block realBlock = Block.func_149729_e((int)Math.abs(realID));
        Block worldBlock = world.func_147439_a(x, y, z);
        if (realBlock == null || worldBlock == null || realID < 0 && worldBlock != realBlock) {
            return true;
        }
        if (realBlock == worldBlock || GenHelper.materialsMatch(realBlock, worldBlock)) {
            world.func_147468_f(x, y, z);
            List list = world.func_72872_a(Entity.class, GenHelper.getHangingEntityAxisAligned(x, y, z, Direction.field_71582_c[rotations]).func_72314_b(1.0, 1.0, 1.0));
            for (Entity entity : list) {
                if (entity instanceof EntityPlayer) continue;
                entity.func_70106_y();
            }
        } else {
            LogHelper.info("Incorrect location for structure removal, aborting. Last block id checked: world " + worldBlock + ", real " + realID + ", fake " + fakeID);
            return false;
        }
        return true;
    }

    private final void doPostGenProcessing(World world) {
        for (BlockData block : this.postGenBlocks) {
            int realID;
            int fakeID = block.getBlockID();
            int n = realID = Math.abs(fakeID) > 4095 ? this.getRealBlockID(fakeID, block.getCustomData1()) : fakeID;
            if (Math.abs(realID) > 4095) {
                LogHelper.warning("Invalid block ID. Initial ID: " + fakeID + ", returned id from getRealID: " + realID);
                continue;
            }
            LogHelper.fine("Post-GENERATOR processing for initial ID: " + fakeID + ", returned id from getRealID: " + realID);
            Block realBlock = Block.func_149729_e((int)Math.abs(realID));
            if (realID < 0 && !world.func_147437_c(block.getPosX(), block.getPosY(), block.getPosZ()) && world.func_147439_a(block.getPosX(), block.getPosY(), block.getPosZ()).func_149688_o().func_76230_c()) continue;
            world.func_147465_d(block.getPosX(), block.getPosY(), block.getPosZ(), realBlock, block.getMetaData(), 3);
            if (world.func_72805_g(block.getPosX(), block.getPosY(), block.getPosZ()) != block.getMetaData()) {
                LogHelper.warning("Mismatched metadata. Meta from world: " + world.func_72805_g(block.getPosX(), block.getPosY(), block.getPosZ()) + ", original: " + block.getMetaData());
            }
            if (Math.abs(fakeID) <= 4095) continue;
            this.onCustomBlockAdded(world, block.getPosX(), block.getPosY(), block.getPosZ(), fakeID, block.getCustomData1(), block.getCustomData2());
        }
        this.postGenBlocks.clear();
    }

    private final void setOffsetFromRotation() {
        for (int i = 0; i < this.manualRotations; ++i) {
            int x = -this.offsetZ;
            int z = this.offsetX;
            this.offsetX = x;
            this.offsetZ = z;
        }
    }

    private final void reset() {
        this.blockArrayList.clear();
        this.blockArray = null;
        this.offsetZ = 0;
        this.offsetY = 0;
        this.offsetX = 0;
    }
}

