/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain.config;

import java.time.MonthDay;
import java.util.ArrayList;
import java.util.List;
import naqaden.namepain.NamePain;
import naqaden.namepain.Util;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    private static final String labelT = TextFormatting.DARK_GREEN.toString() + "true" + TextFormatting.RESET.toString();
    private static final String labelF = TextFormatting.DARK_RED.toString() + "false" + TextFormatting.RESET.toString();
    private static final String labelV = TextFormatting.AQUA.toString() + "[vanilla]" + TextFormatting.RESET.toString();
    private static final String labelR = TextFormatting.RED.toString() + "Red";
    private static final String labelG = TextFormatting.GREEN.toString() + "Green";
    private static final String labelB = TextFormatting.BLUE.toString() + "Blue";
    private static final String labelA = TextFormatting.GRAY.toString() + "Alpha";
    public static List<IConfigElement> configElements;
    private static ConfigCategory confCatOptions;
    public static boolean namesWithoutHUD;
    public static boolean applyToMobs;
    public static boolean tamesAlwaysNamed;
    public static Class<?> playerClass;
    public static boolean applyToScores;
    public static boolean stripFormat;
    private static ConfigCategory confCatNameMax;
    public static int nameMaxR;
    public static int nameMaxG;
    public static int nameMaxB;
    public static int nameMaxA;
    public static float nameMaxV;
    private static ConfigCategory confCatNameMin;
    public static int nameMinR;
    public static int nameMinG;
    public static int nameMinB;
    public static int nameMinA;
    public static float nameMinV;
    private static ConfigCategory confCatPlateMax;
    public static int plateMaxR;
    public static int plateMaxG;
    public static int plateMaxB;
    public static int plateMaxA;
    public static float plateMaxV;
    private static ConfigCategory confCatPlateMin;
    public static int plateMinR;
    public static int plateMinG;
    public static int plateMinB;
    public static int plateMinA;
    public static float plateMinV;
    private static ConfigCategory confCatSurprise;
    private static String strCatSurprise;
    public static String strHeart;
    public static boolean doValentines;
    public static boolean doAprilFools;

    public static Property getProperty(Configuration config, String category, String key, String defaultValue, Property.Type type) {
        ConfigCategory cat = config.getCategory(category);
        if (cat.containsKey(key)) {
            Property prop = cat.get(key);
            if (prop.getType() != type) {
                prop = new Property(prop.getName(), prop.getString(), type);
                cat.put(key, prop);
            }
            prop.setDefaultValue(defaultValue);
            return prop;
        }
        if (defaultValue != null) {
            Property prop = new Property(key, defaultValue, type);
            prop.setValue(defaultValue);
            cat.put(key, prop);
            prop.setDefaultValue(defaultValue);
            return prop;
        }
        return null;
    }

    public static boolean getBoolean(Configuration config, String category, String name, boolean defaultValue, String comment) {
        Property prop = Config.getProperty(config, category, name, Boolean.toString(defaultValue), Property.Type.BOOLEAN);
        prop.setLanguageKey(name);
        prop.setComment(" [default: " + defaultValue + "]" + (comment.isEmpty() ? "" : "\n " + comment));
        try {
            return Boolean.parseBoolean(prop.getString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static int getInt(Configuration config, String category, String name, int defaultValue, int minValue, int maxValue, String comment) {
        Property prop = Config.getProperty(config, category, name, Integer.toString(defaultValue), Property.Type.INTEGER);
        prop.setLanguageKey(name);
        prop.setComment(" [range: " + minValue + " ~ " + maxValue + ", default: " + defaultValue + "]" + (comment.isEmpty() ? "" : "\n " + comment));
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        try {
            int parseInt = Integer.parseInt(prop.getString());
            return parseInt < minValue ? minValue : (parseInt > maxValue ? maxValue : parseInt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static float getFloat(Configuration config, String category, String name, float defaultValue, float minValue, float maxValue, String comment) {
        Property prop = Config.getProperty(config, category, name, Float.toString(defaultValue), Property.Type.DOUBLE);
        prop.setLanguageKey(name);
        prop.setComment(" [range: " + minValue + " ~ " + maxValue + ", default: " + defaultValue + "]" + (comment.isEmpty() ? "" : "\n " + comment));
        prop.setMinValue((double)minValue);
        prop.setMaxValue((double)maxValue);
        try {
            float parseFloat = Float.parseFloat(prop.getString());
            return parseFloat < minValue ? minValue : (parseFloat > maxValue ? maxValue : parseFloat);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("namepain")) {
            Config.reload();
        }
    }

    public static void reload() {
        try {
            if (NamePain.config.hasChanged()) {
                NamePain.config.save();
            }
            NamePain.config.load();
            Config.initCategories();
        }
        catch (Exception ex) {
            System.out.println("Problem accessing " + NamePain.configFile.getAbsolutePath() + ":");
            ex.printStackTrace(System.out);
        }
        finally {
            if (NamePain.config.hasChanged()) {
                NamePain.config.save();
            }
        }
    }

    public static void initCategories() {
        configElements = new ArrayList<IConfigElement>();
        String strCatOptions = "Settings";
        ArrayList<String> strOrderOptions = new ArrayList<String>(6);
        confCatOptions = NamePain.config.getCategory(strCatOptions);
        confCatOptions.setComment("Toggles for features");
        String strShowWithoutHUD = "Names Without HUD";
        strOrderOptions.add(strShowWithoutHUD);
        namesWithoutHUD = Config.getBoolean(NamePain.config, strCatOptions, strShowWithoutHUD, namesWithoutHUD, labelT + ": Always see names, even when the HUD is off.\n" + labelF + ": Only see names when the HUD is on. " + labelV);
        String strApplyToMobs = "Apply to Mobs";
        strOrderOptions.add(strApplyToMobs);
        applyToMobs = Config.getBoolean(NamePain.config, strCatOptions, strApplyToMobs, applyToMobs, labelT + ": Apply Name Pain coloring to mob names.\n" + labelF + ": Keep original coloring on mob names. " + labelV);
        String strTamesAlwaysNamed = "Tames Always Named";
        strOrderOptions.add(strTamesAlwaysNamed);
        tamesAlwaysNamed = Config.getBoolean(NamePain.config, strCatOptions, strTamesAlwaysNamed, tamesAlwaysNamed, labelT + ": Always see the names of your tames.\n" + labelF + ": Only see mob names when looking at them. " + labelV);
        String strPlayerClass = "See Your Name";
        strOrderOptions.add(strPlayerClass);
        playerClass = Config.getBoolean(NamePain.config, strCatOptions, strPlayerClass, false, labelT + ": See your own name in 3rd-person view.\nInventory view may have issues.\n" + labelF + ": Never see your nameplate. " + labelV) ? AbstractClientPlayer.class : EntityOtherPlayerMP.class;
        String strApplyToScores = "Apply to Scoreboards";
        strOrderOptions.add(strApplyToScores);
        applyToScores = Config.getBoolean(NamePain.config, strCatOptions, strApplyToScores, applyToScores, labelT + ": Apply Name Pain coloring to scoreboards.\n" + labelF + ": Keep original coloring on scoreboards. " + labelV);
        String strStripFormat = "Strip Format";
        strOrderOptions.add(strStripFormat);
        stripFormat = Config.getBoolean(NamePain.config, strCatOptions, strStripFormat, stripFormat, labelT + ": Remove existing formatting from nameplate text.\n" + labelF + ": Formatting like team colors might override Name Pain coloring on text. Plates will still be colorable.");
        Config.finishCategory(configElements, confCatOptions, strOrderOptions);
        ArrayList<String> strOrderRGBA = new ArrayList<String>();
        strOrderRGBA.add(labelR);
        strOrderRGBA.add(labelG);
        strOrderRGBA.add(labelB);
        strOrderRGBA.add(labelA);
        String strCatNameMax = "Name Color @ Max Health";
        confCatNameMax = NamePain.config.getCategory(strCatNameMax);
        confCatNameMax.setComment("RGBA values for NAMES with MAXIMUM health");
        nameMaxR = Config.getInt(NamePain.config, strCatNameMax, labelR, nameMaxR, 0, 255, "");
        nameMaxG = Config.getInt(NamePain.config, strCatNameMax, labelG, nameMaxG, 0, 255, "");
        nameMaxB = Config.getInt(NamePain.config, strCatNameMax, labelB, nameMaxB, 0, 255, "");
        nameMaxA = Math.round(Config.getFloat(NamePain.config, strCatNameMax, labelA, 1.0f, 0.0f, 1.0f, "0.0 = transparent, 1.0 = opaque") * 255.0f);
        nameMaxV = Util.getVibrancy(nameMaxR, nameMaxG, nameMaxB);
        Config.rgbaSliders(confCatNameMax);
        Config.finishCategory(configElements, confCatNameMax, strOrderRGBA);
        String strCatNameMin = "Name Color @ Min Health";
        confCatNameMin = NamePain.config.getCategory(strCatNameMin);
        confCatNameMin.setComment("RGBA values for NAMES with MINIMUM health");
        nameMinR = Config.getInt(NamePain.config, strCatNameMin, labelR, nameMinR, 0, 255, "");
        nameMinG = Config.getInt(NamePain.config, strCatNameMin, labelG, nameMinG, 0, 255, "");
        nameMinB = Config.getInt(NamePain.config, strCatNameMin, labelB, nameMinB, 0, 255, "");
        nameMinA = Math.round(Config.getFloat(NamePain.config, strCatNameMin, labelA, 1.0f, 0.0f, 1.0f, "0.0 = transparent, 1.0 = opaque") * 255.0f);
        nameMinV = Util.getVibrancy(nameMinR, nameMinG, nameMinB);
        Config.rgbaSliders(confCatNameMin);
        Config.finishCategory(configElements, confCatNameMin, strOrderRGBA);
        String strCatPlateMax = "Plate Color @ Max Health";
        confCatPlateMax = NamePain.config.getCategory(strCatPlateMax);
        confCatPlateMax.setComment("RGBA values for BACKGROUNDS with MAXIMUM health");
        plateMaxR = Config.getInt(NamePain.config, strCatPlateMax, labelR, plateMaxR, 0, 255, "");
        plateMaxG = Config.getInt(NamePain.config, strCatPlateMax, labelG, plateMaxG, 0, 255, "");
        plateMaxB = Config.getInt(NamePain.config, strCatPlateMax, labelB, plateMaxB, 0, 255, "");
        plateMaxA = Math.round(Config.getFloat(NamePain.config, strCatPlateMax, labelA, 0.25f, 0.0f, 1.0f, "0.0 = transparent, 1.0 = opaque") * 255.0f);
        plateMaxV = Util.getVibrancy(plateMaxR, plateMaxG, plateMaxB);
        Config.rgbaSliders(confCatPlateMax);
        Config.finishCategory(configElements, confCatPlateMax, strOrderRGBA);
        String strCatPlateMin = "Plate Color @ Min Health";
        confCatPlateMin = NamePain.config.getCategory(strCatPlateMin);
        confCatPlateMin.setComment("RGBA values for BACKGROUNDS with MINIMUM health");
        plateMinR = Config.getInt(NamePain.config, strCatPlateMin, labelR, plateMinR, 0, 255, "");
        plateMinG = Config.getInt(NamePain.config, strCatPlateMin, labelG, plateMinG, 0, 255, "");
        plateMinB = Config.getInt(NamePain.config, strCatPlateMin, labelB, plateMinB, 0, 255, "");
        plateMinA = Math.round(Config.getFloat(NamePain.config, strCatPlateMin, labelA, 0.25f, 0.0f, 1.0f, "0.0 = transparent, 1.0 = opaque") * 255.0f);
        plateMinV = Util.getVibrancy(plateMinR, plateMinG, plateMinB);
        Config.rgbaSliders(confCatPlateMin);
        Config.finishCategory(configElements, confCatPlateMin, strOrderRGBA);
        if (Config.isValentines() || Config.isAprilFools()) {
            confCatSurprise = NamePain.config.getCategory(strCatSurprise);
            if (Config.isValentines()) {
                doValentines = Config.getBoolean(NamePain.config, strCatSurprise, "Valentine Names", true, labelT + ": " + strHeart + " " + strHeart + " " + strHeart + "\n" + labelF + ": Heartless.");
            } else if (Config.isAprilFools()) {
                doAprilFools = Config.getBoolean(NamePain.config, strCatSurprise, "April Fools' Names", true, labelT + ": " + TextFormatting.OBFUSCATED.toString() + "What's in a name" + TextFormatting.RESET.toString() + "?\n" + labelF + ": Letters.");
            }
            configElements.add((IConfigElement)new ConfigElement(confCatSurprise));
        }
    }

    private static void rgbaSliders(ConfigCategory cat) {
        for (Property prop : cat.getOrderedValues()) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
    }

    private static void finishCategory(List<IConfigElement> elements, ConfigCategory cat, List<String> order) {
        for (String optionFromFile : cat.getPropertyOrder()) {
            if (order.contains(optionFromFile)) continue;
            cat.remove((Object)optionFromFile);
        }
        cat.setPropertyOrder(order);
        elements.add((IConfigElement)new ConfigElement(cat));
    }

    public static boolean isValentines() {
        return MonthDay.now().getMonthValue() == 2 && MonthDay.now().getDayOfMonth() == 14;
    }

    public static boolean isAprilFools() {
        return MonthDay.now().getMonthValue() == 4 && MonthDay.now().getDayOfMonth() == 1;
    }

    static {
        namesWithoutHUD = false;
        applyToMobs = true;
        tamesAlwaysNamed = true;
        playerClass = EntityOtherPlayerMP.class;
        applyToScores = false;
        stripFormat = false;
        nameMaxR = 255;
        nameMaxG = 255;
        nameMaxB = 255;
        nameMaxA = 255;
        nameMaxV = 255.0f;
        nameMinR = 255;
        nameMinG = 0;
        nameMinB = 0;
        nameMinA = 255;
        nameMinV = 255.0f;
        plateMaxR = 0;
        plateMaxG = 0;
        plateMaxB = 0;
        plateMaxA = 32;
        plateMaxV = 0.0f;
        plateMinR = 192;
        plateMinG = 0;
        plateMinB = 0;
        plateMinA = 32;
        plateMinV = 0.0f;
        strCatSurprise = "?";
        strHeart = TextFormatting.RED.toString() + "\u2764" + TextFormatting.RESET.toString();
        doValentines = false;
        doAprilFools = false;
    }
}

