/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.time.MonthDay;
import naqaden.namepain.Util;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CLIENT_CONFIG;
    private static ForgeConfigSpec.BooleanValue _namesWithoutHUD;
    private static ForgeConfigSpec.BooleanValue _applyToMobs;
    private static ForgeConfigSpec.BooleanValue _tamesAlwaysNamed;
    private static ForgeConfigSpec.BooleanValue _seeYourName;
    private static ForgeConfigSpec.BooleanValue _applyToScores;
    private static ForgeConfigSpec.BooleanValue _stripFormat;
    private static ForgeConfigSpec.IntValue _nameMaxR;
    private static ForgeConfigSpec.IntValue _nameMaxG;
    private static ForgeConfigSpec.IntValue _nameMaxB;
    private static ForgeConfigSpec.DoubleValue _nameMaxA;
    private static ForgeConfigSpec.IntValue _nameMinR;
    private static ForgeConfigSpec.IntValue _nameMinG;
    private static ForgeConfigSpec.IntValue _nameMinB;
    private static ForgeConfigSpec.DoubleValue _nameMinA;
    private static ForgeConfigSpec.IntValue _plateMaxR;
    private static ForgeConfigSpec.IntValue _plateMaxG;
    private static ForgeConfigSpec.IntValue _plateMaxB;
    private static ForgeConfigSpec.DoubleValue _plateMaxA;
    private static ForgeConfigSpec.IntValue _plateMinR;
    private static ForgeConfigSpec.IntValue _plateMinG;
    private static ForgeConfigSpec.IntValue _plateMinB;
    private static ForgeConfigSpec.DoubleValue _plateMinA;
    public static String strHeart;
    private static ForgeConfigSpec.BooleanValue _doValentines;
    private static ForgeConfigSpec.BooleanValue _doAprilFools;
    public static boolean namesWithoutHUD;
    public static boolean applyToMobs;
    public static boolean tamesAlwaysNamed;
    public static Class<?> playerClass;
    public static boolean applyToScores;
    public static boolean stripFormat;
    public static int nameMaxR;
    public static int nameMaxG;
    public static int nameMaxB;
    public static int nameMaxA;
    public static float nameMaxV;
    public static int nameMinR;
    public static int nameMinG;
    public static int nameMinB;
    public static int nameMinA;
    public static float nameMinV;
    public static int plateMaxR;
    public static int plateMaxG;
    public static int plateMaxB;
    public static int plateMaxA;
    public static float plateMaxV;
    public static int plateMinR;
    public static int plateMinG;
    public static int plateMinB;
    public static int plateMinA;
    public static float plateMinV;
    public static boolean doValentines;
    public static boolean doAprilFools;
    private static boolean isPaused;

    public static void loadConfig() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("namepain-client.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        CLIENT_CONFIG.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onPause(GuiOpenEvent event) {
        if (event.getGui() instanceof IngameMenuScreen && !isPaused) {
            isPaused = true;
        } else if (isPaused && event.getGui() == null) {
            Config.cacheConfig();
            isPaused = false;
        } else if (event.getGui() instanceof MainMenuScreen) {
            Config.cacheConfig();
        }
    }

    public static void cacheConfig() {
        Config.loadConfig();
        namesWithoutHUD = (Boolean)_namesWithoutHUD.get();
        applyToMobs = (Boolean)_applyToMobs.get() == false;
        tamesAlwaysNamed = (Boolean)_tamesAlwaysNamed.get();
        playerClass = (Boolean)_seeYourName.get() == false ? AbstractClientPlayerEntity.class : RemoteClientPlayerEntity.class;
        applyToScores = (Boolean)_applyToScores.get() == false;
        stripFormat = (Boolean)_stripFormat.get();
        nameMaxR = (Integer)_nameMaxR.get();
        nameMaxG = (Integer)_nameMaxG.get();
        nameMaxB = (Integer)_nameMaxB.get();
        nameMaxA = (int)Math.round((Double)_nameMaxA.get() * 255.0);
        nameMaxV = Util.getVibrancy(nameMaxR, nameMaxG, nameMaxB);
        nameMinR = (Integer)_nameMinR.get();
        nameMinG = (Integer)_nameMinG.get();
        nameMinB = (Integer)_nameMinB.get();
        nameMinA = (int)Math.round((Double)_nameMinA.get() * 255.0);
        nameMinV = Util.getVibrancy(nameMinR, nameMinG, nameMinB);
        plateMaxR = (Integer)_plateMaxR.get();
        plateMaxG = (Integer)_plateMaxG.get();
        plateMaxB = (Integer)_plateMaxB.get();
        plateMaxA = (int)Math.round((Double)_plateMaxA.get() * 255.0);
        plateMaxV = Util.getVibrancy(plateMaxR, plateMaxG, plateMaxB);
        plateMinR = (Integer)_plateMinR.get();
        plateMinG = (Integer)_plateMinG.get();
        plateMinB = (Integer)_plateMinB.get();
        plateMinA = (int)Math.round((Double)_plateMinA.get() * 255.0);
        plateMinV = Util.getVibrancy(plateMinR, plateMinG, plateMinB);
        doValentines = Config.isValentines() && (Boolean)_doValentines.get() != false;
        doAprilFools = Config.isAprilFools() && (Boolean)_doAprilFools.get() != false;
    }

    public static boolean isValentines() {
        return MonthDay.now().getMonthValue() == 2 && MonthDay.now().getDayOfMonth() == 14;
    }

    public static boolean isAprilFools() {
        return MonthDay.now().getMonthValue() == 4 && MonthDay.now().getDayOfMonth() == 1;
    }

    static {
        strHeart = TextFormatting.RED.toString() + "\u2764" + TextFormatting.RESET.toString();
        CLIENT_BUILDER.comment(new String[]{"HOW TO RELOAD: Configs reload every time you unpause or visit the title screen.", "", "Pardon this awkward layout. Please teach me a better way to sort options."}).push("Name Pain");
        _namesWithoutHUD = CLIENT_BUILDER.comment(new String[]{"", "true: Always see names, even when the HUD is off.", "false: Only see names when the HUD is on. [vanilla]", "Default: false"}).define("Show Without HUD", false);
        _applyToMobs = CLIENT_BUILDER.comment(new String[]{"", "true: Keep original coloring on mob names. [vanilla]", "false: Apply Name Pain coloring to mob names.", "Default: false"}).define("Vanilla Mobs", false);
        _tamesAlwaysNamed = CLIENT_BUILDER.comment(new String[]{"", "true: Always see the names of your tames.", "false: Only see mob names when looking at them. [vanilla]", "Default: true"}).define("Tames Always Named", true);
        _seeYourName = CLIENT_BUILDER.comment(new String[]{"", "true: Never see your nameplate. [vanilla]", "false: See your own name in 3rd-person view. Inventory view may have issues.", "Default: true"}).define("Vanilla Self", true);
        _applyToScores = CLIENT_BUILDER.comment(new String[]{"", "true: Keep original coloring on scoreboards. [vanilla]", "false: Apply Name Pain coloring to scoreboards.", "Default: true"}).define("Vanilla Scoreboards", true);
        _stripFormat = CLIENT_BUILDER.comment(new String[]{"", "true: Remove existing formatting from nameplate text.", "false: Formatting like team colors might override Name Pain coloring on text. Plates will still be colorable.", "Default: false"}).define("Strip Format", false);
        if (Config.isValentines()) {
            _doValentines = CLIENT_BUILDER.comment(new String[]{"", "true: <3 <3 <3", "false: Heartless.", "Default: true"}).define("Valentine Names", true);
        }
        if (Config.isAprilFools()) {
            _doAprilFools = CLIENT_BUILDER.comment(new String[]{"", "true: \\|/ # /-\\ '|' ' $ ! |\\| /-\\ |\\| /-\\ /\\/\\ [- ?", "false: Letters.", "Default: true"}).define("April Fools' Names", true);
        }
        CLIENT_BUILDER.push("Name");
        CLIENT_BUILDER.comment("RGBA values for NAMES with MINIMUM health (Default: opaque red)").push("Min");
        _nameMinR = CLIENT_BUILDER.comment("Default: 255").defineInRange("Red", 255, 0, 255);
        CLIENT_BUILDER.push("_");
        _nameMinG = CLIENT_BUILDER.comment("Default: 0").defineInRange("Green", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _nameMinB = CLIENT_BUILDER.comment("Default: 0").defineInRange("Blue", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _nameMinA = CLIENT_BUILDER.comment(new String[]{"0.0 = transparent, 1.0 = opaque", "Default: 1.0"}).defineInRange("Alpha", 1.0, 0.0, 1.0);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("RGBA values for NAMES with MAXIMUM health (Default: opaque white)").push("Max");
        _nameMaxR = CLIENT_BUILDER.comment("Default: 255").defineInRange("Red", 255, 0, 255);
        CLIENT_BUILDER.push("_");
        _nameMaxG = CLIENT_BUILDER.comment("Default: 255").defineInRange("Green", 255, 0, 255);
        CLIENT_BUILDER.push("_");
        _nameMaxB = CLIENT_BUILDER.comment("Default: 255").defineInRange("Blue", 255, 0, 255);
        CLIENT_BUILDER.push("_");
        _nameMaxA = CLIENT_BUILDER.comment(new String[]{"0.0 = transparent, 1.0 = opaque", "Default: 1.0"}).defineInRange("Alpha", 1.0, 0.0, 1.0);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("Plate");
        CLIENT_BUILDER.comment("RGBA values for BACKGROUNDS with MINIMUM health (Default: transparent black)").push("Min");
        _plateMinR = CLIENT_BUILDER.comment("Default: 192").defineInRange("Red", 192, 0, 255);
        CLIENT_BUILDER.push("_");
        _plateMinG = CLIENT_BUILDER.comment("Default: 0").defineInRange("Green", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _plateMinB = CLIENT_BUILDER.comment("Default: 0").defineInRange("Blue", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _plateMinA = CLIENT_BUILDER.comment(new String[]{"0.0 = transparent, 1.0 = opaque", "Default: 0.25"}).defineInRange("Alpha", 0.25, 0.0, 1.0);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("RGBA values for BACKGROUNDS with MAXIMUM health (Default: transparent black)").push("Max");
        _plateMaxR = CLIENT_BUILDER.comment("Default: 0").defineInRange("Red", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _plateMaxG = CLIENT_BUILDER.comment("Default: 0").defineInRange("Green", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _plateMaxB = CLIENT_BUILDER.comment("Default: 0").defineInRange("Blue", 0, 0, 255);
        CLIENT_BUILDER.push("_");
        _plateMaxA = CLIENT_BUILDER.comment(new String[]{"0.0 = transparent, 1.0 = opaque", "Default: 0.25"}).defineInRange("Alpha", 0.25, 0.0, 1.0);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        isPaused = false;
    }
}

