/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import naqaden.namepain.Util;
import naqaden.namepain.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NameplateRenderer {
    private static MatrixStack matrixStack;
    private static Matrix4f matrix;
    private static IRenderTypeBuffer renderBuffer;
    private static EntityRendererManager renderManager;
    private static FontRenderer fontRenderer;
    private static float strHalfWidth;
    private static LivingEntity entityLE;
    private static ScorePlayerTeam teamLE;
    private static UUID uuidLEOwner;
    private static AbstractClientPlayerEntity entityPE;
    private static ClientPlayerEntity entityMe;
    private static UUID uuidMe;
    private static ScorePlayerTeam teamMe;
    private static Scoreboard scoreboard;
    private static ScoreObjective scoreobjective;
    private static boolean isStanding;
    private static boolean isVisible;
    private static boolean canRenderName;
    private static int packedLight;
    private static double renderHeight;
    private static double distanceSq;
    private static String strHeart_;
    private static String str_Heart;
    private static float health;
    private static float healthInv;
    private static float strR;
    private static float strG;
    private static float strB;
    private static float strA;
    private static float strScaleV;
    private static int strRGBA;
    private static int strRGBAFaded;
    private static float bgR;
    private static float bgG;
    private static float bgB;
    private static float bgScaleV;
    private static int bgRGBA;

    @SubscribeEvent
    public static void onRenderNameplate(RenderNameplateEvent event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.getEntity() instanceof ItemFrameEntity) {
            if (!Config.seeFrameNames) {
                event.setResult(Event.Result.DENY);
            }
            return;
        }
        if (event.getEntity() instanceof ArmorStandEntity) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (renderManager == null) {
            renderManager = Minecraft.func_71410_x().func_175598_ae();
        }
        entityLE = (LivingEntity)event.getEntity();
        entityMe = Minecraft.func_71410_x().field_71439_g;
        if (uuidMe == null) {
            uuidMe = ClientPlayerEntity.func_146094_a((GameProfile)entityMe.func_146103_bH());
        }
        isStanding = !entityLE.func_226273_bm_();
        distanceSq = entityMe.func_70068_e((Entity)entityLE);
        double d = isStanding ? 4096.0 : 1024.0;
        if (distanceSq < d) {
            isVisible = !entityLE.func_98034_c((PlayerEntity)entityMe);
            teamLE = Util.getTeam(entityLE);
            UUID uUID = entityLE instanceof TameableEntity ? ((TameableEntity)entityLE).func_184753_b() : (uuidLEOwner = entityLE instanceof AbstractHorseEntity ? ((AbstractHorseEntity)entityLE).func_184780_dh() : null);
            if (teamLE == null && uuidLEOwner != null) {
                teamLE = Util.getTeam((LivingEntity)Util.UUIDToPlayer(NameplateRenderer.entityLE.field_70170_p, uuidLEOwner));
            }
            if (entityLE != entityMe && teamLE != null) {
                teamMe = Util.getTeam((LivingEntity)entityMe);
                switch (teamLE.func_178770_i()) {
                    case ALWAYS: {
                        canRenderName = isVisible;
                        break;
                    }
                    case NEVER: {
                        event.setResult(Event.Result.DENY);
                        return;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        canRenderName = teamMe == null ? isVisible : teamLE.func_142054_a((Team)teamMe) && (teamLE.func_98297_h() || isVisible);
                        break;
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        canRenderName = teamMe == null ? isVisible : !teamLE.func_142054_a((Team)teamMe) && isVisible;
                        break;
                    }
                    default: {
                        canRenderName = true;
                    }
                }
                canRenderName = canRenderName && (Minecraft.func_71382_s() || Config.namesWithoutHUD);
            } else {
                boolean bl = canRenderName = (Minecraft.func_71382_s() || Config.namesWithoutHUD) && isVisible && !entityLE.func_184207_aI();
            }
            if (canRenderName && (Config.playerClass.isInstance(entityLE) || entityLE.func_145818_k_() && (entityLE.func_174833_aM() || entityLE == NameplateRenderer.renderManager.field_147941_i || Config.tamesAlwaysNamed && Util.equalUUIDs(uuidLEOwner, uuidMe)))) {
                matrixStack = event.getMatrixStack();
                renderBuffer = event.getRenderTypeBuffer();
                if (fontRenderer == null) {
                    fontRenderer = renderManager.func_78716_a();
                }
                packedLight = event.getPackedLight();
                renderHeight = (double)entityLE.func_213302_cg() + 0.5;
                health = entityLE.func_110143_aJ() / entityLE.func_110138_aP();
                healthInv = 1.0f - health;
                strR = (float)Config.nameMaxR * health + (float)Config.nameMinR * healthInv;
                strG = (float)Config.nameMaxG * health + (float)Config.nameMinG * healthInv;
                strB = (float)Config.nameMaxB * health + (float)Config.nameMinB * healthInv;
                strA = (float)Config.nameMaxA * health + (float)Config.nameMinA * healthInv;
                strScaleV = (Config.nameMaxV * health + Config.nameMinV * healthInv) / Util.getVibrancy(strR, strG, strB);
                strRGBA = ((int)(strR * strScaleV) & 0xFF) << 16 | ((int)(strG * strScaleV) & 0xFF) << 8 | (int)(strB * strScaleV) & 0xFF;
                strRGBAFaded = ((int)(strA < 32.1f ? 4.1f : strA * 0.1255f) & 0xFF) << 24 | strRGBA;
                strRGBA = ((int)(strA < 4.1f ? 4.1f : strA) & 0xFF) << 24 | strRGBA;
                bgR = (float)Config.plateMaxR * health + (float)Config.plateMinR * healthInv;
                bgG = (float)Config.plateMaxG * health + (float)Config.plateMinG * healthInv;
                bgB = (float)Config.plateMaxB * health + (float)Config.plateMinB * healthInv;
                bgScaleV = (Config.plateMaxV * health + Config.plateMinV * healthInv) / Util.getVibrancy(bgR, bgG, bgB);
                bgRGBA = ((int)((float)Config.plateMaxA * health + (float)Config.plateMinA * healthInv) & 0xFF) << 24 | ((int)(bgR * bgScaleV) & 0xFF) << 16 | ((int)(bgG * bgScaleV) & 0xFF) << 8 | (int)(bgB * bgScaleV) & 0xFF;
                if (entityLE instanceof AbstractClientPlayerEntity) {
                    entityPE = (AbstractClientPlayerEntity)entityLE;
                    if (distanceSq < 100.0 && (scoreobjective = (scoreboard = NameplateRenderer.entityPE.field_70170_p.func_96441_U()).func_96539_a(2)) != null) {
                        if (Config.applyToScores) {
                            NameplateRenderer.drawNameplate(NameplateRenderer.formatScore(entityPE, scoreboard, scoreobjective, Config.stripFormat), strRGBA, strRGBAFaded, bgRGBA);
                        } else {
                            NameplateRenderer.drawNameplate(NameplateRenderer.formatScore(entityPE, scoreboard, scoreobjective, false), isStanding ? -1 : 0x20FFFFFF, 0x20FFFFFF, 0x40000000);
                        }
                        renderHeight += 0.25875;
                    }
                    if (Config.stripFormat) {
                        NameplateRenderer.drawNameplate((ITextComponent)NameplateRenderer.formatName(entityPE.func_146103_bH().getName()), strRGBA, strRGBAFaded, bgRGBA);
                    } else {
                        NameplateRenderer.drawNameplate((ITextComponent)NameplateRenderer.formatTeamName(entityPE.func_146103_bH().getName(), teamLE), strRGBA, strRGBAFaded, bgRGBA);
                    }
                } else if (Config.applyToMobs) {
                    if (Config.stripFormat) {
                        NameplateRenderer.drawNameplate((ITextComponent)NameplateRenderer.formatName(TextFormatting.func_110646_a((String)entityLE.func_200201_e().getString())), strRGBA, strRGBAFaded, bgRGBA);
                    } else {
                        NameplateRenderer.drawNameplate((ITextComponent)NameplateRenderer.formatTeamName(entityLE.func_200201_e().getString(), teamLE), strRGBA, strRGBAFaded, bgRGBA);
                    }
                } else {
                    NameplateRenderer.drawNameplate(event.getContent(), isStanding ? -1 : 0x20FFFFFF, 0x20FFFFFF, 0x40000000);
                }
            }
        }
        event.setResult(Event.Result.DENY);
    }

    private static ITextComponent formatScore(AbstractClientPlayerEntity player, Scoreboard board, ScoreObjective objective, boolean stripFormat) {
        if (stripFormat) {
            return new StringTextComponent(board.func_96529_a(player.func_146103_bH().getName(), objective).func_96652_c() + " " + objective.func_96678_d().getString());
        }
        return new StringTextComponent(board.func_96529_a(player.func_146103_bH().getName(), objective).func_96652_c() + " ").func_230529_a_(objective.func_96678_d());
    }

    private static StringTextComponent formatName(String name) {
        if (Config.doValentines) {
            name = strHeart_ + name + str_Heart;
        } else if (Config.doAprilFools) {
            name = TextFormatting.OBFUSCATED.toString() + name + TextFormatting.RESET.toString();
        }
        return new StringTextComponent(name);
    }

    private static StringTextComponent formatTeamName(String name, ScorePlayerTeam team) {
        if (team == null) {
            return NameplateRenderer.formatName(name);
        }
        return NameplateRenderer.formatName(team.func_178775_l().toString() + name + TextFormatting.RESET.toString());
    }

    private static void drawNameplate(ITextComponent txt, int strRGBA, int strRGBAFaded, int bgRGBA) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, renderHeight, 0.0);
        matrixStack.func_227863_a_(renderManager.func_229098_b_());
        matrixStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
        matrix = matrixStack.func_227866_c_().func_227870_a_();
        strHalfWidth = -fontRenderer.func_238414_a_((ITextProperties)txt) / 2;
        fontRenderer.func_243247_a(txt, strHalfWidth, 0.0f, strRGBAFaded, false, matrix, renderBuffer, isStanding, bgRGBA, packedLight);
        if (isStanding) {
            fontRenderer.func_243247_a(txt, strHalfWidth, 0.0f, strRGBA, false, matrix, renderBuffer, false, 0, packedLight);
        }
        matrixStack.func_227865_b_();
    }

    static {
        isStanding = true;
        isVisible = true;
        canRenderName = false;
        renderHeight = 0.0;
        distanceSq = 0.0;
        strHeart_ = Config.strHeart + " ";
        str_Heart = " " + Config.strHeart;
        health = 1.0f;
        healthInv = 0.0f;
        strR = 255.0f;
        strG = 255.0f;
        strB = 255.0f;
        strA = 255.0f;
        strScaleV = 255.0f;
        strRGBA = -1;
        strRGBAFaded = 0x20FFFFFF;
        bgR = 0.0f;
        bgG = 0.0f;
        bgB = 0.0f;
        bgScaleV = 0.0f;
        bgRGBA = 0x40000000;
    }
}

