/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression;

import com.oitsjustjose.naturalprogression.client.ClientProxy;
import com.oitsjustjose.naturalprogression.common.CommonProxy;
import com.oitsjustjose.naturalprogression.common.blocks.NaturalProgressionBlocks;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.event.BoneEvent;
import com.oitsjustjose.naturalprogression.common.event.GroundBreak;
import com.oitsjustjose.naturalprogression.common.event.StoneBreak;
import com.oitsjustjose.naturalprogression.common.event.ToolNeutering;
import com.oitsjustjose.naturalprogression.common.event.ToolTips;
import com.oitsjustjose.naturalprogression.common.event.WoodBreak;
import com.oitsjustjose.naturalprogression.common.items.NaturalProgressionItems;
import com.oitsjustjose.naturalprogression.common.recipes.DamageItemRecipe;
import com.oitsjustjose.naturalprogression.common.utils.Sounds;
import com.oitsjustjose.naturalprogression.common.world.feature.PebbleFeature;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="natural-progression")
public class NaturalProgression {
    private static NaturalProgression instance;
    public Logger LOGGER = LogManager.getLogger();
    public static CommonProxy proxy;
    public static final IRecipeSerializer<DamageItemRecipe> DAMAGE_ITEM_RECIPE;

    public NaturalProgression() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new WoodBreak());
        MinecraftForge.EVENT_BUS.register((Object)new StoneBreak());
        MinecraftForge.EVENT_BUS.register((Object)new GroundBreak());
        MinecraftForge.EVENT_BUS.register((Object)new Sounds());
        MinecraftForge.EVENT_BUS.register((Object)new ToolTips());
        MinecraftForge.EVENT_BUS.register((Object)new ToolNeutering());
        MinecraftForge.EVENT_BUS.register((Object)new BoneEvent());
        this.configSetup();
    }

    public static NaturalProgression getInstance() {
        return instance;
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfig.COMMON_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("natural-progression-common.toml"));
    }

    public void setup(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Biome.func_222280_a((Feature)new PebbleFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215022_h, (IPlacementConfig)new NoPlacementConfig()));
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        DAMAGE_ITEM_RECIPE = new DamageItemRecipe.Serializer();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            NaturalProgressionBlocks.registerBlocks(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            NaturalProgressionBlocks.registerBlockItems(itemRegistryEvent);
            NaturalProgressionItems.registerItems(itemRegistryEvent);
        }

        @SubscribeEvent
        public static void onRegisterSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)DAMAGE_ITEM_RECIPE.setRegistryName(new ResourceLocation("natural-progression", "damage_tools")));
        }
    }
}

