/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.oitsjustjose.naturalprogression.NaturalProgression;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DamageItemRecipe
extends ShapelessRecipe {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    private DamageItemRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
        this.inputs = inputs;
        this.output = output;
    }

    @Nonnull
    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            recipeitemhelper.func_221264_a(itemstack, 1);
        }
        return i == this.inputs.size() && recipeitemhelper.func_194116_a((IRecipe)this, null);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77973_b().func_77645_m()) continue;
            ItemStack savedStack = stack.func_77946_l();
            boolean shouldAttemptDmg = true;
            Random random = new Random();
            int unbreakingLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)savedStack);
            if (unbreakingLvl > 0) {
                boolean bl = shouldAttemptDmg = 1 + random.nextInt(5) <= unbreakingLvl;
            }
            if (savedStack.func_77952_i() < savedStack.func_77958_k()) {
                if (shouldAttemptDmg) {
                    savedStack.func_196085_b(savedStack.func_77952_i() + 1);
                }
                nonnulllist.set(i, (Object)savedStack);
                continue;
            }
            nonnulllist.set(i, (Object)ItemStack.field_190927_a);
        }
        return nonnulllist;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return NaturalProgression.DAMAGE_ITEM_RECIPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DamageItemRecipe> {
        @Nonnull
        public DamageItemRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for natural-progression:damage_tools");
            }
            ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new DamageItemRecipe(recipeId, s, stack, nonnulllist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingr = Ingredient.func_199802_a((JsonElement)jsonArray.get(i));
                if (ingr.func_203189_d()) continue;
                nonnulllist.add((Object)ingr);
            }
            return nonnulllist;
        }

        public DamageItemRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack stack = buffer.func_150791_c();
            return new DamageItemRecipe(recipeId, s, stack, nonnulllist);
        }

        public void write(PacketBuffer buffer, DamageItemRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

