/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.blocks.PebbleBlock;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.utils.Utils;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PebbleFeature
extends Feature<NoFeatureConfig> {
    public PebbleFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn, true);
    }

    @ParametersAreNonnullByDefault
    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!((List)CommonConfig.DIMENSION_WHITELIST.get()).contains(Utils.dimensionToString(world.func_201675_m()))) {
            return false;
        }
        boolean placed = false;
        try {
            if (world.func_201672_e().func_175624_G() != WorldType.field_77138_c) {
                for (int i = 0; i < (Integer)CommonConfig.MAX_PEBBLES_PER_CHUNK.get(); ++i) {
                    BlockState stateToPlace;
                    BlockPos pebblePos = Utils.getPebblePos(world, new ChunkPos(pos));
                    if (pebblePos == null || Utils.inNonWaterFluid(world, pebblePos)) continue;
                    Block pebble = Utils.getPebbleForPos(world, pebblePos);
                    if (world.func_180495_p(pebblePos).func_177230_c() instanceof PebbleBlock) continue;
                    boolean isInWater = Utils.isInWater(world, pebblePos);
                    BlockState blockState = stateToPlace = isInWater ? (BlockState)pebble.func_176223_P().func_206870_a((IProperty)PebbleBlock.WATERLOGGED, (Comparable)Boolean.TRUE) : pebble.func_176223_P();
                    if (!world.func_180501_a(pebblePos, stateToPlace, 18)) continue;
                    if (Utils.canReplace(world.func_180495_p(pebblePos.func_177984_a()), world, pebblePos.func_177984_a())) {
                        world.func_175655_b(pos.func_177984_a(), false);
                    }
                    placed = true;
                }
            }
        }
        catch (Exception e) {
            NaturalProgression.getInstance().LOGGER.error(e.getMessage());
            return false;
        }
        return placed;
    }
}

