/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.naturalprogression.common.recipes;

import com.google.common.collect.ImmutableMap;
import com.oitsjustjose.naturalprogression.NaturalProgression;
import com.oitsjustjose.naturalprogression.common.config.CommonConfig;
import com.oitsjustjose.naturalprogression.common.recipes.DamageItemRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;

@Mod.EventBusSubscriber(modid="natural-progression")
public class RecipeRemover {
    private static final Field RECIPES = ObfuscationReflectionHelper.findField(RecipeManager.class, (String)"field_199522_d");

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        RecipeManager mgr = event.getServer().func_199529_aN();
        IReloadableResourceManager resourceMgr = event.getServer().func_195570_aG();
        RecipeRemover.remove(mgr);
        resourceMgr.func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)resourceManager -> RecipeRemover.remove(mgr)));
    }

    private static void remove(RecipeManager mgr) {
        if (((Boolean)CommonConfig.REMOVE_WOODEN_TOOL_RECIPES.get()).booleanValue()) {
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151053_p, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151017_I, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151039_o, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151038_n, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151041_m, 1));
        }
        if (((Boolean)CommonConfig.REMOVE_STONE_TOOL_RECIPES.get()).booleanValue()) {
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151049_t, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151018_J, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151050_s, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151051_r, 1));
            RecipeRemover.removeRecipes(mgr, new ItemStack((IItemProvider)Items.field_151052_q, 1));
        }
        if (((Boolean)CommonConfig.REMOVE_PLANK_RECIPES.get()).booleanValue()) {
            RecipeRemover.removeRecipes(mgr, (Tag<Item>)ItemTags.field_199905_b);
        }
    }

    private static void removeRecipes(RecipeManager recipeManager, ItemStack stack) {
        int recipesRemoved = RecipeRemover.removeRecipes(recipeManager, (IRecipe<?> recipe) -> {
            ItemStack recipeOutput = recipe.func_77571_b();
            return recipeOutput.equals(stack, false) && !(recipe.func_199559_b() instanceof DamageItemRecipe.Serializer);
        });
        NaturalProgression.getInstance().LOGGER.info("Removed {} recipe(s) for {}", (Object)recipesRemoved, (Object)stack.func_200301_q().func_150254_d());
    }

    private static void removeRecipes(RecipeManager recipeManager, Tag<Item> tag) {
        int recipesRemoved = RecipeRemover.removeRecipes(recipeManager, (IRecipe<?> recipe) -> {
            ItemStack recipeOutput = recipe.func_77571_b();
            return !recipeOutput.func_190926_b() && recipeOutput.func_77973_b().func_206844_a(tag) && !(recipe.func_199559_b() instanceof DamageItemRecipe.Serializer);
        });
        NaturalProgression.getInstance().LOGGER.info("Removed {} recipe(s) for tag {}", (Object)recipesRemoved, (Object)tag.func_199886_b());
    }

    private static int removeRecipes(RecipeManager recipeManager, Predicate<IRecipe<?>> predicate) {
        Map existingRecipes;
        try {
            Map recipesMap;
            existingRecipes = recipesMap = (Map)RECIPES.get(recipeManager);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't get recipes map while removing recipes", e);
        }
        Object2IntOpenHashMap removedCounts = new Object2IntOpenHashMap();
        ImmutableMap.Builder newRecipes = ImmutableMap.builder();
        existingRecipes.forEach((arg_0, arg_1) -> RecipeRemover.lambda$removeRecipes$4(predicate, (Object2IntMap)removedCounts, newRecipes, arg_0, arg_1));
        int removedCount = removedCounts.values().stream().reduce(0, Integer::sum);
        try {
            RECIPES.set(recipeManager, newRecipes.build());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't replace recipes map while removing recipes", e);
        }
        return removedCount;
    }

    private static /* synthetic */ void lambda$removeRecipes$4(Predicate predicate, Object2IntMap removedCounts, ImmutableMap.Builder newRecipes, IRecipeType recipeType, Map existingRecipesForType) {
        ImmutableMap newRecipesForType = (ImmutableMap)existingRecipesForType.entrySet().stream().filter(entry -> !predicate.test(entry.getValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        removedCounts.put((Object)recipeType, existingRecipesForType.size() - newRecipesForType.size());
        newRecipes.put((Object)recipeType, (Object)newRecipesForType);
    }
}

