/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.NuclearCraft;
import nc.gui.machine.GuiFurnace;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;

public class MetalFurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<MetalFuelPair> ametalfuels;
    public static HashSet<Block> emetalfuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "metalfuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "metalsmelting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFurnace.class;
    }

    public String getRecipeName() {
        return "Metal Furnace";
    }

    public TemplateRecipeHandler newInstance() {
        if (ametalfuels == null) {
            MetalFurnaceRecipeHandler.findMetalFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("metalsmelting") && ((Object)((Object)this)).getClass() == MetalFurnaceRecipeHandler.class) {
            Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new MetalSmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new MetalSmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("metalfuel") && ((Object)((Object)this)).getClass() == MetalFurnaceRecipeHandler.class) {
            this.loadCraftingRecipes("metalsmelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)recipe.getKey()), (ItemStack)ingredient)) continue;
            MetalSmeltingPair arecipe = new MetalSmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "nc:textures/gui/furnace.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 40, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> emetalfuels = new HashSet<Item>();
        emetalfuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        emetalfuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        emetalfuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        emetalfuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        emetalfuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        emetalfuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return emetalfuels;
    }

    private static void findMetalFuels() {
        ametalfuels = new ArrayList();
        Set<Item> emetalfuels = MetalFurnaceRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (emetalfuels.contains(item.func_77973_b()) || (burnTime = MetalFurnaceRecipeHandler.getItemBurnTime(item)) <= 0) continue;
            ametalfuels.add(new MetalFuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 8000 / NuclearCraft.metalFurnaceCookEfficiency;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
            }
            if (block == Blocks.field_150402_ci) {
                return 960000 / NuclearCraft.metalFurnaceCookEfficiency;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151055_y) {
            return 4000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151044_h) {
            return 96000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151129_at) {
            return 1200000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 4000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151072_bj) {
            return 144000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        return GameRegistry.getFuelValue((ItemStack)itemstack) * 64 / NuclearCraft.metalFurnaceCookEfficiency;
    }

    public static class MetalFuelPair {
        public PositionedStack stack;
        public int burnTime;

        public MetalFuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class MetalSmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public MetalSmeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)MetalFurnaceRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(MetalFurnaceRecipeHandler.this.cycleticks / 24, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return MetalFurnaceRecipeHandler.ametalfuels.get((int)(MetalFurnaceRecipeHandler.this.cycleticks / 24 % MetalFurnaceRecipeHandler.ametalfuels.size())).stack;
        }
    }
}

