/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.nei;

import codechicken.core.ReflectionManager;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import nc.crafting.nei.RecipeInfo;
import nc.crafting.workspace.NuclearWorkspaceCraftingManager;
import nc.crafting.workspace.NuclearWorkspaceShapedOreRecipe;
import nc.crafting.workspace.NuclearWorkspaceShapedRecipes;
import nc.gui.crafting.GuiNuclearWorkspace;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.lwjgl.opengl.GL11;

public class NuclearWorkspaceRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(97, 29, 29, 41), "nwcrafting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiNuclearWorkspace.class;
    }

    public String getRecipeName() {
        return "Heavy Duty Workspace";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("nwcrafting") && ((Object)((Object)this)).getClass() == NuclearWorkspaceRecipeHandler.class) {
            for (IRecipe irecipe : NuclearWorkspaceCraftingManager.getInstance().getRecipeList()) {
                CachedShapedRecipe recipe = null;
                if (irecipe instanceof NuclearWorkspaceShapedRecipes) {
                    recipe = new CachedShapedRecipe((NuclearWorkspaceShapedRecipes)irecipe);
                } else if (irecipe instanceof NuclearWorkspaceShapedOreRecipe) {
                    recipe = this.forgeShapedRecipe((NuclearWorkspaceShapedOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : NuclearWorkspaceCraftingManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof NuclearWorkspaceShapedRecipes) {
                recipe = new CachedShapedRecipe((NuclearWorkspaceShapedRecipes)irecipe);
            } else if (irecipe instanceof NuclearWorkspaceShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((NuclearWorkspaceShapedOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : NuclearWorkspaceCraftingManager.getInstance().getRecipeList()) {
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof NuclearWorkspaceShapedRecipes) {
                recipe = new CachedShapedRecipe((NuclearWorkspaceShapedRecipes)irecipe);
            } else if (irecipe instanceof NuclearWorkspaceShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((NuclearWorkspaceShapedOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.func_77973_b())) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public CachedShapedRecipe forgeShapedRecipe(NuclearWorkspaceShapedOreRecipe recipe) {
        try {
            Object[] items;
            int width = (Integer)ReflectionManager.getField(NuclearWorkspaceShapedOreRecipe.class, Integer.class, (Object)recipe, (int)4);
            int height = (Integer)ReflectionManager.getField(NuclearWorkspaceShapedOreRecipe.class, Integer.class, (Object)recipe, (int)5);
            for (Object item : items = recipe.getInput()) {
                if (!(item instanceof List) || !((List)item).isEmpty()) continue;
                return null;
            }
            return new CachedShapedRecipe(width, height, items, recipe.func_77571_b());
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe: ", (Throwable)e);
            return null;
        }
    }

    public String getGuiTexture() {
        return "nc:textures/gui/nuclearWorkspaceNEI.png";
    }

    public String getOverlayIdentifier() {
        return "nwcrafting";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || RecipeInfo.hasDefaultOverlay(gui, "nwcrafting");
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner(gui, "nwcrafting");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler(gui, "nwcrafting");
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)-1, (int)-4, (int)166, (int)98);
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)NuclearWorkspaceRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 135, 42);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(NuclearWorkspaceShapedRecipes recipe) {
            this(recipe.recipeWidth, recipe.recipeHeight, recipe.recipeItems, recipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 3 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NuclearWorkspaceRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

