/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import nc.NuclearCraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileContinuousBase
extends TileEntity
implements IEnergyHandler,
IEnergyProvider,
IEnergyConnection {
    public int maxStorage;
    public int energy;
    public int power = NuclearCraft.WRTGRF;
    public EnergyStorage storage;

    public TileContinuousBase(String localName, int pow) {
        this.storage = new EnergyStorage(pow * 2, pow * 2);
        this.power = pow;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.energy();
            this.addEnergy();
        }
        this.func_70296_d();
    }

    public void energy() {
        this.storage.receiveEnergy(this.power, false);
    }

    public void addEnergy() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (tile instanceof IEnergyReceiver) {
                this.storage.extractEnergy(((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), this.storage.extractEnergy(this.storage.getMaxEnergyStored(), true), false), false);
                continue;
            }
            if (!(tile instanceof IEnergyHandler)) continue;
            this.storage.extractEnergy(((IEnergyHandler)tile).receiveEnergy(side.getOpposite(), this.storage.extractEnergy(this.storage.getMaxEnergyStored(), true), false), false);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.storage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        this.writeEnergy(nbtTag);
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readEnergy(packet.func_148857_g());
        this.func_145839_a(packet.func_148857_g());
    }

    public void readEnergy(NBTTagCompound nbt) {
        if (nbt.func_74764_b("storage")) {
            this.storage.readFromNBT(nbt.func_74775_l("storage"));
        }
    }

    public void writeEnergy(NBTTagCompound nbt) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.storage.writeToNBT(fluidTag);
        nbt.func_74782_a("storage", (NBTBase)fluidTag);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection paramForgeDirection) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection paramForgeDirection) {
        return this.storage.getMaxEnergyStored();
    }
}

