/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import nc.NuclearCraft;
import nc.block.NCBlocks;
import nc.block.generator.BlockFissionReactorSteam;
import nc.handler.BombType;
import nc.handler.EntityBomb;
import nc.handler.NCExplosion;
import nc.tile.generator.TileSteamProducer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TileFissionReactorSteam
extends TileSteamProducer {
    private int tickCount = 0;
    public int complete;
    public int x0 = 0;
    public int y0 = 0;
    public int z0 = 0;
    public int x1 = 0;
    public int y1 = 0;
    public int z1 = 0;
    public int lx = 0;
    public int ly = 0;
    public int lz = 0;
    public int off = 0;
    public int S;
    public int H;
    public int MinusH;
    public int SReal;
    public int HReal;
    public int HCooling;
    public double steam;
    public int FReal;
    public int fueltime;
    public int fueltype;
    public int heat;
    public int efficiency;
    public int numberOfCells;
    private static double sMult = 0.75 * (double)NuclearCraft.fissionSteam;
    private static double hMult = NuclearCraft.fissionHeat;
    public String typeoffuel = StatCollector.func_74838_a((String)"gui.noFuel");
    public int MBNumber;
    public String problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
    public static String[] cellTypes = new String[]{"LEU235Cell", "HEU235Cell", "LEP239Cell", "HEP239Cell", "MOX239Cell", "TBUCell", "LEU233Cell", "HEU233Cell", "LEP241Cell", "HEP241Cell", "MOX241Cell", "LEU235CellOxide", "HEU235CellOxide", "LEP239CellOxide", "HEP239CellOxide", "LEU233CellOxide", "HEU233CellOxide", "LEP241CellOxide", "HEP241CellOxide", "LEN236Cell", "HEN236Cell", "LEA242Cell", "HEA242Cell", "LEC243Cell", "HEC243Cell", "LEC245Cell", "HEC245Cell", "LEC247Cell", "HEC247Cell", "LEN236CellOxide", "HEN236CellOxide", "LEA242CellOxide", "HEA242CellOxide", "LEC243CellOxide", "HEC243CellOxide", "LEC245CellOxide", "HEC245CellOxide", "LEC247CellOxide", "HEC247CellOxide", "TBUCellOxide"};
    public static String[] fuelTypes = new String[]{"LEU", "HEU", "LEP", "HEP", "MOX", "TBU", "LEU", "HEU", "LEP", "HEP", "MOX", "LEU-Ox", "HEU-Ox", "LEP-Ox", "HEP-Ox", "LEU-Ox", "HEU-Ox", "LEP-Ox", "HEP-Ox", "LEN", "HEN", "LEA", "HEA", "LEC", "HEC", "LEC", "HEC", "LEC", "HEC", "LEN-Ox", "HEN-Ox", "LEA-Ox", "HEA-Ox", "LEC-Ox", "HEC-Ox", "LEC-Ox", "HEC-Ox", "LEC-Ox", "HEC-Ox", "TBU-Ox"};

    public TileFissionReactorSteam() {
        super("fissionSteam", 100000, 2);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.checkStructure();
        if (!this.field_145850_b.field_72995_K) {
            this.product();
            this.fuel();
            this.steam();
            this.overheat();
        }
        this.typeoffuelx();
        if (this.flag != this.flag1) {
            this.flag1 = this.flag;
            BlockFissionReactorSteam.updateBlockState(this.flag, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
        if (this.fueltime < 0) {
            this.fueltime = 0;
        }
    }

    public void overheat() {
        if (this.heat >= 1000000) {
            if (NuclearCraft.nuclearMeltdowns) {
                if (this.func_145832_p() == 4) {
                    NCExplosion.createExplosion(new EntityBomb(this.field_145850_b).setType(BombType.BOMB_STANDARD), this.field_145850_b, this.field_145851_c + (this.x0 + this.x1) / 2, this.field_145848_d + (this.y0 + this.y1) / 2, this.field_145849_e + (this.z0 + this.z1) / 2, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, true);
                } else if (this.func_145832_p() == 2) {
                    NCExplosion.createExplosion(new EntityBomb(this.field_145850_b).setType(BombType.BOMB_STANDARD), this.field_145850_b, this.field_145851_c - (this.z0 + this.z1) / 2, this.field_145848_d + (this.y0 + this.y1) / 2, this.field_145849_e + (this.x0 + this.x1) / 2, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, true);
                } else if (this.func_145832_p() == 5) {
                    NCExplosion.createExplosion(new EntityBomb(this.field_145850_b).setType(BombType.BOMB_STANDARD), this.field_145850_b, this.field_145851_c - (this.x0 + this.x1) / 2, this.field_145848_d + (this.y0 + this.y1) / 2, this.field_145849_e - (this.z0 + this.z1) / 2, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, true);
                } else if (this.func_145832_p() == 3) {
                    NCExplosion.createExplosion(new EntityBomb(this.field_145850_b).setType(BombType.BOMB_STANDARD), this.field_145850_b, this.field_145851_c + (this.z0 + this.z1) / 2, this.field_145848_d + (this.y0 + this.y1) / 2, this.field_145849_e - (this.x0 + this.x1) / 2, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, 0.01f * (float)(this.lx + this.ly + this.lz) * (float)NuclearCraft.explosionRadius, true);
                }
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                this.heat = 1000000;
            }
        }
    }

    public void typeoffuelx() {
        for (int i = 0; i < fuelTypes.length; ++i) {
            if (this.fueltype != i + 1) continue;
            this.typeoffuel = StatCollector.func_74838_a((String)("gui." + fuelTypes[i]));
            return;
        }
        this.typeoffuel = StatCollector.func_74838_a((String)"gui.noFuel");
    }

    private void steam() {
        double steamThisTick = 0.0;
        double fuelThisTick = 0.0;
        double heatThisTick = 0.0;
        double coolerHeatThisTick = 0.0;
        double fakeSteamThisTick = 0.0;
        double fakeHeatThisTick = 0.0;
        double numberOfCells = 0.0;
        double extraCells = 0.0;
        double adj1 = 0.0;
        double adj2 = 0.0;
        double adj3 = 0.0;
        double adj4 = 0.0;
        double adj5 = 0.0;
        double adj6 = 0.0;
        double baseSteam = 0.0;
        double baseFuel = 0.0;
        double baseHeat = 0.0;
        if (this.doesFuelMatchDepleted() && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.fueltime > 0 && this.fueltype != 0 && this.complete == 1) {
            this.off = 0;
            this.flag = true;
        } else if (this.doesFuelMatchDepleted() && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.fueltime > 0 && this.fueltype != 0 && this.complete == 1) {
            this.off = 1;
            this.flag = false;
        } else {
            this.off = 0;
            this.flag = false;
        }
        if (this.tickCount >= NuclearCraft.fissionUpdateRate) {
            int y;
            int x;
            int z;
            if (this.complete == 1) {
                for (z = this.z0 + 1; z <= this.z1 - 1; ++z) {
                    for (x = this.x0 + 1; x <= this.x1 - 1; ++x) {
                        for (y = this.y0 + 1; y <= this.y1 - 1; ++y) {
                            if (!this.find(NCBlocks.cellBlock, x, y, z)) continue;
                            extraCells = 0.0;
                            if (this.find(NCBlocks.cellBlock, x + 1, y, z) || this.find(NCBlocks.graphiteBlock, x + 1, y, z) && this.find(NCBlocks.cellBlock, x + 2, y, z)) {
                                extraCells += 1.0;
                            }
                            if (this.find(NCBlocks.cellBlock, x - 1, y, z) || this.find(NCBlocks.graphiteBlock, x - 1, y, z) && this.find(NCBlocks.cellBlock, x - 2, y, z)) {
                                extraCells += 1.0;
                            }
                            if (this.find(NCBlocks.cellBlock, x, y + 1, z) || this.find(NCBlocks.graphiteBlock, x, y + 1, z) && this.find(NCBlocks.cellBlock, x, y + 2, z)) {
                                extraCells += 1.0;
                            }
                            if (this.find(NCBlocks.cellBlock, x, y - 1, z) || this.find(NCBlocks.graphiteBlock, x, y - 1, z) && this.find(NCBlocks.cellBlock, x, y - 2, z)) {
                                extraCells += 1.0;
                            }
                            if (this.find(NCBlocks.cellBlock, x, y, z + 1) || this.find(NCBlocks.graphiteBlock, x, y, z + 1) && this.find(NCBlocks.cellBlock, x, y, z + 2)) {
                                extraCells += 1.0;
                            }
                            if (this.find(NCBlocks.cellBlock, x, y, z - 1) || this.find(NCBlocks.graphiteBlock, x, y, z - 1) && this.find(NCBlocks.cellBlock, x, y, z - 2)) {
                                extraCells += 1.0;
                            }
                            if (extraCells == 0.0) {
                                numberOfCells += 1.0;
                                continue;
                            }
                            if (extraCells == 1.0) {
                                adj1 += 1.0;
                                continue;
                            }
                            if (extraCells == 2.0) {
                                adj2 += 1.0;
                                continue;
                            }
                            if (extraCells == 3.0) {
                                adj3 += 1.0;
                                continue;
                            }
                            if (extraCells == 4.0) {
                                adj4 += 1.0;
                                continue;
                            }
                            if (extraCells == 5.0) {
                                adj5 += 1.0;
                                continue;
                            }
                            if (extraCells != 6.0) continue;
                            adj6 += 1.0;
                        }
                    }
                }
            }
            if (this.doesFuelMatchDepleted() && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.fueltime > 0 && this.fueltype != 0 && this.complete == 1) {
                this.flag = true;
                this.off = 0;
                if (this.fueltype == 1 || this.fueltype == 7) {
                    baseSteam = NuclearCraft.baseRFLEU;
                    baseFuel = NuclearCraft.baseFuelLEU;
                    baseHeat = NuclearCraft.baseHeatLEU;
                }
                if (this.fueltype == 2 || this.fueltype == 8) {
                    baseSteam = NuclearCraft.baseRFHEU;
                    baseFuel = NuclearCraft.baseFuelHEU;
                    baseHeat = NuclearCraft.baseHeatHEU;
                }
                if (this.fueltype == 3 || this.fueltype == 9) {
                    baseSteam = NuclearCraft.baseRFLEP;
                    baseFuel = NuclearCraft.baseFuelLEP;
                    baseHeat = NuclearCraft.baseHeatLEP;
                }
                if (this.fueltype == 4 || this.fueltype == 10) {
                    baseSteam = NuclearCraft.baseRFHEP;
                    baseFuel = NuclearCraft.baseFuelHEP;
                    baseHeat = NuclearCraft.baseHeatHEP;
                }
                if (this.fueltype == 5 || this.fueltype == 11) {
                    baseSteam = NuclearCraft.baseRFMOX;
                    baseFuel = NuclearCraft.baseFuelMOX;
                    baseHeat = NuclearCraft.baseHeatMOX;
                }
                if (this.fueltype == 6) {
                    baseSteam = NuclearCraft.baseRFTBU;
                    baseFuel = NuclearCraft.baseFuelTBU;
                    baseHeat = NuclearCraft.baseHeatTBU;
                }
                if (this.fueltype == 12 || this.fueltype == 16) {
                    baseSteam = NuclearCraft.baseRFLEUOx;
                    baseFuel = NuclearCraft.baseFuelLEUOx;
                    baseHeat = NuclearCraft.baseHeatLEUOx;
                }
                if (this.fueltype == 13 || this.fueltype == 17) {
                    baseSteam = NuclearCraft.baseRFHEUOx;
                    baseFuel = NuclearCraft.baseFuelHEUOx;
                    baseHeat = NuclearCraft.baseHeatHEUOx;
                }
                if (this.fueltype == 14 || this.fueltype == 18) {
                    baseSteam = NuclearCraft.baseRFLEPOx;
                    baseFuel = NuclearCraft.baseFuelLEPOx;
                    baseHeat = NuclearCraft.baseHeatLEPOx;
                }
                if (this.fueltype == 15 || this.fueltype == 19) {
                    baseSteam = NuclearCraft.baseRFHEPOx;
                    baseFuel = NuclearCraft.baseFuelHEPOx;
                    baseHeat = NuclearCraft.baseHeatHEPOx;
                }
                if (this.fueltype == 20) {
                    baseSteam = NuclearCraft.baseRFLEN;
                    baseFuel = NuclearCraft.baseFuelLEN;
                    baseHeat = NuclearCraft.baseHeatLEN;
                }
                if (this.fueltype == 21) {
                    baseSteam = NuclearCraft.baseRFHEN;
                    baseFuel = NuclearCraft.baseFuelHEN;
                    baseHeat = NuclearCraft.baseHeatHEN;
                }
                if (this.fueltype == 22) {
                    baseSteam = NuclearCraft.baseRFLEA;
                    baseFuel = NuclearCraft.baseFuelLEA;
                    baseHeat = NuclearCraft.baseHeatLEA;
                }
                if (this.fueltype == 23) {
                    baseSteam = NuclearCraft.baseRFHEA;
                    baseFuel = NuclearCraft.baseFuelHEA;
                    baseHeat = NuclearCraft.baseHeatHEA;
                }
                if (this.fueltype == 24 || this.fueltype == 26 || this.fueltype == 28) {
                    baseSteam = NuclearCraft.baseRFLEC;
                    baseFuel = NuclearCraft.baseFuelLEC;
                    baseHeat = NuclearCraft.baseHeatLEC;
                }
                if (this.fueltype == 25 || this.fueltype == 27 || this.fueltype == 29) {
                    baseSteam = NuclearCraft.baseRFHEC;
                    baseFuel = NuclearCraft.baseFuelHEC;
                    baseHeat = NuclearCraft.baseHeatHEC;
                }
                if (this.fueltype == 30) {
                    baseSteam = NuclearCraft.baseRFLENOx;
                    baseFuel = NuclearCraft.baseFuelLENOx;
                    baseHeat = NuclearCraft.baseHeatLENOx;
                }
                if (this.fueltype == 31) {
                    baseSteam = NuclearCraft.baseRFHENOx;
                    baseFuel = NuclearCraft.baseFuelHENOx;
                    baseHeat = NuclearCraft.baseHeatHENOx;
                }
                if (this.fueltype == 32) {
                    baseSteam = NuclearCraft.baseRFLEAOx;
                    baseFuel = NuclearCraft.baseFuelLEAOx;
                    baseHeat = NuclearCraft.baseHeatLEAOx;
                }
                if (this.fueltype == 33) {
                    baseSteam = NuclearCraft.baseRFHEAOx;
                    baseFuel = NuclearCraft.baseFuelHEAOx;
                    baseHeat = NuclearCraft.baseHeatHEAOx;
                }
                if (this.fueltype == 34 || this.fueltype == 36 || this.fueltype == 38) {
                    baseSteam = NuclearCraft.baseRFLECOx;
                    baseFuel = NuclearCraft.baseFuelLECOx;
                    baseHeat = NuclearCraft.baseHeatLECOx;
                }
                if (this.fueltype == 35 || this.fueltype == 37 || this.fueltype == 39) {
                    baseSteam = NuclearCraft.baseRFHECOx;
                    baseFuel = NuclearCraft.baseFuelHECOx;
                    baseHeat = NuclearCraft.baseHeatHECOx;
                }
                if (this.fueltype == 40) {
                    baseSteam = NuclearCraft.baseRFTBUOx;
                    baseFuel = NuclearCraft.baseFuelTBUOx;
                    baseHeat = NuclearCraft.baseHeatTBUOx;
                }
                steamThisTick += baseSteam * (10000.0 * sMult + (double)this.heat) * (numberOfCells + 2.0 * adj1 + 3.0 * adj2 + 4.0 * adj3 + 5.0 * adj4 + 6.0 * adj5 + 7.0 * adj6) / 1000000.0;
                heatThisTick += baseHeat * (numberOfCells + 3.0 * adj1 + 6.0 * adj2 + 10.0 * adj3 + 15.0 * adj4 + 21.0 * adj5 + 28.0 * adj6);
                fuelThisTick += (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) * baseFuel / (double)NuclearCraft.fissionEfficiency;
                for (z = this.z0 + 1; z <= this.z1 - 1; ++z) {
                    for (x = this.x0 + 1; x <= this.x1 - 1; ++x) {
                        for (y = this.y0 + 1; y <= this.y1 - 1; ++y) {
                            if (this.find(NCBlocks.graphiteBlock, x, y, z)) {
                                heatThisTick += hMult / 100.0 * baseSteam * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) / 5.0;
                                if (this.surroundOr(NCBlocks.cellBlock, x, y, z)) {
                                    steamThisTick += (10000.0 * sMult + (double)this.heat) * baseSteam * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) / 1.0E7;
                                }
                            }
                            if (!this.find(NCBlocks.speedBlock, x, y, z) || !(numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6 > 0.0) || this.lx - 2 + this.ly - 2 + this.lz - 2 <= 0) continue;
                            fuelThisTick += (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) * baseFuel / (double)(NuclearCraft.fissionEfficiency * (this.lx - 2 + this.ly - 2 + this.lz - 2));
                        }
                    }
                }
            } else if (this.doesFuelMatchDepleted() && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.fueltime > 0 && this.fueltype != 0 && this.complete == 1) {
                this.off = 1;
                if (this.fueltype == 1 || this.fueltype == 7) {
                    baseSteam = NuclearCraft.baseRFLEU;
                    baseHeat = NuclearCraft.baseHeatLEU;
                }
                if (this.fueltype == 2 || this.fueltype == 8) {
                    baseSteam = NuclearCraft.baseRFHEU;
                    baseHeat = NuclearCraft.baseHeatHEU;
                }
                if (this.fueltype == 3 || this.fueltype == 9) {
                    baseSteam = NuclearCraft.baseRFLEP;
                    baseHeat = NuclearCraft.baseHeatLEP;
                }
                if (this.fueltype == 4 || this.fueltype == 10) {
                    baseSteam = NuclearCraft.baseRFHEP;
                    baseHeat = NuclearCraft.baseHeatHEP;
                }
                if (this.fueltype == 5 || this.fueltype == 11) {
                    baseSteam = NuclearCraft.baseRFMOX;
                    baseHeat = NuclearCraft.baseHeatMOX;
                }
                if (this.fueltype == 6) {
                    baseSteam = NuclearCraft.baseRFTBU;
                    baseHeat = NuclearCraft.baseHeatTBU;
                }
                if (this.fueltype == 12 || this.fueltype == 16) {
                    baseSteam = NuclearCraft.baseRFLEUOx;
                    baseHeat = NuclearCraft.baseHeatLEUOx;
                }
                if (this.fueltype == 13 || this.fueltype == 17) {
                    baseSteam = NuclearCraft.baseRFHEUOx;
                    baseHeat = NuclearCraft.baseHeatHEUOx;
                }
                if (this.fueltype == 14 || this.fueltype == 18) {
                    baseSteam = NuclearCraft.baseRFLEPOx;
                    baseHeat = NuclearCraft.baseHeatLEPOx;
                }
                if (this.fueltype == 15 || this.fueltype == 19) {
                    baseSteam = NuclearCraft.baseRFHEPOx;
                    baseHeat = NuclearCraft.baseHeatHEPOx;
                }
                if (this.fueltype == 20) {
                    baseSteam = NuclearCraft.baseRFLEN;
                    baseHeat = NuclearCraft.baseHeatLEN;
                }
                if (this.fueltype == 21) {
                    baseSteam = NuclearCraft.baseRFHEN;
                    baseHeat = NuclearCraft.baseHeatHEN;
                }
                if (this.fueltype == 22) {
                    baseSteam = NuclearCraft.baseRFLEA;
                    baseHeat = NuclearCraft.baseHeatLEA;
                }
                if (this.fueltype == 23) {
                    baseSteam = NuclearCraft.baseRFHEA;
                    baseHeat = NuclearCraft.baseHeatHEA;
                }
                if (this.fueltype == 24 || this.fueltype == 26 || this.fueltype == 28) {
                    baseSteam = NuclearCraft.baseRFLEC;
                    baseHeat = NuclearCraft.baseHeatLEC;
                }
                if (this.fueltype == 25 || this.fueltype == 27 || this.fueltype == 29) {
                    baseSteam = NuclearCraft.baseRFHEC;
                    baseHeat = NuclearCraft.baseHeatHEC;
                }
                if (this.fueltype == 30) {
                    baseSteam = NuclearCraft.baseRFLENOx;
                    baseHeat = NuclearCraft.baseHeatLENOx;
                }
                if (this.fueltype == 31) {
                    baseSteam = NuclearCraft.baseRFHENOx;
                    baseHeat = NuclearCraft.baseHeatHENOx;
                }
                if (this.fueltype == 32) {
                    baseSteam = NuclearCraft.baseRFLEAOx;
                    baseHeat = NuclearCraft.baseHeatLEAOx;
                }
                if (this.fueltype == 33) {
                    baseSteam = NuclearCraft.baseRFHEAOx;
                    baseHeat = NuclearCraft.baseHeatHEAOx;
                }
                if (this.fueltype == 34 || this.fueltype == 36 || this.fueltype == 38) {
                    baseSteam = NuclearCraft.baseRFLECOx;
                    baseHeat = NuclearCraft.baseHeatLECOx;
                }
                if (this.fueltype == 35 || this.fueltype == 37 || this.fueltype == 39) {
                    baseSteam = NuclearCraft.baseRFHECOx;
                    baseHeat = NuclearCraft.baseHeatHECOx;
                }
                if (this.fueltype == 40) {
                    baseSteam = NuclearCraft.baseRFTBUOx;
                    baseHeat = NuclearCraft.baseHeatTBUOx;
                }
                fakeSteamThisTick += baseSteam * (10000.0 * sMult + (double)this.heat) * (numberOfCells + 2.0 * adj1 + 3.0 * adj2 + 4.0 * adj3 + 5.0 * adj4 + 6.0 * adj5 + 7.0 * adj6) / 1000000.0;
                fakeHeatThisTick += baseHeat * (hMult / 100.0) * (numberOfCells + 3.0 * adj1 + 6.0 * adj2 + 10.0 * adj3 + 15.0 * adj4 + 21.0 * adj5 + 28.0 * adj6);
                for (z = this.z0 + 1; z <= this.z1 - 1; ++z) {
                    for (x = this.x0 + 1; x <= this.x1 - 1; ++x) {
                        for (y = this.y0 + 1; y <= this.y1 - 1; ++y) {
                            if (!this.find(NCBlocks.graphiteBlock, x, y, z)) continue;
                            fakeHeatThisTick += hMult / 100.0 * baseSteam * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) / 5.0;
                            if (!this.surroundOr(NCBlocks.cellBlock, x, y, z)) continue;
                            fakeSteamThisTick += (10000.0 * sMult + (double)this.heat) * baseSteam * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) / 1.0E7;
                        }
                    }
                }
                this.flag = false;
            } else {
                this.flag = false;
                this.off = 0;
            }
            if (this.complete == 1) {
                for (z = this.z0 + 1; z <= this.z1 - 1; ++z) {
                    for (x = this.x0 + 1; x <= this.x1 - 1; ++x) {
                        for (y = this.y0 + 1; y <= this.y1 - 1; ++y) {
                            if (this.find(NCBlocks.coolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.standardCool;
                                if (this.surroundOr(NCBlocks.coolerBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)NuclearCraft.standardCool;
                                }
                            }
                            if (this.find(NCBlocks.waterCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.waterCool;
                                if (this.surroundOr(NCBlocks.reactorBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)NuclearCraft.waterCool;
                                }
                            }
                            if (this.find(NCBlocks.cryotheumCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.cryotheumCool;
                                if (this.surroundNAnd(NCBlocks.cryotheumCoolerBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)NuclearCraft.cryotheumCool;
                                }
                            }
                            if (this.find(NCBlocks.redstoneCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.redstoneCool;
                                if (this.surroundOr(NCBlocks.cellBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)NuclearCraft.redstoneCool;
                                }
                            }
                            if (this.find(NCBlocks.enderiumCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.enderiumCool;
                                if (this.surroundOr(NCBlocks.graphiteBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)NuclearCraft.enderiumCool;
                                }
                            }
                            if (this.find(NCBlocks.glowstoneCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.glowstoneCool;
                                if (this.surroundAnd(NCBlocks.graphiteBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)(3 * NuclearCraft.glowstoneCool);
                                }
                            }
                            if (this.find(NCBlocks.heliumCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.heliumCool;
                            }
                            if (this.find(NCBlocks.coolantCoolerBlock, x, y, z)) {
                                coolerHeatThisTick -= (double)NuclearCraft.coolantCool;
                                if (this.surroundOr(NCBlocks.waterCoolerBlock, x, y, z)) {
                                    coolerHeatThisTick -= (double)NuclearCraft.coolantCool;
                                }
                            }
                            if (!this.find(Blocks.field_150355_j, x, y, z)) continue;
                            coolerHeatThisTick -= 1.0;
                        }
                    }
                }
                if (this.lx - 2 + this.ly - 2 + this.lz - 2 <= 3) {
                    coolerHeatThisTick -= (double)NuclearCraft.baseHeatTBU;
                }
            }
            this.S = (int)(steamThisTick + fakeSteamThisTick);
            this.SReal = (int)steamThisTick;
            this.FReal = (int)fuelThisTick;
            this.H = (int)(heatThisTick + fakeHeatThisTick + coolerHeatThisTick);
            this.MinusH = -this.H;
            this.HReal = (int)(heatThisTick + coolerHeatThisTick);
            this.HCooling = (int)coolerHeatThisTick;
            this.efficiency = this.complete == 1 ? (int)(100.0 * (steamThisTick + fakeSteamThisTick) / (baseSteam * (sMult / 100.0) * (numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6))) : 0;
            this.numberOfCells = this.complete == 1 ? (int)(numberOfCells + adj1 + adj2 + adj3 + adj4 + adj5 + adj6) : 0;
            this.tickCount = 0;
        } else {
            ++this.tickCount;
        }
        if (this.SReal <= 0) {
            this.flag = false;
        }
        if (this.off == 0 && this.flag) {
            if (this.steam <= 1.0E9) {
                this.steam += (double)this.SReal;
            }
            if (this.SReal < 200) {
                if (this.tank.getFluidAmount() != 0 && this.tank.getFluid().getFluid() != NuclearCraft.steam) {
                    this.tank.drain(100000, true);
                }
                if (this.steam >= 200.0) {
                    this.tank.fill(new FluidStack(NuclearCraft.steam, 200), true);
                    this.steam -= 200.0;
                }
            } else if (this.SReal < 40000) {
                if (this.tank.getFluidAmount() != 0 && this.tank.getFluid().getFluid() != NuclearCraft.denseSteam) {
                    this.tank.drain(100000, true);
                }
                if (this.steam >= 40000.0) {
                    this.tank.fill(new FluidStack(NuclearCraft.denseSteam, 40), true);
                    this.steam -= 40000.0;
                }
            } else {
                if (this.tank.getFluidAmount() != 0 && this.tank.getFluid().getFluid() != NuclearCraft.superdenseSteam) {
                    this.tank.drain(100000, true);
                }
                for (int i = 0; i < 100 && this.steam >= 1000000.0; ++i) {
                    this.tank.fill(new FluidStack(NuclearCraft.superdenseSteam, 1), true);
                    this.steam -= 1000000.0;
                }
            }
        }
        if (this.off == 0 && this.flag) {
            this.fueltime -= this.FReal;
        }
        if (this.off == 0 && this.flag) {
            this.heat = this.heat + this.HReal >= 0 ? (this.heat += this.HReal) : 0;
        } else if (this.off == 1 && !this.flag) {
            this.heat = this.heat + this.HCooling >= 0 ? (this.heat += this.HCooling) : 0;
        }
        if (this.fueltime < 0) {
            this.fueltime = 0;
        }
        if (this.fueltime == 0) {
            this.S = 0;
        }
    }

    public boolean findBasic(Block block, int x, int y, int z) {
        return this.find(block, x, y, z);
    }

    public boolean nextToZMinus(Block block, int x, int y, int z) {
        return this.findBasic(block, x, y, z - 1);
    }

    public boolean between(Block block, int x, int y, int z) {
        return this.findBasic(block, x + 1, y, z) && this.findBasic(block, x - 1, y, z) || this.findBasic(block, x, y + 1, z) && this.findBasic(block, x, y - 1, z) || this.findBasic(block, x, y, z + 1) && this.findBasic(block, x, y, z - 1);
    }

    public boolean surroundOr(Block block, int x, int y, int z) {
        return this.findBasic(block, x + 1, y, z) || this.findBasic(block, x - 1, y, z) || this.findBasic(block, x, y + 1, z) || this.findBasic(block, x, y - 1, z) || this.findBasic(block, x, y, z + 1) || this.findBasic(block, x, y, z - 1);
    }

    public boolean surroundOr(Block block, Block block2, int x, int y, int z) {
        return this.findBasic(block, x + 1, y, z) && this.findBasic(block2, x + 2, y, z) || this.findBasic(block, x - 1, y, z) && this.findBasic(block2, x - 2, y, z) || this.findBasic(block, x, y + 1, z) && this.findBasic(block2, x, y + 2, z) || this.findBasic(block, x, y - 1, z) && this.findBasic(block2, x, y - 2, z) || this.findBasic(block, x, y, z + 1) && this.findBasic(block2, x, y, z + 2) || this.findBasic(block, x, y, z - 1) && this.findBasic(block2, x, y, z - 2);
    }

    public boolean surroundAnd(Block block, int x, int y, int z) {
        return this.findBasic(block, x + 1, y, z) && this.findBasic(block, x - 1, y, z) && this.findBasic(block, x, y + 1, z) && this.findBasic(block, x, y - 1, z) && this.findBasic(block, x, y, z + 1) && this.findBasic(block, x, y, z - 1);
    }

    public boolean surroundNAnd(Block block, int x, int y, int z) {
        return !this.findBasic(block, x + 1, y, z) && !this.findBasic(block, x - 1, y, z) && !this.findBasic(block, x, y + 1, z) && !this.findBasic(block, x, y - 1, z) && !this.findBasic(block, x, y, z + 1) && !this.findBasic(block, x, y, z - 1);
    }

    public boolean multiblockstring() {
        return this.complete == 1;
    }

    private boolean doesFuelMatchDepleted() {
        if (this.slots[0] == null) {
            return true;
        }
        if (this.slots[1] != null) {
            int type = TileFissionReactorSteam.setfueltype(this.slots[0]);
            if (OreDictionary.getOreIDs((ItemStack)this.slots[1]).length == 0 || OreDictionary.getOreIDs((ItemStack)this.slots[1]) == null) {
                for (int id : OreDictionary.getOreIDs((ItemStack)this.slots[1])) {
                    if (((ItemStack)OreDictionary.getOres((String)("d" + cellTypes[type - 1])).get(0)).func_77973_b() != ((ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)).get(0)).func_77973_b() || ((ItemStack)OreDictionary.getOres((String)("d" + cellTypes[type - 1])).get(0)).func_77960_j() != ((ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)).get(0)).func_77960_j() || this.slots[1].field_77994_a >= 64) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void fuel() {
        ItemStack fuel = this.func_70301_a(0);
        if (fuel != null && this.doesFuelMatchDepleted() && TileFissionReactorSteam.isFuel(fuel) && this.fueltime == 0 && this.fueltype == 0) {
            this.fueltime += TileFissionReactorSteam.fuelValue(fuel);
            this.fueltype = TileFissionReactorSteam.setfueltype(fuel);
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            this.off = 1;
        }
    }

    private void product() {
        if (this.slots[1] == null && this.fueltime <= 0 && this.fueltype != 0) {
            for (int i = 0; i < cellTypes.length; ++i) {
                if (this.fueltype != i + 1) continue;
                this.slots[1] = new ItemStack(((ItemStack)OreDictionary.getOres((String)("d" + cellTypes[i])).get(0)).func_77973_b(), 1, ((ItemStack)OreDictionary.getOres((String)("d" + cellTypes[i])).get(0)).func_77960_j());
                this.fueltype = 0;
            }
            this.fueltime = 0;
        } else if (this.slots[1] != null && this.fueltime <= 0 && this.fueltype != 0) {
            for (int i = 0; i < cellTypes.length; ++i) {
                for (int id : OreDictionary.getOreIDs((ItemStack)this.slots[1])) {
                    if (((ItemStack)OreDictionary.getOres((String)("d" + cellTypes[i])).get(0)).func_77973_b() != ((ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)).get(0)).func_77973_b() || ((ItemStack)OreDictionary.getOres((String)("d" + cellTypes[i])).get(0)).func_77960_j() != ((ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)).get(0)).func_77960_j() || this.slots[1].field_77994_a >= 64 || this.fueltype != i + 1) continue;
                    ++this.slots[1].field_77994_a;
                    this.fueltype = 0;
                }
            }
            this.fueltime = 0;
        }
    }

    public static boolean isFuel(ItemStack stack) {
        return TileFissionReactorSteam.fuelValue(stack) > 0 && TileFissionReactorSteam.setfueltype(stack) != 0;
    }

    public static int fuelValue(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        for (int i = 0; i < cellTypes.length; ++i) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (OreDictionary.getOreID((String)cellTypes[i]) != id) continue;
                return 10000000;
            }
        }
        return 0;
    }

    public static int setfueltype(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        for (int i = 0; i < cellTypes.length; ++i) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (OreDictionary.getOreID((String)cellTypes[i]) != id) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.typeoffuel = nbt.func_74779_i("Typeoffuel");
        this.problem = nbt.func_74779_i("problem");
        this.fueltime = nbt.func_74762_e("Fueltime");
        this.fueltype = nbt.func_74762_e("Fueltype");
        this.x0 = nbt.func_74762_e("x0");
        this.y0 = nbt.func_74762_e("y0");
        this.z0 = nbt.func_74762_e("z0");
        this.x1 = nbt.func_74762_e("x1");
        this.y1 = nbt.func_74762_e("y1");
        this.z1 = nbt.func_74762_e("z1");
        this.lx = nbt.func_74762_e("lx");
        this.ly = nbt.func_74762_e("ly");
        this.lz = nbt.func_74762_e("lz");
        this.S = nbt.func_74762_e("S");
        this.H = nbt.func_74762_e("H");
        this.MinusH = nbt.func_74762_e("MinusH");
        this.off = nbt.func_74762_e("off");
        this.MBNumber = nbt.func_74762_e("MBN");
        this.heat = nbt.func_74762_e("Heat");
        this.efficiency = nbt.func_74762_e("efficiency");
        this.numberOfCells = nbt.func_74762_e("numberOfCells");
        this.SReal = nbt.func_74762_e("SReal");
        this.HReal = nbt.func_74762_e("HReal");
        this.steam = nbt.func_74769_h("steam");
        this.HCooling = nbt.func_74762_e("HCooling");
        this.FReal = nbt.func_74762_e("FReal");
        this.complete = nbt.func_74762_e("complete");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Fueltime", this.fueltime);
        nbt.func_74768_a("Fueltype", this.fueltype);
        nbt.func_74768_a("x0", this.x0);
        nbt.func_74768_a("y0", this.y0);
        nbt.func_74768_a("z0", this.z0);
        nbt.func_74768_a("x1", this.x1);
        nbt.func_74768_a("y1", this.y1);
        nbt.func_74768_a("z1", this.z1);
        nbt.func_74768_a("lx", this.lx);
        nbt.func_74768_a("ly", this.ly);
        nbt.func_74768_a("lz", this.lz);
        nbt.func_74768_a("S", this.S);
        nbt.func_74768_a("H", this.H);
        nbt.func_74768_a("MinusH", this.MinusH);
        nbt.func_74768_a("off", this.off);
        nbt.func_74768_a("MBN", this.MBNumber);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74768_a("efficiency", this.efficiency);
        nbt.func_74768_a("numberOfCells", this.numberOfCells);
        nbt.func_74778_a("Typeoffuel", this.typeoffuel);
        nbt.func_74778_a("problem", this.problem);
        nbt.func_74768_a("SReal", this.SReal);
        nbt.func_74768_a("HReal", this.HReal);
        nbt.func_74780_a("steam", this.steam);
        nbt.func_74768_a("HCooling", this.HCooling);
        nbt.func_74768_a("FReal", this.FReal);
        nbt.func_74768_a("complete", this.complete);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return TileFissionReactorSteam.isFuel(stack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        return slot == 1;
    }

    private boolean find(Block block, int x, int y, int z) {
        int xc = this.field_145851_c;
        int yc = this.field_145848_d + y;
        int zc = this.field_145849_e;
        if (this.func_145832_p() == 4) {
            return this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block;
        }
        if (this.func_145832_p() == 2) {
            return this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block;
        }
        if (this.func_145832_p() == 5) {
            return this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block;
        }
        if (this.func_145832_p() == 3) {
            return this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block;
        }
        return false;
    }

    private boolean find(Block block, Block block2, Block block3, Block block4, int x, int y, int z) {
        int xc = this.field_145851_c;
        int yc = this.field_145848_d + y;
        int zc = this.field_145849_e;
        if (this.func_145832_p() == 4) {
            return this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block2 || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block3 || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block4;
        }
        if (this.func_145832_p() == 2) {
            return this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block2 || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block3 || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block4;
        }
        if (this.func_145832_p() == 5) {
            return this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block2 || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block3 || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block4;
        }
        if (this.func_145832_p() == 3) {
            return this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block2 || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block3 || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block4;
        }
        return false;
    }

    private boolean find(Block block, Block block2, Block block3, Block block4, Block block5, int x, int y, int z) {
        int xc = this.field_145851_c;
        int yc = this.field_145848_d + y;
        int zc = this.field_145849_e;
        if (this.func_145832_p() == 4) {
            return this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block2 || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block3 || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block4 || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block5;
        }
        if (this.func_145832_p() == 2) {
            return this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block2 || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block3 || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block4 || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block5;
        }
        if (this.func_145832_p() == 5) {
            return this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block2 || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block3 || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block4 || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block5;
        }
        if (this.func_145832_p() == 3) {
            return this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block2 || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block3 || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block4 || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block5;
        }
        return false;
    }

    private boolean checkStructure() {
        if (this.tickCount >= NuclearCraft.fissionUpdateRate) {
            int y;
            int x;
            int y2;
            int z;
            int l = NuclearCraft.fissionMaxLength + 2;
            Block b = NCBlocks.reactorBlock;
            Block r = NCBlocks.fissionReactorGraphiteIdle;
            Block rr = NCBlocks.fissionReactorGraphiteActive;
            Block rs = NCBlocks.fissionReactorSteamIdle;
            Block rrs = NCBlocks.fissionReactorSteamActive;
            boolean f = false;
            int rz = 0;
            int z0 = 0;
            int x0 = 0;
            int y0 = 0;
            int z1 = 0;
            int x1 = 0;
            int y1 = 0;
            for (z = 0; z <= l; ++z) {
                if (this.find(b, 0, 1, 0) || this.find(b, 0, -1, 0) || (this.find(b, 1, 1, 0) || this.find(b, 1, -1, 0)) && this.find(b, 1, 0, 0) || this.find(b, 1, 1, 0) && !this.find(b, 1, -1, 0) && !this.find(b, 1, 0, 0) || !this.find(b, 1, 1, 0) && this.find(b, 1, -1, 0) && !this.find(b, 1, 0, 0)) {
                    if (this.find(b, 0, 1, -z) || this.find(b, 0, -1, -z) || !this.find(b, r, rr, rs, rrs, 0, 0, -z + 1) && !this.find(b, r, rr, rs, rrs, 0, 1, -z + 1) && !this.find(b, r, rr, rs, rrs, 0, -1, -z + 1)) continue;
                    rz = l - z;
                    z0 = -z;
                    f = true;
                    break;
                }
                if (this.find(b, 0, 0, -z) || this.find(b, 1, 1, -z) || this.find(b, 1, -1, -z) || !this.find(b, r, rr, rs, rrs, 0, 0, -z + 1) || !this.find(b, 1, 0, -z) || !this.find(b, 1, 1, -z + 1) || !this.find(b, 1, -1, -z + 1)) continue;
                rz = l - z;
                z0 = -z;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                return false;
            }
            f = false;
            for (y2 = 0; y2 <= l; ++y2) {
                if (this.find(b, x0, -y2 + 1, z0) || this.find(b, x0 + 1, -y2, z0) || this.find(b, x0, -y2, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + 1, -y2, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0, -y2 + 1, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + 1, -y2 + 1, z0)) continue;
                y0 = -y2;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                return false;
            }
            f = false;
            for (z = 0; z <= rz; ++z) {
                if (this.find(b, x0, y0 + 1, z) || this.find(b, x0 + 1, y0, z) || this.find(b, x0, y0, z - 1) || !this.find(b, r, rr, rs, rrs, x0 + 1, y0, z - 1) || !this.find(b, r, rr, rs, rrs, x0, y0 + 1, z - 1) || !this.find(b, r, rr, rs, rrs, x0 + 1, y0 + 1, z)) continue;
                z1 = z;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                return false;
            }
            f = false;
            for (int x2 = 0; x2 <= l; ++x2) {
                if (this.find(b, x0 + x2, y0 + 1, z0) || this.find(b, x0 + x2 - 1, y0, z0) || this.find(b, x0 + x2, y0, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + x2 - 1, y0, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + x2, y0 + 1, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + x2 - 1, y0 + 1, z0)) continue;
                x1 = x0 + x2;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                return false;
            }
            f = false;
            for (y2 = 0; y2 <= l; ++y2) {
                if (this.find(b, x0, y0 + y2 - 1, z0) || this.find(b, x0 + 1, y0 + y2, z0) || this.find(b, x0, y0 + y2, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + 1, y0 + y2, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0, y0 + y2 - 1, z0 + 1) || !this.find(b, r, rr, rs, rrs, x0 + 1, y0 + y2 - 1, z0)) continue;
                y1 = y0 + y2;
                f = true;
                break;
            }
            if (!f) {
                this.complete = 0;
                this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                return false;
            }
            f = false;
            if (x0 > 0 || x1 < 0 || y0 > 0 || y1 < 0 || z0 > 0 || z1 < 0 || x1 - x0 < 1 || y1 - y0 < 1 || z1 - z0 < 1) {
                this.problem = StatCollector.func_74838_a((String)"gui.invalidStructure");
                this.complete = 0;
                return false;
            }
            for (z = z0; z <= z1; ++z) {
                for (x = x0; x <= x1; ++x) {
                    for (y = y0; y <= y1; ++y) {
                        if (!this.find(r, rr, rs, rrs, x, y, z) || x == 0 && y == 0 && z == 0) continue;
                        this.problem = StatCollector.func_74838_a((String)"gui.multipleControllers");
                        this.complete = 0;
                        return false;
                    }
                }
            }
            for (z = z0 + 1; z <= z1 - 1; ++z) {
                for (x = x0 + 1; x <= x1 - 1; ++x) {
                    if (!(this.find(b, x, y0, z) || x == 0 && y0 == 0 && z == 0)) {
                        this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                        this.complete = 0;
                        return false;
                    }
                    if (this.find(b, x, y1, z) || x == 0 && y1 == 0 && z == 0) continue;
                    this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                    this.complete = 0;
                    return false;
                }
            }
            for (y2 = y0 + 1; y2 <= y1 - 1; ++y2) {
                for (x = x0 + 1; x <= x1 - 1; ++x) {
                    if (!(this.find(b, x, y2, z0) || x == 0 && y2 == 0 && z0 == 0)) {
                        this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                        this.complete = 0;
                        return false;
                    }
                    if (this.find(b, x, y2, z1) || x == 0 && y2 == 0 && z1 == 0) continue;
                    this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                    this.complete = 0;
                    return false;
                }
                for (int z2 = z0 + 1; z2 <= z1 - 1; ++z2) {
                    if (!(this.find(b, x0, y2, z2) || x0 == 0 && y2 == 0 && z2 == 0)) {
                        this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                        this.complete = 0;
                        return false;
                    }
                    if (this.find(b, x1, y2, z2) || x1 == 0 && y2 == 0 && z2 == 0) continue;
                    this.problem = StatCollector.func_74838_a((String)"gui.casingIncomplete");
                    this.complete = 0;
                    return false;
                }
            }
            for (z = z0 + 1; z <= z1 - 1; ++z) {
                for (x = x0 + 1; x <= x1 - 1; ++x) {
                    for (y = y0 + 1; y <= y1 - 1; ++y) {
                        if (!this.find(b, r, rr, rs, rrs, x, y, z)) continue;
                        this.problem = StatCollector.func_74838_a((String)"gui.casingInInterior");
                        this.complete = 0;
                        return false;
                    }
                }
            }
            this.complete = 1;
            this.tickCount = 0;
            this.x0 = x0;
            this.y0 = y0;
            this.z0 = z0;
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.lx = x1 + 1 - x0;
            this.ly = y1 + 1 - y0;
            this.lz = z1 + 1 - z0;
            return true;
        }
        ++this.tickCount;
        return this.complete == 1;
    }
}

