/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.machine;

import nc.NuclearCraft;
import nc.block.machine.BlockAssembler;
import nc.crafting.machine.AssemblerRecipes;
import nc.tile.machine.TileMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileAssembler
extends TileMachineBase {
    public Mode mode = Mode.KEEP;

    public TileAssembler() {
        super("assembler", 250000, 4, 1, true, true, 100.0, 2000.0, NuclearCraft.assemblerSpeed, NuclearCraft.assemblerEfficiency, AssemblerRecipes.instance());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.flag != this.flag1) {
            this.flag1 = this.flag;
            BlockAssembler.updateBlockState(this.flag, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            mode = Mode.KEEP;
        }
        if (this.mode != mode) {
            this.mode = mode;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canCook() {
        for (int i = 0; i < this.inputSize; ++i) {
            if (this.slots[i] != null) continue;
            this.flag = false;
            return false;
        }
        ItemStack[] output = this.getOutput(this.inputs());
        for (int i = 0; i < this.inputSize; ++i) {
            if (this.recipes == null) continue;
            if (this.mode == Mode.KEEP && this.recipes.getInputSize(i, output) >= this.slots[i].field_77994_a) {
                this.flag = false;
                return false;
            }
            if (this.mode != Mode.USE || this.recipes.getInputSize(i, output) <= this.slots[i].field_77994_a) continue;
            this.flag = false;
            return false;
        }
        if ((double)this.cookTime >= this.getProcessTime) {
            this.flag = true;
            return true;
        }
        if (this.getEnergyRequired > (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() - (int)Math.ceil(this.getEnergyRequired / this.getProcessTime)) {
            this.flag = false;
            return false;
        }
        if (this.hasEnergy) {
            if (this.energyStorage.getEnergyStored() < 1 * (int)Math.ceil(this.getEnergyRequired / this.getProcessTime)) {
                this.flag = false;
                return false;
            }
            if (this.energyStorage.getEnergyStored() == 0) {
                this.flag = false;
                return false;
            }
        }
        if (output == null || output.length != this.outputSize) {
            return false;
        }
        for (int j = 0; j < this.outputSize; ++j) {
            if (output[j] == null) {
                this.flag = false;
                return false;
            }
            if (this.slots[j + this.inputSize] == null) continue;
            if (!this.slots[j + this.inputSize].func_77969_a(output[j])) {
                this.flag = false;
                return false;
            }
            if (this.slots[j + this.inputSize].field_77994_a + output[j].field_77994_a <= this.slots[j + this.inputSize].func_77976_d()) continue;
            this.flag = false;
            return false;
        }
        this.flag = true;
        return true;
    }

    public void readMode(NBTTagCompound nbt) {
        short mb = nbt.func_74765_d("mode");
        Mode[] modes = Mode.values();
        if (mb < 0 || mb >= modes.length) {
            mb = 0;
        }
        this.mode = modes[mb];
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readMode(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", (short)this.mode.ordinal());
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        this.writeSides(nbtTag);
        this.writeEnergy(nbtTag);
        nbtTag.func_74777_a("mode", (short)this.mode.ordinal());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readMode(packet.func_148857_g());
    }

    public static enum Mode {
        KEEP,
        USE;


        public Mode next() {
            int nextOrd = this.ordinal() + 1;
            if (nextOrd >= Mode.values().length) {
                nextOrd = 0;
            }
            return Mode.values()[nextOrd];
        }
    }
}

