/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.generator;

import com.google.common.collect.Lists;
import java.util.List;
import nc.container.generator.ContainerFusionCore;
import nc.gui.GuiFluidRenderer;
import nc.gui.GuiNC;
import nc.gui.NCGuiButton;
import nc.gui.NCGuiToggleButton;
import nc.network.PacketEmptyTankButton;
import nc.network.PacketGetFluidInTank;
import nc.network.PacketHandler;
import nc.network.PacketToggleTanksSharedButton;
import nc.tile.energy.ITileEnergy;
import nc.tile.generator.TileFusionCore;
import nc.util.NCMath;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFusionCore
extends GuiNC {
    public static int tick;
    public static FluidStack fluid0;
    public static FluidStack fluid1;
    public static FluidStack fluid2;
    public static FluidStack fluid3;
    public static FluidStack fluid4;
    public static FluidStack fluid5;
    public static FluidStack fluid6;
    public static FluidStack fluid7;
    private final InventoryPlayer playerInventory;
    protected TileFusionCore tile;
    protected final ResourceLocation gui_textures;

    public GuiFusionCore(EntityPlayer player, TileFusionCore tile) {
        super(new ContainerFusionCore(player, tile));
        this.playerInventory = player.field_71071_by;
        this.tile = tile;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/fusion_core.png");
        this.field_146999_f = 218;
        this.field_147000_g = 187;
    }

    protected int widthHalf(String s) {
        return this.field_146289_q.func_78256_a(s) / 2;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String input1;
        int fontColor = this.tile.isGenerating() || this.tile.canProcess() ? -1 : (this.tile.complete == 1 ? 0xEEAA00 : 0xEE0000);
        String name = I18n.func_74837_a((String)"gui.container.fusion_core.reactor", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, 108 - this.widthHalf(name), 10, fontColor);
        String size = this.tile.complete == 1 ? I18n.func_74837_a((String)"gui.container.fusion_core.size", (Object[])new Object[0]) + " " + this.tile.size : this.tile.problem;
        this.field_146289_q.func_78276_b(size, 108 - this.widthHalf(size), 21, fontColor);
        String energy = I18n.func_74837_a((String)"gui.container.fusion_core.energy", (Object[])new Object[0]) + " " + NCMath.prefix(this.tile.storage.getEnergyStored(), 6, "RF");
        this.field_146289_q.func_78276_b(energy, 108 - this.widthHalf(energy), 32, fontColor);
        String power = I18n.func_74837_a((String)"gui.container.fusion_core.power", (Object[])new Object[0]) + " " + NCMath.prefix((int)this.tile.processPower, 6, "RF/t");
        this.field_146289_q.func_78276_b(power, 108 - this.widthHalf(power), 43, fontColor);
        String heat = I18n.func_74837_a((String)"gui.container.fusion_core.heat", (Object[])new Object[0]) + " " + NCMath.prefix((int)this.tile.heat, 6, "K", 1);
        this.field_146289_q.func_78276_b(heat, 108 - this.widthHalf(heat), 54, fontColor);
        String efficiency = I18n.func_74837_a((String)"gui.container.fusion_core.efficiency", (Object[])new Object[0]) + " " + (int)this.tile.efficiency + "%";
        this.field_146289_q.func_78276_b(efficiency, 108 - this.widthHalf(efficiency), 65, fontColor);
        String string = fluid0 != null ? fluid0.getLocalizedName() : (input1 = fluid6 != null ? fluid6.getLocalizedName() : I18n.func_74837_a((String)"gui.container.fusion_core.empty", (Object[])new Object[0]));
        String input2 = fluid1 != null ? fluid1.getLocalizedName() : (fluid7 != null ? fluid7.getLocalizedName() : I18n.func_74837_a((String)"gui.container.fusion_core.empty", (Object[])new Object[0]));
        this.field_146289_q.func_78276_b(input1, 108 - this.widthHalf(input1), 76, fontColor);
        this.field_146289_q.func_78276_b(input2, 108 - this.widthHalf(input2), 87, fontColor);
        this.drawTooltip(I18n.func_74837_a((String)"gui.container.change_tanks_mode", (Object[])new Object[0]), mouseX, mouseY, 195, 5, 18, 18);
        this.drawFluidTooltip(fluid0, this.tile.tanks[0], mouseX, mouseY, 38, 6, 6, 46);
        this.drawFluidTooltip(fluid1, this.tile.tanks[1], mouseX, mouseY, 38, 55, 6, 46);
        this.drawFluidTooltip(fluid2, this.tile.tanks[2], mouseX, mouseY, 172, 6, 6, 46);
        this.drawFluidTooltip(fluid3, this.tile.tanks[3], mouseX, mouseY, 182, 6, 6, 46);
        this.drawFluidTooltip(fluid4, this.tile.tanks[4], mouseX, mouseY, 172, 55, 6, 46);
        this.drawFluidTooltip(fluid5, this.tile.tanks[5], mouseX, mouseY, 182, 55, 6, 46);
        this.drawEnergyTooltip(this.tile, mouseX, mouseY, 8, 6, 6, 95);
        this.drawHeatTooltip(mouseX, mouseY, 18, 6, 6, 95);
        this.drawEfficiencyTooltip(mouseX, mouseY, 28, 6, 6, 95);
    }

    @Override
    public List<String> energyInfo(ITileEnergy tile) {
        String energy = NCMath.prefix(tile.getStorage().getEnergyStored(), tile.getStorage().getMaxEnergyStored(), 5, "RF");
        String power = NCMath.prefix(this.tile.getProcessPower(), 5, "RF/t");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.energy_stored", (Object[])new Object[0]) + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.power_gen", (Object[])new Object[0]) + TextFormatting.WHITE + " " + power});
    }

    public List<String> heatInfo() {
        String heat = NCMath.prefix((int)this.tile.heat, (int)this.tile.getMaxHeat(), 5, "K", 1);
        return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + I18n.func_74837_a((String)"gui.container.fusion_core.temperature", (Object[])new Object[0]) + TextFormatting.WHITE + " " + heat});
    }

    public void drawHeatTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, x, y, width, height);
    }

    public List<String> efficiencyInfo() {
        String efficiency = (int)this.tile.efficiency + "%";
        return Lists.newArrayList((Object[])new String[]{TextFormatting.AQUA + I18n.func_74837_a((String)"gui.container.fusion_core.efficiency", (Object[])new Object[0]) + TextFormatting.WHITE + " " + efficiency});
    }

    public void drawEfficiencyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.efficiencyInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        double energy = Math.round((double)this.tile.storage.getEnergyStored() / (double)this.tile.storage.getMaxEnergyStored() * 95.0);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 95 - (int)energy, 218, 185 - (int)energy, 6, (int)energy);
        double h = Math.round(this.tile.heat / this.tile.getMaxHeat() * 95.0);
        this.func_73729_b(this.field_147003_i + 18, this.field_147009_r + 6 + 95 - (int)h, 224, 185 - (int)h, 6, (int)h);
        double efficiency = Math.round(this.tile.efficiency / 100.0 * 95.0);
        this.func_73729_b(this.field_147003_i + 28, this.field_147009_r + 6 + 95 - (int)efficiency, 230, 185 - (int)efficiency, 6, (int)efficiency);
        ++tick;
        if ((tick %= 10) == 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 0, "nc.gui.generator.GuiFusionCore", "fluid0"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 1, "nc.gui.generator.GuiFusionCore", "fluid1"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 2, "nc.gui.generator.GuiFusionCore", "fluid2"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 3, "nc.gui.generator.GuiFusionCore", "fluid3"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 4, "nc.gui.generator.GuiFusionCore", "fluid4"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 5, "nc.gui.generator.GuiFusionCore", "fluid5"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 6, "nc.gui.generator.GuiFusionCore", "fluid6"));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFluidInTank(this.tile.func_174877_v(), 7, "nc.gui.generator.GuiFusionCore", "fluid7"));
        }
        GuiFluidRenderer.renderGuiTank(fluid0, this.tile.tanks[0].getCapacity(), this.field_147003_i + 38, this.field_147009_r + 6, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid1, this.tile.tanks[1].getCapacity(), this.field_147003_i + 38, this.field_147009_r + 55, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid2, this.tile.tanks[2].getCapacity(), this.field_147003_i + 172, this.field_147009_r + 6, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid3, this.tile.tanks[3].getCapacity(), this.field_147003_i + 182, this.field_147009_r + 6, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid4, this.tile.tanks[4].getCapacity(), this.field_147003_i + 172, this.field_147009_r + 55, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid5, this.tile.tanks[5].getCapacity(), this.field_147003_i + 182, this.field_147009_r + 55, this.field_73735_i, 6.0, 46.0);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new NCGuiToggleButton.ToggleTanksSharedButton(0, this.field_147003_i + 195, this.field_147009_r + 5, this.tile, true));
        this.field_146292_n.add(new NCGuiButton.BlankButton(1, this.field_147003_i + 38, this.field_147009_r + 6, 6, 46));
        this.field_146292_n.add(new NCGuiButton.BlankButton(2, this.field_147003_i + 38, this.field_147009_r + 55, 6, 46));
        this.field_146292_n.add(new NCGuiButton.BlankButton(3, this.field_147003_i + 172, this.field_147009_r + 6, 6, 46));
        this.field_146292_n.add(new NCGuiButton.BlankButton(4, this.field_147003_i + 182, this.field_147009_r + 6, 6, 46));
        this.field_146292_n.add(new NCGuiButton.BlankButton(5, this.field_147003_i + 172, this.field_147009_r + 55, 6, 46));
        this.field_146292_n.add(new NCGuiButton.BlankButton(6, this.field_147003_i + 182, this.field_147009_r + 55, 6, 46));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.func_145831_w().field_72995_K) {
            if (guiButton.field_146127_k == 0) {
                this.tile.setTanksShared(!this.tile.getTanksShared());
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleTanksSharedButton(this.tile));
            }
            for (int i = 1; i <= 6; ++i) {
                if (guiButton.field_146127_k != i || !GuiFusionCore.func_146272_n()) continue;
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketEmptyTankButton(this.tile, i - 1));
            }
        }
    }

    static {
        fluid7 = null;
    }
}

