/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.processor;

import com.google.common.collect.Lists;
import java.util.List;
import nc.container.processor.ContainerEnergyFluidProcessor;
import nc.gui.GuiNC;
import nc.gui.NCGuiButton;
import nc.tile.energy.ITileEnergy;
import nc.tile.processor.TileEnergyFluidProcessor;
import nc.util.NCMath;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public abstract class GuiEnergyFluidProcessor
extends GuiNC {
    public static int tick;
    private final InventoryPlayer playerInventory;
    protected TileEnergyFluidProcessor tile;
    protected final ResourceLocation gui_textures;

    public GuiEnergyFluidProcessor(String name, EntityPlayer player, ContainerEnergyFluidProcessor inv) {
        super(inv);
        this.playerInventory = player.field_71071_by;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/" + name + ".png");
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        ++tick;
        tick %= 10;
    }

    protected int getCookProgressScaled(double pixels) {
        double i = this.tile.func_174887_a_(0);
        double j = this.tile.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * pixels / j) : 0;
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (!this.tile.func_145831_w().field_72995_K || guiButton == null || guiButton instanceof NCGuiButton.Button) {
            // empty if block
        }
    }

    @Override
    public void drawEnergyTooltip(ITileEnergy tile, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (this.tile.baseProcessPower != 0) {
            super.drawEnergyTooltip(tile, mouseX, mouseY, x, y, width, height);
        } else {
            this.drawNoEnergyTooltip(mouseX, mouseY, x, y, width, height);
        }
    }

    @Override
    public List<String> energyInfo(ITileEnergy tile) {
        String energy = NCMath.prefix(tile.getStorage().getEnergyStored(), tile.getStorage().getMaxEnergyStored(), 5, "RF");
        String power = NCMath.prefix(this.tile.getProcessPower(), 5, "RF/t");
        String speedMultiplier = this.tile.getSpeedMultiplier() * 100 + "%";
        String powerMultiplier = this.tile.getSpeedMultiplier() * (this.tile.getSpeedMultiplier() + 1) * 50 + "%";
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.energy_stored", (Object[])new Object[0]) + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + I18n.func_74837_a((String)"gui.container.process_power", (Object[])new Object[0]) + TextFormatting.WHITE + " " + power, TextFormatting.AQUA + I18n.func_74837_a((String)"gui.container.speed_multiplier", (Object[])new Object[0]) + TextFormatting.WHITE + " " + speedMultiplier, TextFormatting.AQUA + I18n.func_74837_a((String)"gui.container.power_multiplier", (Object[])new Object[0]) + TextFormatting.WHITE + " " + powerMultiplier});
    }
}

