/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import nc.integration.jei.JEIMethods;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IIngredient;
import nc.recipe.RecipeMethods;
import nc.recipe.RecipeOreStack;
import nc.recipe.StackType;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;

public class AddRecipe<T extends BaseRecipeHandler>
implements IUndoableAction {
    public ArrayList<IIngredient> inputs;
    public ArrayList<IIngredient> outputs;
    public ArrayList extras;
    public boolean wasNull;
    public boolean wrongSize;
    public T helper;

    public AddRecipe(T helper, ArrayList<Object> inputs, ArrayList<Object> outputs, ArrayList extras) {
        this.helper = helper;
        if (helper instanceof BaseRecipeHandler && (inputs.size() != ((BaseRecipeHandler)helper).inputSizeItem + ((BaseRecipeHandler)helper).inputSizeFluid || outputs.size() != ((BaseRecipeHandler)helper).outputSizeItem + ((BaseRecipeHandler)helper).outputSizeFluid)) {
            MineTweakerAPI.logError((String)("A " + ((RecipeMethods)helper).getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<IIngredient> adaptedInputs = new ArrayList<IIngredient>();
        ArrayList<IIngredient> adaptedOutputs = new ArrayList<IIngredient>();
        for (Object input : inputs) {
            if (input == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeMethods)helper).getRecipeName()));
                this.wasNull = true;
                return;
            }
            if (input instanceof IItemStack) {
                adaptedInputs.add(((RecipeMethods)helper).buildRecipeObject(MineTweakerMC.getItemStack((IItemStack)((IItemStack)input))));
                continue;
            }
            if (input instanceof IOreDictEntry) {
                adaptedInputs.add(new RecipeOreStack(((IOreDictEntry)input).getName(), StackType.ITEM, ((IOreDictEntry)input).getAmount()));
                continue;
            }
            if (input instanceof ILiquidStack) {
                adaptedInputs.add(((RecipeMethods)helper).buildRecipeObject(MineTweakerMC.getLiquidStack((ILiquidStack)((ILiquidStack)input))));
                continue;
            }
            if (!(input instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeMethods)helper).getRecipeName(), input));
                continue;
            }
            adaptedInputs.add(((RecipeMethods)helper).buildRecipeObject(input));
        }
        for (Object output : outputs) {
            if (output == null) {
                MineTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeMethods)helper).getRecipeName()));
                this.wasNull = true;
                return;
            }
            if (output instanceof IItemStack) {
                adaptedOutputs.add(((RecipeMethods)helper).buildRecipeObject(MineTweakerMC.getItemStack((IItemStack)((IItemStack)output))));
                continue;
            }
            if (output instanceof IOreDictEntry) {
                adaptedOutputs.add(new RecipeOreStack(((IOreDictEntry)output).getName(), StackType.ITEM, ((IOreDictEntry)output).getAmount()));
                continue;
            }
            if (output instanceof ILiquidStack) {
                adaptedOutputs.add(((RecipeMethods)helper).buildRecipeObject(MineTweakerMC.getLiquidStack((ILiquidStack)((ILiquidStack)output))));
                continue;
            }
            if (!(output instanceof ItemStack)) {
                MineTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeMethods)helper).getRecipeName(), output));
                continue;
            }
            adaptedOutputs.add(((RecipeMethods)helper).buildRecipeObject(output));
        }
        this.inputs = adaptedInputs;
        this.outputs = adaptedOutputs;
        this.extras = extras;
    }

    public void apply() {
        if (!this.wasNull && !this.wrongSize) {
            boolean isShapeless = this.helper instanceof BaseRecipeHandler ? ((BaseRecipeHandler)this.helper).shapeless : true;
            Object recipe = ((RecipeMethods)this.helper).buildRecipe((ArrayList)this.inputs.clone(), (ArrayList)this.outputs.clone(), (ArrayList)this.extras.clone(), isShapeless);
            ((RecipeMethods)this.helper).addRecipe(recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(JEIMethods.createJEIRecipe(recipe, this.helper));
        } else {
            NCUtil.getLogger().error(String.format("Failed to add %s recipe (%s = %s)", ((RecipeMethods)this.helper).getRecipeName(), this.inputs, this.outputs));
        }
    }

    public void undo() {
        if (!this.wasNull && !this.wrongSize) {
            ArrayList values = BaseRecipeHandler.getValuesFromList(this.inputs);
            Object recipe = ((RecipeMethods)this.helper).getRecipeFromInputs(values.toArray());
            if (recipe == null) {
                MineTweakerAPI.logError((String)String.format("%s: Adding Recipe - Couldn't find matching recipe %s", ((RecipeMethods)this.helper).getRecipeName(), values));
                return;
            }
            boolean removed = ((RecipeMethods)this.helper).removeRecipe(recipe);
            if (!removed) {
                MineTweakerAPI.logError((String)String.format("%s: Adding Recipe - Failed to remove recipe %s", ((RecipeMethods)this.helper).getRecipeName(), values));
            } else {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(JEIMethods.createJEIRecipe(recipe, this.helper));
            }
        } else {
            NCUtil.getLogger().error(String.format("Adding Recipe - Failed to remove %s recipe (%s = %s)", ((RecipeMethods)this.helper).getRecipeName(), this.inputs, this.outputs));
        }
    }

    public String describe() {
        Object[] objectArray = new Object[3];
        objectArray[0] = ((RecipeMethods)this.helper).getRecipeName();
        objectArray[1] = BaseRecipeHandler.getValuesFromList(this.inputs);
        objectArray[2] = BaseRecipeHandler.getValuesFromList(this.outputs);
        return String.format("Adding %s recipe (%s = %s)", objectArray);
    }

    public String describeUndo() {
        return String.format("Reverting /%s/", this.describe());
    }

    public boolean canUndo() {
        return true;
    }

    public Object getOverrideKey() {
        return null;
    }
}

