/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.integration.jei.IJEIHandler;
import nc.integration.jei.JEICategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public abstract class BaseCategory
extends JEICategory {
    private final IDrawable background;
    protected final IDrawableAnimated arrow;
    protected final String recipeTitle;
    protected final int backPosX;
    protected final int backPosY;
    protected final int arrowDrawPosX;
    protected final int arrowDrawPosY;

    public BaseCategory(IGuiHelper guiHelper, IJEIHandler handler, String title, int time, int backX, int backY, int backWidth, int backHeight, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY) {
        this(guiHelper, handler, title, "", time, backX, backY, backWidth, backHeight, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY);
    }

    public BaseCategory(IGuiHelper guiHelper, IJEIHandler handler, String title, String guiExtra, int time, int backX, int backY, int backWidth, int backHeight, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY) {
        super(handler);
        ResourceLocation location = new ResourceLocation("nuclearcraft:textures/gui/container/" + handler.getTextureName() + guiExtra + ".png");
        this.background = guiHelper.createDrawable(location, backX, backY, backWidth, backHeight);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, arrowWidth, arrowHeight);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 1 + time / 4, IDrawableAnimated.StartDirection.LEFT, false);
        this.recipeTitle = title;
        this.backPosX = backX + 1;
        this.backPosY = backY + 1;
        this.arrowDrawPosX = arrowPosX - backX;
        this.arrowDrawPosY = arrowPosY - backY;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public abstract void setRecipe(IRecipeLayout var1, IRecipeWrapper var2, IIngredients var3);

    public String getTitle() {
        return I18n.func_74837_a((String)("tile." + this.recipeTitle + ".name"), (Object[])new Object[0]);
    }
}

