/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import nc.integration.jei.IJEIRecipeBuilder;
import nc.integration.jei.JEIRecipe;
import nc.recipe.BaseRecipeHandler;
import nc.recipe.IRecipe;
import nc.recipe.SorptionType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class JEIMethods {
    public static List<IJEIRecipeBuilder> recipeBuilders = new ArrayList<IJEIRecipeBuilder>();

    public static void registerRecipeBuilder(IJEIRecipeBuilder builder) {
        recipeBuilders.add(builder);
    }

    public static Object createJEIRecipe(IRecipe recipe, BaseRecipeHandler<IRecipe> helper) {
        for (IJEIRecipeBuilder builder : recipeBuilders) {
            Object build = builder.buildRecipe(recipe, helper);
            if (build == null) continue;
            return build;
        }
        return null;
    }

    public static ArrayList<JEIRecipe> getJEIRecipes(BaseRecipeHandler recipeHelper, Class<? extends JEIRecipe> recipeClass) {
        ArrayList<JEIRecipe> recipes = new ArrayList<JEIRecipe>();
        if (recipeHelper != null && recipeHelper instanceof BaseRecipeHandler) {
            BaseRecipeHandler helper = recipeHelper;
            for (IRecipe recipe : helper.getRecipes()) {
                try {
                    recipes.add(recipeClass.getConstructor(BaseRecipeHandler.class, IRecipe.class).newInstance(helper, recipe));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return recipes;
    }

    public static class RecipeFluidMapping {
        public int slotPos;
        public int xPos;
        public int yPos;
        public int xSize;
        public int ySize;

        public RecipeFluidMapping(int slotPos, int xPos, int yPos, int xSize, int ySize) {
            this.slotPos = slotPos;
            this.xPos = xPos;
            this.yPos = yPos;
            this.xSize = xSize;
            this.ySize = ySize;
        }
    }

    public static class RecipeItemMapping {
        public int slotPos;
        public int xPos;
        public int yPos;

        public RecipeItemMapping(int slotPos, int xPos, int yPos) {
            this.slotPos = slotPos;
            this.xPos = xPos;
            this.yPos = yPos;
        }
    }

    public static class RecipeFluidMapper {
        public Map<SorptionType, Map<Integer, RecipeFluidMapping>> map = new HashMap<SorptionType, Map<Integer, RecipeFluidMapping>>();

        public void map(SorptionType type, int recipePos, int slotPos, int xPos, int yPos, int xSize, int ySize) {
            this.map(type, recipePos, new RecipeFluidMapping(slotPos, xPos, yPos, xSize, ySize));
        }

        public void map(SorptionType type, int recipePos, RecipeFluidMapping mapping) {
            if (this.map.get((Object)type) == null) {
                this.map.put(type, new HashMap());
            }
            this.map.get((Object)type).put(recipePos, mapping);
        }

        public void mapFluidsTo(IGuiFluidStackGroup fluids, IIngredients ingredients) {
            for (Map.Entry<SorptionType, Map<Integer, RecipeFluidMapping>> entry : this.map.entrySet()) {
                List objects = entry.getKey() == SorptionType.INPUT ? ingredients.getInputs(FluidStack.class) : ingredients.getOutputs(FluidStack.class);
                for (Map.Entry<Integer, RecipeFluidMapping> mapping : entry.getValue().entrySet()) {
                    RecipeFluidMapping recipe = mapping.getValue();
                    Object obj = objects.get(mapping.getKey());
                    if (obj instanceof List) {
                        fluids.init(recipe.slotPos, entry.getKey() == SorptionType.INPUT, recipe.xPos + 1, recipe.yPos + 1, recipe.xSize, recipe.ySize, ((FluidStack)((List)obj).get((int)0)).amount, true, null);
                        fluids.set(recipe.slotPos, (List)obj);
                        continue;
                    }
                    fluids.init(recipe.slotPos, entry.getKey() == SorptionType.INPUT, recipe.xPos + 1, recipe.yPos + 1, recipe.xSize, recipe.ySize, ((FluidStack)obj).amount, true, null);
                    fluids.set(recipe.slotPos, (FluidStack)obj);
                }
            }
        }
    }

    public static class RecipeItemMapper {
        public Map<SorptionType, Map<Integer, RecipeItemMapping>> map = new HashMap<SorptionType, Map<Integer, RecipeItemMapping>>();

        public void map(SorptionType type, int recipePos, int slotPos, int xPos, int yPos) {
            this.map(type, recipePos, new RecipeItemMapping(slotPos, xPos, yPos));
        }

        public void map(SorptionType type, int recipePos, RecipeItemMapping mapping) {
            if (this.map.get((Object)type) == null) {
                this.map.put(type, new HashMap());
            }
            this.map.get((Object)type).put(recipePos, mapping);
        }

        public void mapItemsTo(IGuiItemStackGroup items, IIngredients ingredients) {
            for (Map.Entry<SorptionType, Map<Integer, RecipeItemMapping>> entry : this.map.entrySet()) {
                List objects = entry.getKey() == SorptionType.INPUT ? ingredients.getInputs(ItemStack.class) : ingredients.getOutputs(ItemStack.class);
                for (Map.Entry<Integer, RecipeItemMapping> mapping : entry.getValue().entrySet()) {
                    RecipeItemMapping recipe = mapping.getValue();
                    items.init(recipe.slotPos, entry.getKey() == SorptionType.INPUT, recipe.xPos, recipe.yPos);
                    Object obj = objects.get(mapping.getKey());
                    if (obj instanceof List) {
                        items.set(recipe.slotPos, (List)obj);
                        continue;
                    }
                    items.set(recipe.slotPos, (ItemStack)obj);
                }
            }
        }
    }
}

