/*
 * Decompiled with CFR 0.152.
 */
package nc.network;

import io.netty.buffer.ByteBuf;
import nc.tile.fluid.ITileFluid;
import nc.util.NCUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketEmptyTankButton
implements IMessage {
    boolean messageValid;
    BlockPos pos;
    int tankNo;

    public PacketEmptyTankButton() {
        this.messageValid = false;
    }

    public PacketEmptyTankButton(ITileFluid machine, int tankNo) {
        this.pos = machine.getBlockPos();
        this.tankNo = tankNo;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.tankNo = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tankNo);
    }

    public static class Handler
    implements IMessageHandler<PacketEmptyTankButton, IMessage> {
        public IMessage onMessage(PacketEmptyTankButton message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(PacketEmptyTankButton message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos);
            if (tile == null) {
                return;
            }
            if (tile instanceof ITileFluid) {
                ITileFluid machine = (ITileFluid)tile;
                machine.clearTank(message.tankNo);
                ctx.getServerHandler().field_147369_b.func_71121_q().func_175625_s(message.pos).func_70296_d();
            }
        }
    }
}

