/*
 * Decompiled with CFR 0.152.
 */
package nc.network;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import nc.util.NCUtil;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnFluidInTank
implements IMessage {
    boolean messageValid;
    FluidStack fluid;
    String className;
    String fluidFieldName;

    public PacketReturnFluidInTank() {
        this.messageValid = false;
    }

    public PacketReturnFluidInTank(FluidStack fluid, String className, String fluidFieldName) {
        this.fluid = fluid;
        this.className = className;
        this.fluidFieldName = fluidFieldName;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int fluidAmount = buf.readInt();
            this.fluid = fluidName != "nullFluid" && fluidAmount != 0 ? new FluidStack(FluidRegistry.getFluid((String)fluidName), fluidAmount) : null;
            this.className = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.fluidFieldName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.fluid != null ? this.fluid.getFluid().getName() : "nullFluid"));
        buf.writeInt(this.fluid != null ? this.fluid.amount : 0);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.className);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fluidFieldName);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnFluidInTank, IMessage> {
        public IMessage onMessage(PacketReturnFluidInTank message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            return null;
        }

        void processMessage(PacketReturnFluidInTank message) {
            try {
                Class<?> clazz = Class.forName(message.className);
                Field fluidField = clazz.getDeclaredField(message.fluidFieldName);
                fluidField.set(clazz, message.fluid);
            }
            catch (Exception e) {
                NCUtil.getLogger().catching((Throwable)e);
            }
        }
    }
}

