/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import java.util.ArrayList;
import java.util.List;
import nc.recipe.IIngredient;
import nc.recipe.IRecipeStack;
import nc.recipe.SorptionType;
import nc.recipe.StackType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeOreStack
implements IIngredient,
IRecipeStack {
    public String oreString;
    public boolean isFluid;
    public ArrayList<ItemStack> cachedItemRegister;
    public ArrayList<FluidStack> cachedFluidRegister;
    public int stackSize;

    public RecipeOreStack(String oreType, StackType stacktype, int stackSize) {
        this.oreString = oreType;
        this.cachedItemRegister = new ArrayList(OreDictionary.getOres((String)oreType));
        this.cachedFluidRegister = new ArrayList();
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        for (Fluid fluid : fluidList) {
            if (fluid.getName() != oreType.toLowerCase()) continue;
            this.cachedFluidRegister.add(new FluidStack(fluid, stackSize));
        }
        if (this.cachedFluidRegister.isEmpty() && stacktype.isFluid() && FluidRegistry.getFluid((String)oreType.toLowerCase()) != null) {
            this.cachedFluidRegister.add(new FluidStack(FluidRegistry.getFluid((String)oreType.toLowerCase()), stackSize));
        }
        this.isFluid = !stacktype.isItem() && !stacktype.isFluid() ? this.cachedItemRegister.isEmpty() : stacktype.isFluid();
        this.stackSize = stackSize;
    }

    @Override
    public Object getIngredient() {
        if (this.isFluid) {
            FluidStack fluid = this.cachedFluidRegister.get(0).copy();
            fluid.amount = this.stackSize;
            return fluid;
        }
        ItemStack item = this.cachedItemRegister.get(0).func_77946_l();
        item.field_77994_a = this.stackSize;
        return item;
    }

    @Override
    public Object getOutputStack() {
        FluidStack stack;
        Object object = stack = this.isFluid ? this.cachedFluidRegister.get(0).copy() : this.cachedItemRegister.get(0).func_77946_l();
        if (this.isFluid) {
            FluidStack fluidstack = stack;
            fluidstack.amount = this.stackSize;
            return fluidstack;
        }
        ItemStack itemstack = (ItemStack)stack;
        itemstack.field_77994_a = this.stackSize;
        return itemstack;
    }

    @Override
    public boolean matches(Object object, SorptionType type) {
        if (object instanceof RecipeOreStack) {
            RecipeOreStack oreStack = (RecipeOreStack)object;
            if (oreStack.oreString.equals(this.oreString) && oreStack.stackSize >= this.stackSize) {
                return true;
            }
        } else {
            String fluidName;
            if (object instanceof String) {
                return this.oreString.equals(object);
            }
            if (object instanceof ItemStack && type.checkStackSize(this.stackSize, ((ItemStack)object).field_77994_a)) {
                int oreID = OreDictionary.getOreID((String)this.oreString);
                for (int ID : OreDictionary.getOreIDs((ItemStack)((ItemStack)object))) {
                    if (oreID != ID) continue;
                    return true;
                }
            } else if (object instanceof FluidStack && type.checkStackSize(this.stackSize, ((FluidStack)object).amount) && this.oreString == (fluidName = FluidRegistry.getFluidName((FluidStack)((FluidStack)object)))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }

    @Override
    public List<Object> getIngredientList() {
        if (this.isFluid) {
            ArrayList<Object> fluidCollection = new ArrayList<Object>();
            for (FluidStack fluid : this.cachedFluidRegister) {
                FluidStack fluidStack = fluid.copy();
                fluidStack.amount = this.stackSize;
                fluidCollection.add(fluidStack);
            }
            return fluidCollection;
        }
        ArrayList<Object> itemCollection = new ArrayList<Object>();
        for (ItemStack item : this.cachedItemRegister) {
            ItemStack itemStack = item.func_77946_l();
            itemStack.field_77994_a = this.stackSize;
            itemCollection.add(itemStack);
        }
        return itemCollection;
    }
}

