/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.BaseRecipeHandler;
import nc.util.NCUtil;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class IngotFormerRecipes
extends BaseRecipeHandler {
    private static final IngotFormerRecipes RECIPES = new IngotFormerRecipes();

    public IngotFormerRecipes() {
        super(0, 1, 1, 0, false);
    }

    public static final IngotFormerRecipes instance() {
        return RECIPES;
    }

    @Override
    public void addRecipes() {
        this.ingotForm();
        this.ingotForm("Manyullyn");
        this.ingotForm("Alubrass");
        this.ingotForm("Pigiron");
        this.ingotForm("Brass");
        this.ingotForm("Bronze");
        this.ingotForm("Electrum");
        this.ingotForm("Steel");
    }

    public void ingotForm(String metal) {
        this.addRecipe(this.fluidStack(metal.toLowerCase(), 144), "ingot" + metal, NCConfig.processor_time[10]);
    }

    public void ingotForm() {
        List<String> oreList = Arrays.asList(OreDictionary.getOreNames());
        ArrayList fluidValueList = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        ArrayList<String> fluidList = new ArrayList<String>();
        for (Fluid fluid : fluidValueList) {
            fluidList.add(fluid.getName());
        }
        for (String fluidName : fluidList) {
            String ingot = "ingot" + NCUtil.capitalize(fluidName);
            if (!oreList.contains(ingot)) continue;
            this.addRecipe(this.fluidStack(fluidName, 144), ingot, NCConfig.processor_time[10]);
        }
    }

    @Override
    public String getRecipeName() {
        return "ingot_former";
    }
}

