/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import nc.config.NCConfig;
import nc.recipe.BaseRecipeHandler;

public class IsotopeSeparatorRecipes
extends BaseRecipeHandler {
    private static final IsotopeSeparatorRecipes RECIPES = new IsotopeSeparatorRecipes();

    public IsotopeSeparatorRecipes() {
        super(1, 0, 2, 0, false);
    }

    public static final IsotopeSeparatorRecipes instance() {
        return RECIPES;
    }

    @Override
    public void addRecipes() {
        this.addRecipe("ingotThorium", this.oreStack("ingotThorium232", 2), this.oreStack("tinyThorium230", 2), NCConfig.processor_time[1]);
        this.addRecipe("ingotThoriumOxide", this.oreStack("ingotThorium232Oxide", 2), this.oreStack("tinyThorium230Oxide", 2), NCConfig.processor_time[1]);
        this.addRecipe("ingotUranium", this.oreStack("ingotUranium238Base", 2), this.oreStack("tinyUranium235", 2), NCConfig.processor_time[1]);
        this.addRecipe("ingotUraniumOxide", this.oreStack("ingotUranium238Oxide", 2), this.oreStack("tinyUranium235Oxide", 2), NCConfig.processor_time[1]);
        this.addRecipe("dustThorium", this.oreStack("ingotThorium232", 2), this.oreStack("tinyThorium230", 2), NCConfig.processor_time[1]);
        this.addRecipe("dustThoriumOxide", this.oreStack("ingotThorium232Oxide", 2), this.oreStack("tinyThorium230Oxide", 2), NCConfig.processor_time[1]);
        this.addRecipe("dustUranium", this.oreStack("ingotUranium238Base", 2), this.oreStack("tinyUranium235", 2), NCConfig.processor_time[1]);
        this.addRecipe("dustUraniumOxide", this.oreStack("ingotUranium238Oxide", 2), this.oreStack("tinyUranium235Oxide", 2), NCConfig.processor_time[1]);
        this.addRecipe("ingotYellorium", "ingotUranium238Base", "tinyUranium235", NCConfig.processor_time[1]);
        this.addRecipe("dustYellorium", "ingotUranium238Base", "tinyUranium235", NCConfig.processor_time[1]);
        this.addRecipe("ingotBlutonium", "ingotPlutonium242Base", "tinyPlutonium239", NCConfig.processor_time[1]);
        this.addRecipe("dustBlutonium", "ingotPlutonium242Base", "tinyPlutonium239", NCConfig.processor_time[1]);
        this.addRecipe("ingotPlutonium", this.oreStack("ingotPlutonium242Base", 2), this.oreStack("tinyPlutonium239", 2), NCConfig.processor_time[1]);
        this.addRecipe("dustPlutonium", this.oreStack("ingotPlutonium242Base", 2), this.oreStack("tinyPlutonium239", 2), NCConfig.processor_time[1]);
        this.addRecipe("ingotBoron", "ingotBoron11", this.oreStack("tinyBoron10", 3), NCConfig.processor_time[1]);
        this.addRecipe("ingotLithium", "ingotLithium7", this.oreStack("tinyLithium6", 3), NCConfig.processor_time[1]);
        this.addRecipe("dustBoron", "ingotBoron11", this.oreStack("tinyBoron10", 3), NCConfig.processor_time[1]);
        this.addRecipe("dustLithium", "ingotLithium7", this.oreStack("tinyLithium6", 3), NCConfig.processor_time[1]);
        this.addRecipe("fuelTBU", this.oreStack("ingotThorium232", 5), this.oreStack("ingotThorium232", 4), NCConfig.processor_time[1]);
        this.addRecipe("fuelTBUOxide", this.oreStack("ingotThorium232Oxide", 5), this.oreStack("ingotThorium232Oxide", 4), NCConfig.processor_time[1]);
        this.addRecipe("fuelRodTBU", this.oreStack("ingotThorium232", 5), this.oreStack("ingotThorium232", 4), NCConfig.processor_time[1]);
        this.addRecipe("fuelRodTBUOxide", this.oreStack("ingotThorium232Oxide", 5), this.oreStack("ingotThorium232Oxide", 4), NCConfig.processor_time[1]);
        this.addRecipe("fuelMOX239", this.oreStack("ingotUranium238Base", 8), this.oreStack("ingotPlutonium239Oxide", 1), NCConfig.processor_time[1]);
        this.addRecipe("fuelMOX241", this.oreStack("ingotUranium238Base", 8), this.oreStack("ingotPlutonium241Oxide", 1), NCConfig.processor_time[1]);
        this.addRecipe("fuelRodMOX239", this.oreStack("ingotUranium238Base", 8), this.oreStack("ingotPlutonium239Oxide", 1), NCConfig.processor_time[1]);
        this.addRecipe("fuelRodMOX241", this.oreStack("ingotUranium238Base", 8), this.oreStack("ingotPlutonium241Oxide", 1), NCConfig.processor_time[1]);
        this.fuelSeparate("U", "Uranium", 238, 233, 235);
        this.fuelSeparate("N", "Neptunium", 237, 236);
        this.fuelSeparate("P", "Plutonium", 242, 239, 241);
        this.fuelSeparate("A", "Americium", 243, 242);
        this.fuelSeparate("Cm", "Curium", 246, 243, 245, 247);
        this.fuelSeparate("B", "Berkelium", 247, 248);
        this.fuelSeparate("Cf", "Californium", 252, 249, 251);
    }

    public void fuelSeparate(String fuel, String element, int fertile, int ... fissiles) {
        for (String form : new String[]{"fuel", "fuelRod"}) {
            for (int fissile : fissiles) {
                for (String type : new String[]{"LE", "HE"}) {
                    for (String oxide : new String[]{"", "Oxide"}) {
                        this.addRecipe(form + type + fuel + fissile + oxide, this.oreStack("ingot" + element + fertile + (oxide == "" ? "Base" : ""), type == "LE" ? 8 : 5), this.oreStack("ingot" + element + fissile + oxide, type == "LE" ? 1 : 4), NCConfig.processor_time[1]);
                    }
                }
            }
        }
    }

    @Override
    public String getRecipeName() {
        return "isotope_separator";
    }
}

