/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import java.util.Arrays;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.BaseRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ManufactoryRecipes
extends BaseRecipeHandler {
    private static final ManufactoryRecipes RECIPES = new ManufactoryRecipes();

    public ManufactoryRecipes() {
        super(1, 0, 1, 0, false);
    }

    public static final ManufactoryRecipes instance() {
        return RECIPES;
    }

    @Override
    public void addRecipes() {
        if (NCConfig.ore_processing) {
            this.oreProcess();
        }
        this.addRecipe("gemCoal", "dustGraphite", NCConfig.processor_time[0]);
        this.addRecipe("dustCoal", "dustGraphite", NCConfig.processor_time[0]);
        this.addRecipe("dustGraphite", "dustCoal", NCConfig.processor_time[0]);
        this.addRecipe("gemDiamond", "dustDiamond", NCConfig.processor_time[0] * 2);
        this.addRecipe("gemRhodochrosite", "dustRhodochrosite", NCConfig.processor_time[0] * 2);
        this.addRecipe("gemQuartz", "dustQuartz", NCConfig.processor_time[0]);
        this.addRecipe("obsidian", this.oreStack("dustObsidian", 4), NCConfig.processor_time[0] * 2);
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m, 4), "itemSilicon", NCConfig.processor_time[0]);
        this.addRecipe(new ItemStack(Items.field_151078_bh, 4), Items.field_151116_aA, NCConfig.processor_time[0] / 2);
        this.addRecipe(new ItemStack(Items.field_151120_aE, 4), "bioplastic", NCConfig.processor_time[0]);
        this.addRecipe("gemBoronNitride", "dustBoronNitride", NCConfig.processor_time[0] * 2);
        this.addRecipe("gemFluorite", "dustFluorite", NCConfig.processor_time[0] * 2);
    }

    public void oreProcess() {
        List<String> oreList = Arrays.asList(OreDictionary.getOreNames());
        for (String ore : oreList) {
            if (!ore.startsWith("ore")) continue;
            String dust = "dust" + ore.substring(3);
            String ingot = "ingot" + ore.substring(3);
            if (!oreList.contains(dust) || !oreList.contains(ingot)) continue;
            this.addRecipe(this.oreStack(ore, 1), this.oreStack(dust, 2), NCConfig.processor_time[0]);
        }
    }

    @Override
    public String getRecipeName() {
        return "manufactory";
    }
}

